$(document).ready(function() {  
   
    $(".date-picker").prop("readonly", true);
    
    $('form').on('focus', 'input[type=number]', function (e) {
        $(this).on('mousewheel.disableScroll', function (e) {
            e.preventDefault();
        });
    });
    
    // setInterval(function(){ 
    //     $.ajax({
    //         url: BASE_URL+"get_pending_approvals_count",
    //         type: "POST",
    //         success: function (response) {
    //             $('#approval_count').html(response);
    //         }
    //     });
    // }, 5000);
    
    $("#admin_login").validate({
        rules: {  
            username: {
                required: true
            },
            password: {
                required: true,
                minlength: 3
            }
        },
        // Specify the validation error messages
        messages: {                        
            password: {
                required: "Please enter your password.",
                minlength: "Your password must be at least 3 characters long"
            },
            username: "Please enter your username"
        },
        submitHandler: function (form) {
        
            $.ajax({
                url: BASE_URL+"admin_login",
                type: "POST",
                data: $("#admin_login").serialize(),
                success: function (response) {
                    
                    
                    console.log('response.status = '+response.status);
                    
                    if (jQuery.trim(response.status) === '2') {
                        $("#success_modal").modal("show");
                    } else if (jQuery.trim(response.status) === '1') {
                        if (jQuery.trim(response.user_type) != '6') {
                            window.location.href = BASE_URL+"dashboard";
                        }else{
                            window.location.href = BASE_URL+"director_dashboard";
                        }
                    }
                }
            });
        }
    });
    
    $("#edit_user").validate({
        rules: {  
            contact_name: {
                required: true
            },
            contact_num: {
                required: true,
                maxlength: 10,
                number: true
            },
            username: {
                required: true
            },
            user_type: {
                required: true
            },
        },
        // Specify the validation error messages
        messages: { 
            contact_name: "Please enter your contact name",                       
            contact_num: {
                required: "Please enter your contact number.",
                maxength: "Your provide a valid contact number"
            },
            username: "Please enter your username",
            user_type: "Please select a user type"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_user_details",
                type: "POST",
                data: $("#edit_user").serialize(),
                success: function (response) {
                    if(response.status == 1){
                        $(".loaderFull").addClass("hidden");
                        
//                        $('#success_modal').modal('show');
                        window.location.href = BASE_URL+"view_user?user_id="+response.user_id;
                        
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $('.module_type').click(function() {
//        checkedid = $(this).attr('id');
        if ($(this).is(':checked')) {
            
            var formData = {
                'privilege': $(this).attr('itemid'),
                'privilage_name': $(this).attr('privilage_name'),
                'title': $(this).attr('title'),
                'module_id': $(this).attr('id'),
                'check': '1'
            };
        }
        else {
            
            var formData = {
                'privilege': $(this).attr('itemid'),
                'privilage_name': $(this).attr('privilage_name'),
                'title': $(this).attr('title'),
                'module_id': $(this).attr('id'),
                'check': '0'
            };
        }
                    
        $.ajax({ 
            url: BASE_URL+"admin_module_update",
            type: "POST",
            data: formData,
            success: function (response) {
                $("#err_module_type").html(response);
            }
        });
    });
    
    $("#add_user").validate({
        rules: {  
            contact_name: {
                required: true
            },
            contact_num: {
                required: true,
                maxlength: 10
            },
            username: {
                required: true
            },
            password: {
                required: true
            },
            user_type: {
                required: true
            },
        },
        // Specify the validation error messages
        messages: { 
            contact_name: "Please enter your contact name",                       
            contact_num: {
                required: "Please enter your contact number.",
                maxength: "Your provide a valid contact number"
            },
            username: "Please enter your username",
            password: "Please enter your password",
            user_type: "Please select a user type"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_user_details",
                type: "POST",
                data: $("#add_user").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_user').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $('#add_username').on('focusout', function () {
        em = $('#add_username').val();

        $.ajax({
            type: "POST",
            url: BASE_URL+"check_username_exist_add",
            data: "username=" + em,
            async: false,
            success: function (response) {

                if (response.status == '1') {
                    $("#add_username_status").html("<p style='color:green'>" + response.message + " " + response.username + "</p>");
                    $("#save_add_user_details").prop("disabled",false);
                } else {
                    $("#add_username_status").html("<p style='color:red'>" + response.message + " " + response.username + "</p>");
                    $("#save_add_user_details").prop("disabled",true);
                }

            }
        });
    });
    
    $('#edit_username').on('focusout', function () {
        em = $('#edit_username').val();
        user_id = $('#user_id').val();

        $.ajax({
            type: "POST",
            url: BASE_URL+"check_username_exist_edit",
            data: "username=" + em + "&user_id=" + user_id,
            async: false,
            success: function (response) {

                if (response.status == '1') {
                    $("#edit_username_status").html("<p style='color:green'>" + response.message + " " + response.username + "</p>");
                    $("#save_add_user_details").prop("disabled",false);
                } else {
                    $("#edit_username_status").html("<p style='color:red'>" + response.message + " " + response.username + "</p>");
                    $("#save_add_user_details").prop("disabled",true);
                }

            }
        });
    });

    $('#btn_change_password').click(function(){
        
        var password = $('#password').val();
        var con_password = $('#con_password').val();
         
        if(password == con_password){
            $.ajax({
                url: BASE_URL+"change_user_password",
                type: "POST",
                data: $("#form_user_password").serialize(),
                success: function (response) {
                    if(response.status == 1){
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }else{
            var message = 'Password & Confirm Password doesnot match. Please check again';
            $("#response_msg").html("<div class='alert alert-danger'><strong>Error!</strong>"+message+"</div>");
        }
    });
    
    $("#add_customer").validate({
        rules: {  
            customer_name: {
                required: true
            },
//            contact_num: {
//                required: true,
//                maxlength: 10
//            },
            customer_type: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            customer_name: "Please enter your contact name",                       
//            contact_num: {
//                required: "Please enter your contact number.",
//                maxength: "Your provide a valid contact number"
//            },
            customer_type: "Please select a customer type"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_customer_details",
                type: "POST",
                data: $("#add_customer").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_customer').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#edit_customer").validate({
        rules: {  
            customer_name: {
                required: true
            },
//            contact_num: {
//                required: true,
//                maxlength: 10,
//                number: true
//            },
            customer_type: {
                required: true
            },
        },
        // Specify the validation error messages
        messages: { 
            customer_name: "Please enter your contact name",                       
//            contact_num: {
//                required: "Please enter your contact number.",
//                maxength: "Your provide a valid contact number"
//            },
            customer_type: "Please select a customer type"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_customer_details",
                type: "POST",
                data: $("#edit_customer").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#customer_success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $('#sales_add_customer').on("change", function () {
        var add_customer = $(this).find('option:selected').val();
        
        if(add_customer == 'Add New Customer'){
            $("#add_new_customer").removeClass("hidden");
            $("#div_customer_details").addClass("hidden");
            
        }else if(add_customer == ''){
            $("#add_new_customer").addClass("hidden");
            $("#div_customer_details").addClass("hidden");
            
        }else{
            $("#add_new_customer").addClass("hidden");
            $("#div_customer_details").removeClass("hidden");
            
            $.ajax({
                url: BASE_URL+"ajax_get_customer_details",
                type: "POST",
                data: "customer_id=" + add_customer,
                success: function (response) {
                    $("#txt_cus_contact_num").val(response.contact_number);
                    $("#txt_cus_tel_num").val(response.tel_number);
                    $("#txt_cus_type").val(response.customer_type);
                    if(response.customer_status == 4){
                        $("#div_hold_on_customer").removeClass("hidden");
                        $("#do_sales_submit_btn").addClass("hidden");
                        $("#hold_on_customer_msg").html('This Customer has pending payments. Cannot create invoice to this customer.');
                    }else if(response.customer_status == 2){
                        $("#div_hold_on_customer").removeClass("hidden");
                        $("#do_sales_submit_btn").addClass("hidden");
                        $("#hold_on_customer_msg").html('This Customer has pending payments. Cannot create invoice to this customer.');
                    }else{
                        $("#div_hold_on_customer").addClass("hidden");
                        $("#do_sales_submit_btn").removeClass("hidden");
                        $("#hold_on_customer_msg").html('');
                        
                    }                     
                }
            }); 
        }
    });
    
    $('#sales_add_24k_customer').on("change", function () {
        var add_customer = $(this).find('option:selected').val();
        
        if(add_customer == 'Add New Customer'){
            $("#add_new_customer").removeClass("hidden");
            $("#div_customer_details").addClass("hidden");
            
        }else if(add_customer == ''){
            $("#add_new_customer").addClass("hidden");
            $("#div_customer_details").addClass("hidden");
            
        }else{
            $("#add_new_customer").addClass("hidden");
            $("#div_customer_details").removeClass("hidden");
            
            $.ajax({
                url: BASE_URL+"ajax_get_24k_customer_details",
                type: "POST",
                data: "customer_id=" + add_customer,
                success: function (response) {
                    $("#txt_24k_cus_contact_num").val(response.contact_number);
                    $("#txt_24k_cus_tel_num").val(response.tel_number);                   
                }
            }); 
        }
    });
    
    $('#purchases_add_carrier').on("change", function () {
        var add_carrier = $(this).find('option:selected').val();
        
        if(add_carrier == 'Add New Carrier'){
            $("#add_new_carrier").removeClass("hidden");
            $("#div_carrier_details").addClass("hidden");
            
        }else if(add_carrier == ''){
            $("#add_new_carrier").addClass("hidden");
            $("#div_carrier_details").addClass("hidden");
            
        }else{
            $("#add_new_carrier").addClass("hidden");
            $("#div_carrier_details").removeClass("hidden");
            
            $.ajax({
                url: BASE_URL+"ajax_get_carrier_details",
                type: "POST",
                data: "carrier_id=" + add_carrier,
                success: function (response) {
                    $("#txt_car_contact_num").val(response.contact_number);
                    $("#txt_car_tel_num").val(response.tel_number);                   
                }
            }); 
        }
    });
    
    $('#add_previous_debts_sale_type').on("change", function () {
        var sale_type = $(this).find('option:selected').val();
        
        if(sale_type == 'Credit Sale'){
            $("#add_prev_debts_credit_symbol").removeClass("hidden");
            $("#add_prev_debts_gold_symbol").addClass("hidden");
            
        }else if(sale_type == 'Gold Sale'){
            $("#add_prev_debts_credit_symbol").addClass("hidden");
            $("#add_prev_debts_gold_symbol").removeClass("hidden");
            
        }
    });
    
    $('#sale_type').on("change", function () {
        var sale_type = $(this).find('option:selected').val();
        
        if(sale_type == 'Credit Sale'){
            $("#div_credit_sale").removeClass("hidden");
            $("#div_gold_sale").addClass("hidden");
            $("#div_24k_rate").removeClass("hidden");
            $("#div_una_rate").addClass("hidden");
            
            $("#div_dis_credit_sign").removeClass("hidden");
            $("#div_dis_gold_sign").addClass("hidden");
            
        }else if(sale_type == 'Gold Sale'){
            $("#div_credit_sale").addClass("hidden");
            $("#div_24k_rate").removeClass("hidden");
            $("#div_gold_sale").removeClass("hidden");
            $("#div_una_rate").removeClass("hidden");
            
            $("#div_dis_credit_sign").addClass("hidden");
            $("#div_dis_gold_sign").removeClass("hidden");
            
        }
    });
    
    $('#selling_rate_credit').live('keyup', function() {
        
        selling_rate = $(this).val();
        k_rate = $('#24k_rate').val();
        sales_grams = $('#sales_grams_credit').val();
        
        sale_amount = (selling_rate * sales_grams)/8;
        
        $("#sales_item_amount_credit").val(sale_amount.toFixed(2));
        
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#item_amount_credit").html('Rs. '+tot);
        
        selling_percentage = (selling_rate / k_rate)*100;
        
        selling_percentage = selling_percentage.toFixed(2);
        
        $("#selling_percentage_credit").val(selling_percentage);
                
    });
    
    $('#selling_percentage_credit').live('keyup', function() {
        
        selling_percentage = $(this).val();
        k_rate = $('#24k_rate').val();
        sales_grams = $('#sales_grams_credit').val();
        
        sale_amount = (k_rate * selling_percentage/100)/8 * sales_grams;
        
        $("#sales_item_amount_credit").val(sale_amount.toFixed(2));
        
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#item_amount_credit").html('Rs. '+tot);
        
        selling_rate = (k_rate * selling_percentage)/100;
        
        $("#selling_rate_credit").val(selling_rate);
                
    });
    
    $('#sales_grams_credit').live('keyup', function() {
        
        sales_grams = $(this).val();
        selling_percentage = $('#selling_percentage_credit').val();
        selling_rate = $('#selling_rate_credit').val();
        k_rate = $('#24k_rate').val();
        
        selling_percentage = (selling_rate / k_rate)*100;
        
        selling_percentage = selling_percentage.toFixed(2);
        
        $("#selling_percentage_credit").val(selling_percentage);
        
        sale_amount = (k_rate * selling_percentage/100)/8 * sales_grams;
        
        $("#sales_item_amount_credit").val(sale_amount.toFixed(2));
        
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#item_amount_credit").html('Rs. '+tot);
    });
    
    $('#24k_rate').live('keyup', function() {
        
        k_rate = $(this).val();
        selling_percentage = $('#selling_percentage_credit').val();
        sales_grams = $('#sales_grams_credit').val();
        
        sale_amount = (k_rate * selling_percentage/100)/8 * sales_grams;
        
        $("#sales_item_amount_credit").val(sale_amount.toFixed(2));
        
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#item_amount_credit").html('Rs. '+tot);
        
        selling_rate = (k_rate * selling_percentage)/100;
        
        $("#selling_rate_credit").val(selling_rate);
    });
    
    $('#sales_item_amount_credit').live('keyup', function() {
        
        amount = $(this).val();
        selling_percentage = $('#selling_percentage_credit').val();
        sales_grams = $('#sales_grams_credit').val();
        k_rate = $('#24k_rate').val();
        
        selling_rate = (amount/sales_grams)*8;
        selling_percentage = (selling_rate/k_rate)*100;
        
        $("#selling_rate_credit").val(selling_rate.toFixed(2));
        $("#selling_percentage_credit").val(selling_percentage.toFixed(7));
    });
    
    $('#sales_item_amount_gold').live('keyup', function() {
        
        amount = $(this).val();
        selling_percentage = $('#selling_percentage_gold').val();
        sales_grams = $('#sales_grams_gold').val();
        
        selling_percentage = (amount/sales_grams)*100;
        
        $("#selling_percentage_gold").val(selling_percentage.toFixed(7));
    });
    
    var credit_appended = false;
    var gold_appended = false;
    
    $('#append_SalesItem_credit').click(function(){
        
        credit_appended = true;
        
        $("#do_sales_submit_btn").removeClass("hidden");
        
        k_rate = $('#24k_rate').val();        
        selling_percentage = $('#selling_percentage_credit').val();
        selling_rate = $('#selling_rate_credit').val();
        sales_grams = $('#sales_grams_credit').val();
        item_name = $('#item_name_credit').find('option:selected').val();
        description = $('#description_credit').val();
        discount = $('#sale_discount').val();
        
        item_id = $('#item_name_credit').find('option:selected').attr('itemid');
        
        sale_amount = (k_rate * selling_percentage/100)/8 * sales_grams;
        je_c_amount = Math.round(sale_amount * 100) / 100;
        je_c_amount = (je_c_amount).toLocaleString('en');

        if(k_rate !== "" && item_name !== "" && selling_percentage !== "" && selling_rate !== "" && sales_grams !== ""){

            $('#sale-table-credit').append('<tr id="delete_sales_credit' + item_id + '">\n\\n\
            <td>'+item_name+'<input type="hidden" name="sale_data_credit[item_name][]" value="'+item_name+'"  /></td> \n\
            <td>'+description+'<input type="hidden" name="sale_data_credit[description][]" value="'+description+'"  /></td> \n\
            <td>' + selling_percentage + ' %<input type="hidden" name="sale_data_credit[selling_percentage][]" value="'+selling_percentage+'"  /></td> \n\
            <td>' + selling_rate + ' <input type="hidden" name="sale_data_credit[selling_rate][]" value="'+selling_rate+'"  /></td> \n\
            <td>' + sales_grams + ' g<input type="hidden" name="sale_data_credit[sales_grams][]" value="'+sales_grams+'"  /></td></td> \n\
            <td align="right" style="text-align: right;">Rs. '+je_c_amount+'<input type="hidden" name="sale_data_credit[sub_total][]" class="journal_c_data_credit"  value="'+sale_amount.toFixed(2)+'"  /></td>  \n\
            <td><a title="Remove Item" id="delete_sales_credit' + item_id + '" value="' +  item_name + '" text_value="' +  item_name + '" class="fa fa-trash-o delete_sales_credit"></a></td> </tr>');

            $('#item_name_credit').val('');
            $('#sales_grams_credit').val('');
            $('#description_credit').val('');
            $('#selling_percentage_credit').val('');
            $('#selling_rate_credit').val('');
            $('#item_amount_credit').html('Rs. 0.00');
            $('#sales_item_amount_credit').val('');

            var d_str = 0;

            $(".journal_c_data_credit").each(function () {
                d_str +=  parseFloat($(this).val());
            });

            d_str1 = Math.round(d_str * 100) / 100;
            d_str1 = (d_str1).toLocaleString('en'); 

            $("#debit_sum_credit").html('Rs. '+d_str1);
            $("#debit_sum_txt_credit").val(d_str.toFixed(2));
            
            $("#txt_total").val(d_str);
            $("#total").html('Rs. '+d_str1);
            
            if(discount != ''){
                discount = parseFloat(discount);
                grand_total = d_str - discount;
            }else{
                grand_total = d_str;
            }

            grand_total1 = Math.round(grand_total * 100) / 100;
            grand_total1 = (grand_total1).toLocaleString('en'); 
            
            $("#txt_grand_total").val(grand_total);
            $("#grand_total").html('Rs. '+grand_total1);
            
        }
        
    });
    
    $('.delete_sales_credit').live('click', function() {
        clas = $(this).attr('id');
        discount = $('#sale_discount').val();
        
        $('#' + clas).remove();
    
        var d_str = 0;

        $(".journal_c_data_credit").each(function () {
            d_str +=  parseFloat($(this).val());
        });

        d_str1 = Math.round(d_str * 100) / 100;
        d_str1 = (d_str1).toLocaleString('en'); 

        $("#debit_sum_credit").html('Rs. '+d_str1);
        $("#debit_sum_txt_credit").val(d_str.toFixed(2));
            
        $("#txt_total").val(d_str);
        $("#total").html('Rs. '+d_str1);
            
        if(discount != ''){
            discount = parseFloat(discount);
            grand_total = d_str - discount;
        }else{
            grand_total = d_str;
        }

        grand_total1 = Math.round(grand_total * 100) / 100;
        grand_total1 = (grand_total1).toLocaleString('en'); 

        $("#txt_grand_total").val(grand_total);
        $("#grand_total").html('Rs. '+grand_total1);
        
    });
    
    $('#sale_discount').live('keyup', function() {
        discount = $(this).val();
        total = $('#txt_total').val();
        sale_type = $('#sale_type').find('option:selected').val();

        if(discount){
            discount = parseFloat(discount);
        }else{
            discount = 0;
        }

        if(total){
            total = parseFloat(total);
        }else{
            total = 0;
        }
        
        grand_total = total - discount;
        $("#txt_grand_total").val(grand_total.toFixed(3));
        
        if(sale_type == 'Credit Sale'){

            grand_total = Math.round(grand_total * 100) / 100;
            grand_total = (grand_total).toLocaleString('en'); 

            $("#grand_total").html('Rs. '+grand_total);
            
        }else if(sale_type == 'Gold Sale'){

            $("#grand_total").html(grand_total.toFixed(3)+' g');
            
        }
    });
    
    $('#sales_grams_gold').live('keyup', function() {
        
        sales_grams = $(this).val();
        selling_percentage = $('#selling_percentage_gold').val();
        
        tot = (selling_percentage/100) * sales_grams;
        $("#sales_item_amount_gold").val(tot.toFixed(3));
        
        $("#item_amount_gold").html(tot.toFixed(3)+' g');
    });
    
    $('#selling_percentage_gold').live('keyup', function() {
        
        selling_percentage = $(this).val();
        sales_grams = $('#sales_grams_gold').val();
        
        tot = (selling_percentage/100) * sales_grams;
        $("#sales_item_amount_gold").val(tot.toFixed(3));
        
        $("#item_amount_gold").html(tot.toFixed(3)+' g');
    });
    
    $('#append_SalesItem_gold').click(function(){
        
        gold_appended = true;
        
        $("#do_sales_submit_btn").removeClass("hidden");
        
        selling_percentage = $('#selling_percentage_gold').val();
        sales_grams = $('#sales_grams_gold').val();
        item_name = $('#item_name_gold').find('option:selected').val();
        description = $('#description_gold').val();
        discount = $('#sale_discount').val();
        
        item_id = $('#item_name_credit').find('option:selected').attr('itemid');
        
        sale_amount = (selling_percentage/100) * sales_grams;
        sale_amount = sale_amount.toFixed(3);
        
        if(selling_percentage !== "" && sales_grams !== ""){

            $('#sale-table-gold').append('<tr id="delete_sales_gold' + item_id + '">\n\
            <td>'+item_name+'<input type="hidden" name="sale_data_gold[item_name][]" value="'+item_name+'"  /></td> \n\
            <td>'+description+'<input type="hidden" name="sale_data_gold[description][]" value="'+description+'"  /></td> \n\
            <td>'+selling_percentage + ' %<input type="hidden" name="sale_data_gold[selling_percentage][]" value="'+selling_percentage+'"  /></td> \n\
            <td>'+sales_grams+' g<input type="hidden" name="sale_data_gold[sales_grams][]" value="'+sales_grams+'"  /></td> \n\
            <td align="right" style="text-align: right;">'+sale_amount+' g<input type="hidden" name="sale_data_gold[sub_total][]" class="journal_c_data_gold"  value="'+sale_amount+'"  /></td>  \n\
            <td><a title="Remove Item" id="delete_sales_gold' + item_id + '" value="' +  item_name + '" text_value="' +  item_name + '" class="fa fa-trash-o delete_sales_gold"></a></td> </tr>');

            $('#sales_grams_gold').val('');
            $('#description_gold').val('');
            $('#selling_percentage_gold').val('');
            $('#item_amount_gold').html('0.000 g');
            $('#sales_item_amount_gold').val('');

            var d_str = 0;

            $(".journal_c_data_gold").each(function () {
                d_str +=  parseFloat($(this).val());
            });

            d_str = d_str.toFixed(3);

            $("#debit_sum_gold").html(d_str+' g');
            $("#debit_sum_txt_gold").val(d_str);
            
            $("#txt_total").val(d_str);
            $("#total").html(d_str+' g');
            
            if(discount != ''){
                discount = parseFloat(discount);
                grand_total = d_str - discount;
            }else{
                grand_total = d_str;
            }
            
            $("#txt_grand_total").val(grand_total.toFixed(3));
            $("#grand_total").html(grand_total.toFixed(3)+' g');

        }
        
    });
    
    $('.delete_sales_gold').live('click', function() {
        clas = $(this).attr('id');
        discount = $('#sale_discount').val();
        
        $('#' + clas).remove();
    
        var d_str = 0;

        $(".journal_c_data_gold").each(function () {
            d_str +=  parseFloat($(this).val());
        });

        d_str = d_str.toFixed(3);

        $("#debit_sum_gold").html(d_str+' g');
        $("#debit_sum_txt_gold").val(d_str);
            
        $("#txt_total").val(d_str);
        $("#total").html(d_str+' g');

        if(discount != ''){
            discount = parseFloat(discount);
            grand_total = d_str - discount;
        }else{
            grand_total = d_str;
        }

        $("#txt_grand_total").val(grand_total.toFixed(3));
        $("#grand_total").html(grand_total.toFixed(3)+' g');
        
    });
    
    $("#save_do_sale").validate({
        rules: {  
            invoice_date: {
                required: true
            },
            invoice_number: {
                required: true
            },
            sale_type: {
                required: true
            },
            select_customer: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            invoice_date: "Please select a date",   
            invoice_number: "Please enter the invoice number", 
            sale_type: "Please select a sale type",
            select_customer: "Please select a customer"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            sale_type = $('#sale_type').val(); 
            var appended = false;
            
            if(sale_type == 'Credit Sale'){
                if(credit_appended){
                    appended = true;
                }else{
                    appended = false;
                    
                }
            }else if(sale_type == 'Gold Sale'){
                if(gold_appended){
                    appended = true;
                }else{
                    appended = false;
                    
                }
                
            }
            
            if(appended){
                $(".loaderFull").removeClass("hidden");
                $.ajax({
                    url: BASE_URL+"save_do_sale",
                    type: "POST",
                    data: $("#save_do_sale").serialize(),
                    success: function (response) {
                        $(".loaderFull").addClass("hidden");
                        if(response.status == 1){
                            window.location.href = BASE_URL+"sales";
                            $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                        }else if(response.status == 0){
                            $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                        }
                    }
                });
            }else{
                $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>Please add an item before submitting the invoice</div>");
                $( "html, body" ).scrollTop( 300 );
            }            
        }
    });
    
    $('#24k_sales_grams_credit').live('keyup', function() {
        
        sales_grams = $(this).val();
        k_rate = $('#24k_sale_24k_rate').val();
        
        sale_amount = (k_rate/8) * sales_grams;                
        
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#24k_item_amount_credit").html('Rs. '+tot);
    });
    
    $('#24k_sale_24k_rate').live('keyup', function() {
        
        k_rate = $(this).val();        
        sales_grams = $('#24k_sales_grams_credit').val();
        
        sale_amount = (k_rate/8) * sales_grams;
        
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#24k_item_amount_credit").html('Rs. '+tot);
        
    });
    
    $('#append_24k_SalesItem').click(function(){
        
        credit_appended = true;
        
        $("#do_sales_submit_btn").removeClass("hidden");
        
        k_rate = $('#24k_sale_24k_rate').val();
        sales_grams = $('#24k_sales_grams_credit').val();
        item_name = $('#item_name_credit').find('option:selected').val();
        description = $('#description_credit').val();
        discount = $('#24k_sale_discount').val();
        
        item_id = $('#item_name_credit').find('option:selected').attr('itemid');
        
        sale_amount = (k_rate/8) * sales_grams;
        je_c_amount = Math.round(sale_amount * 100) / 100;
        je_c_amount = (je_c_amount).toLocaleString('en');
        
        if(sales_grams !== ""){

            $('#24k-sale-table-gold').append('<tr id="delete_24k_sale' + item_id + '">\n\
            <td>'+item_name+'<input type="hidden" name="24k_sale_data[item_name][]" value="'+item_name+'"  /></td> \n\
            <td>'+description+'<input type="hidden" name="24k_sale_data[description][]" value="'+description+'"  /></td> \n\
            <td>'+sales_grams+' g<input type="hidden" name="24k_sale_data[sales_grams][]" class="total_sale_grams" value="'+sales_grams+'"  /></td> \n\
            <td align="right" style="text-align: right;">Rs. '+je_c_amount+'<input type="hidden" name="24k_sale_data[sub_total][]" class="journal_c_data_credit" value="'+sale_amount+'"  /></td>  \n\
            <td><a title="Remove Item" id="delete_24k_sale' + item_id + '" value="' +  item_name + '" text_value="' +  item_name + '" class="fa fa-trash-o delete_24k_sale"></a></td> </tr>');

            $('#24k_sales_grams_credit').val('');
            $('#description_credit').val('');
            $('#24k_item_amount_credit').html('Rs. 0.00');

            var d_str = 0;
            var tot_gold = 0;

            $(".journal_c_data_credit").each(function () {
                d_str +=  parseFloat($(this).val());
            });

            $(".total_sale_grams").each(function () {
                tot_gold +=  parseFloat($(this).val());
            });
            
            $("#total_gold_sale").val(tot_gold);

            d_str1 = Math.round(d_str * 100) / 100;
            d_str1 = (d_str1).toLocaleString('en'); 

            $("#debit_sum_credit").html('Rs. '+d_str1);
            $("#debit_sum_txt_credit").val(d_str.toFixed(2));
            
            $("#total").val(d_str.toFixed(2));
            
            console.log('discount - '+discount);

            grand_total1 = Math.round(d_str * 100) / 100;
            grand_total1 = (grand_total1).toLocaleString('en'); 
            
            $("#grand-total").html('Rs. '+grand_total1);
            
            if(discount != ''){
                discount = parseFloat(discount);
                grand_total = d_str - discount;
            }else{
                grand_total = d_str;
            }

            grand_total1 = Math.round(grand_total * 100) / 100;
            grand_total1 = (grand_total1).toLocaleString('en'); 

            $("#txt_grand_total").val(grand_total1);
            $("#grand_total").html('Rs. '+grand_total1);

        }
        
    });
    
    $('#24k_sale_discount').live('keyup', function() {
        discount = $(this).val();
        total = $('#total').val();
        
        console.log(total);

        if(discount){
            discount = parseFloat(discount);
        }else{
            discount = 0;
        }

        if(total){
            total = parseFloat(total);
        }else{
            total = 0;
        }
        
        grand_total = total - discount;
        $("#txt_grand_total").val(grand_total.toFixed(2));

        grand_total = Math.round(grand_total * 100) / 100;
        grand_total = (grand_total).toLocaleString('en'); 

        $("#grand_total").html('Rs. '+grand_total);
    });
    
    $('.delete_24k_sale').live('click', function() {
        clas = $(this).attr('id');
        discount = $('#24k_sale_discount').val();
        
        $('#' + clas).remove();
    
        var d_str = 0;

        $(".journal_c_data_credit").each(function () {
            d_str +=  parseFloat($(this).val());
        });

        d_str1 = Math.round(d_str * 100) / 100;
        d_str1 = (d_str1).toLocaleString('en'); 

        $("#debit_sum_credit").html('Rs. '+d_str1);
        $("#debit_sum_txt_credit").val(d_str.toFixed(2));
            
        $("#total").val(d_str);
        $("#grand-total").html('Rs. '+d_str1);
            
        if(discount != ''){
            discount = parseFloat(discount);
            grand_total = d_str - discount;
        }else{
            grand_total = d_str;
        }

        grand_total1 = Math.round(grand_total * 100) / 100;
        grand_total1 = (grand_total).toLocaleString('en'); 

        $("#txt_grand_total").val(d_str);
        $("#grand_total").html('Rs. '+grand_total);
        
    });
    
    $("#save_24k_do_sale").validate({
        rules: {  
            invoice_date: {
                required: true
            },
            select_supplier: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            invoice_date: "Please select a date",   
            invoice_number: "Please enter the invoice number", 
            select_supplier: "Please select a supplier"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            sale_type = $('#sale_type').val(); 
            var appended = false;
            
            if(credit_appended){
                appended = true;
            }else{
                appended = false;

            }
            
            if(appended){
                $(".loaderFull").removeClass("hidden");
                $.ajax({
                    url: BASE_URL+"save_24k_do_sale",
                    type: "POST",
                    data: $("#save_24k_do_sale").serialize(),
                    success: function (response) {
                        $(".loaderFull").addClass("hidden");
                        if(response.status == 1){
                            window.location.href = BASE_URL+"24k_sales";
                            $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                        }else if(response.status == 0){
                            $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                        }
                    }
                });
            }else{
                $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>Please add an item before submitting the invoice</div>");
                $( "html, body" ).scrollTop( 300 );
            }            
        }
    });
    
    $('#payment_amount').on('keyup', function () {
        payment_amount = $(this).val();
        payment_total = $('#payment_total').val();
        sale_type = $('#sale_type').val(); 
        
        payment_method = $('#payment_method').val();
        
        if(payment_amount != ''){
            payment_amount = parseFloat(payment_amount);
        }else{
            payment_amount = 0;
        }
        
        if(sale_type == 'Credit Sale'){
            balance_total = parseFloat(payment_total - payment_amount);
            balance_total = balance_total.toFixed(2);
            
        }else if(sale_type == 'Gold Sale'){
            balance_total = parseFloat(payment_total - payment_amount);
            balance_total = balance_total.toFixed(3);
            
        }
        
        if(payment_method == 'Over Paid Gold'){
            
            over_paid_amount = parseFloat($('#over_paid_gold').val());
            
            if(over_paid_amount < payment_amount){
                
                $("#alert_error").removeClass("hidden");
                $("#alert_error").html("<strong>Error</strong> Entered Amount is more than Over Paid Amount");
            
                $("#div_balance_total").css('color', '#ff0000');
                $("#div_submit_button").addClass("hidden");
                
            }else {
        
                $("#alert_error").addClass("hidden");
                
                if(balance_total > 0){
                    $("#div_balance_total").css('color', '#ff0000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }else if(balance_total == 0){
                    $("#div_balance_total").css('color', '#000000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }else{
                    $("#div_balance_total").css('color', '#2d823a');

                }

            }
            
        }else if(payment_method == 'Over Paid Cash'){
            
            over_paid_amount = parseFloat($('#over_paid_cash').val());
            
            if(over_paid_amount < payment_amount){
            
                $("#alert_error").removeClass("hidden");
                $("#alert_error").html("<strong>Error</strong> Entered Amount is more than Over Paid Amount");
                
                $("#div_balance_total").css('color', '#ff0000');
                $("#div_submit_button").addClass("hidden");
                
            }else {
                
                $("#alert_error").addClass("hidden");
        
                if(balance_total > 0){
                    $("#div_balance_total").css('color', '#ff0000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }else if(balance_total == 0){
                    $("#div_balance_total").css('color', '#000000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }else{
                    $("#div_balance_total").css('color', '#2d823a');

                    $("#alert_info").removeClass("hidden");
                    $("#alert_info").html("<strong>Info</strong> Entered Amount is more than Balance Payment. The Excess payment will be add as over payment");
                }

            }
            
        }else {
        
            if(balance_total > 0){
                $("#div_balance_total").css('color', '#ff0000');
                $("#div_submit_button").removeClass("hidden");
                
                $("#alert_info").addClass("hidden");

            }else if(balance_total == 0){
                $("#div_balance_total").css('color', '#000000');
                $("#div_submit_button").removeClass("hidden");
                
                $("#alert_info").addClass("hidden");

            }else{
                $("#div_balance_total").css('color', '#2d823a');

                $("#alert_info").removeClass("hidden");
                $("#alert_info").html("<strong>Info</strong> Entered Amount is more than Balance Payment. The Excess payment will be add as over payment");

            }
        }
        
        $('#balance_total').val(balance_total);
        balance_total = Math.abs(balance_total);
        
        if(sale_type == 'Credit Sale'){
            balance_total = (balance_total).toLocaleString('en'); 
            $('#div_balance_total').html('Rs. '+balance_total);
            
        }else if(sale_type == 'Gold Sale'){
            balance_total = (balance_total).toLocaleString('en'); 
            $('#div_balance_total').html(balance_total+' g');
            
        }
    });
    
    $('#24k_sale_payment_amount').on('keyup', function () {
        payment_amount = $(this).val();
        payment_total = $('#payment_total').val();
        
        payment_method = $('#payment_method').val();
        
        if(payment_amount != ''){
            payment_amount = parseFloat(payment_amount);
        }else{
            payment_amount = 0;
        }
        
        balance_total = parseFloat(payment_total - payment_amount);
        balance_total = balance_total.toFixed(2);
        
        if(payment_method == 'Over Paid Gold'){
            
            over_paid_amount = parseFloat($('#over_paid_gold').val());
            
            if(over_paid_amount < payment_amount){
                
                $("#alert_error").removeClass("hidden");
                $("#alert_error").html("<strong>Error</strong> Entered Amount is more than Over Paid Amount");
            
                $("#div_balance_total").css('color', '#ff0000');
                $("#div_submit_button").addClass("hidden");
                
            }else {
        
                $("#alert_error").addClass("hidden");
                
                if(balance_total > 0){
                    $("#div_balance_total").css('color', '#ff0000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }else if(balance_total == 0){
                    $("#div_balance_total").css('color', '#000000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }else{
                    $("#div_balance_total").css('color', '#2d823a');

                }

            }
            
        }else if(payment_method == 'Over Paid Cash'){
            
            over_paid_amount = parseFloat($('#over_paid_cash').val());
            
            if(over_paid_amount < payment_amount){
            
                $("#alert_error").removeClass("hidden");
                $("#alert_error").html("<strong>Error</strong> Entered Amount is more than Over Paid Amount");
                
                $("#div_balance_total").css('color', '#ff0000');
                $("#div_submit_button").addClass("hidden");
                
            }else {
                
                $("#alert_error").addClass("hidden");
        
                if(balance_total > 0){
                    $("#div_balance_total").css('color', '#ff0000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }else if(balance_total == 0){
                    $("#div_balance_total").css('color', '#000000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }else{
                    $("#div_balance_total").css('color', '#2d823a');

                    $("#alert_info").removeClass("hidden");
                    $("#alert_info").html("<strong>Info</strong> Entered Amount is more than Balance Payment. The Excess payment will be add as over payment");
                }

            }
            
        }else {
        
            if(balance_total > 0){
                $("#div_balance_total").css('color', '#ff0000');
                $("#div_submit_button").removeClass("hidden");
                
                $("#alert_info").addClass("hidden");

            }else if(balance_total == 0){
                $("#div_balance_total").css('color', '#000000');
                $("#div_submit_button").removeClass("hidden");
                
                $("#alert_info").addClass("hidden");

            }else{
                $("#div_balance_total").css('color', '#2d823a');

                $("#alert_info").removeClass("hidden");
                $("#alert_info").html("<strong>Info</strong> Entered Amount is more than Balance Payment. The Excess payment will be add as over payment");

            }
        }
        
        $('#balance_total').val(balance_total);
        balance_total = Math.abs(balance_total);
        
        balance_total = (balance_total).toLocaleString('en'); 
        $('#div_balance_total').html('Rs. '+balance_total);
    });
    
    $('#payment_method').on("change", function () {
        var payment_method = $(this).find('option:selected').val();
        
        if(payment_method == 'Gold'){
            $("#div_cheque_details").addClass("hidden");
            $("#div_deposit_details").addClass("hidden");
            
            $("#div_credit_sale_details").addClass("hidden");
            $("#div_gold_sale_details").removeClass("hidden");
            $("#div_over_paid_cash_details").addClass("hidden");
            $("#div_over_paid_gold_details").addClass("hidden");
            $("#div_submit_button").removeClass("hidden");
            
            $("#alert_error").addClass("hidden");
            $("#div_balance_total").css('color', '#ff0000');
            
            $("#div_payment_amount_gold").removeClass("hidden");
            $("#div_payment_amount_credit").addClass("hidden");
            
        }else if(payment_method == 'Over Paid Gold'){
            $("#div_cheque_details").addClass("hidden");
            $("#div_deposit_details").addClass("hidden");
            
            $("#div_credit_sale_details").addClass("hidden");
            $("#div_gold_sale_details").removeClass("hidden");
            $("#div_over_paid_cash_details").addClass("hidden");
            $("#div_over_paid_gold_details").removeClass("hidden");
            $("#div_submit_button").removeClass("hidden");
            
            over_paid_amount = parseFloat($('#over_paid_gold').val());
            
            payment_amount = $('#payment_amount, #payment_amount_gold').val();
            
            if(over_paid_amount < payment_amount){
                
                $("#alert_error").removeClass("hidden");
                $("#alert_error").html("<strong>Error</strong> Entered Amount is more than Over Paid Amount");
            
                $("#div_balance_total").css('color', '#ff0000');
                $("#div_submit_button").addClass("hidden");
                
            }else{
                $("#alert_error").addClass("hidden");
                $("#div_balance_total").css('color', '#ff0000');
                $("#div_submit_button").removeClass("hidden");
            }
            
            $("#div_payment_amount_gold").removeClass("hidden");
            $("#div_payment_amount_credit").addClass("hidden");
            
        }else if(payment_method == 'Over Paid Cash'){
            $("#div_cheque_details").addClass("hidden");
            $("#div_deposit_details").addClass("hidden");
            
            $("#div_credit_sale_details").removeClass("hidden");
            $("#div_gold_sale_details").addClass("hidden");
            $("#div_over_paid_cash_details").removeClass("hidden");
            $("#div_over_paid_gold_details").addClass("hidden");
            $("#div_submit_button").removeClass("hidden");
            
            over_paid_amount = parseFloat($('#over_paid_cash').val());
            
            payment_amount = $('#payment_amount, #payment_amount_credit').val();
            
            if(over_paid_amount < payment_amount){
                
                $("#alert_error").removeClass("hidden");
                $("#alert_error").html("<strong>Error</strong> Entered Amount is more than Over Paid Amount");
            
                $("#div_balance_total").css('color', '#ff0000');
                $("#div_submit_button").addClass("hidden");
                
            }else{
                $("#alert_error").addClass("hidden");
                $("#div_balance_total").css('color', '#ff0000');
                $("#div_submit_button").removeClass("hidden");
            }
            
            $("#div_payment_amount_credit").removeClass("hidden");
            $("#div_payment_amount_gold").addClass("hidden");
            
        }else if(payment_method == 'Cash'){
            $("#div_cheque_details").addClass("hidden");
            $("#div_deposit_details").addClass("hidden");
            
            $("#div_gold_sale_details").addClass("hidden");
            $("#div_credit_sale_details").removeClass("hidden");
            $("#div_over_paid_cash_details").addClass("hidden");
            $("#div_over_paid_gold_details").addClass("hidden");
            $("#div_submit_button").removeClass("hidden");
            
            $("#div_payment_amount_credit").removeClass("hidden");
            $("#div_payment_amount_gold").addClass("hidden");
            
        }else if(payment_method == 'Cheque'){
            $("#div_cheque_details").removeClass("hidden");
            $("#div_deposit_details").addClass("hidden");
            
            $("#div_gold_sale_details").addClass("hidden");
            $("#div_credit_sale_details").removeClass("hidden");
            $("#div_over_paid_cash_details").addClass("hidden");
            $("#div_over_paid_gold_details").addClass("hidden");
            $("#div_submit_button").removeClass("hidden");
            
            $("#div_payment_amount_credit").removeClass("hidden");
            $("#div_payment_amount_gold").addClass("hidden");
            
        }else if(payment_method == 'Bank Deposit'){
            $("#div_deposit_details").removeClass("hidden");
            $("#div_cheque_details").addClass("hidden");
            
            $("#div_gold_sale_details").addClass("hidden");
            $("#div_credit_sale_details").removeClass("hidden");
            $("#div_over_paid_cash_details").addClass("hidden");
            $("#div_over_paid_gold_details").addClass("hidden");
            $("#div_submit_button").removeClass("hidden");
            
            $("#div_payment_amount_credit").removeClass("hidden");
            $("#div_payment_amount_gold").addClass("hidden");
            
        }else{
            $("#div_deposit_details").addClass("hidden");
            $("#div_cheque_details").addClass("hidden");
            
            $("#div_gold_sale_details").addClass("hidden");
            $("#div_credit_sale_details").addClass("hidden");
            $("#div_over_paid_cash_details").addClass("hidden");
            $("#div_over_paid_gold_details").addClass("hidden");
            $("#div_submit_button").addClass("hidden");
            
            $("#div_payment_amount_credit").addClass("hidden");
            $("#div_payment_amount_gold").addClass("hidden");
            
        }
    });
    
    $('#payment_method_fixing').on("change", function () {
        var payment_method = $(this).find('option:selected').val();
        
        if(payment_method == 'Cash'){
            $("#div_cheque_details_fixing").addClass("hidden");
            $("#div_deposit_details_fixing").addClass("hidden");
            
        }else if(payment_method == 'Cheque'){
            $("#div_cheque_details_fixing").removeClass("hidden");
            $("#div_deposit_details_fixing").addClass("hidden");
            
        }else if(payment_method == 'Bank Deposit'){
            $("#div_deposit_details_fixing").removeClass("hidden");
            $("#div_cheque_details_fixing").addClass("hidden");
            
        }
    });
    
    $("#make_normal_payment").validate({
        rules: {  
            payment_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            payment_amount: "Please enter paid amount",   
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_make_normal_payment",
                type: "POST",
                data: $("#make_normal_payment").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_sale?sale_id="+response.sale_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#make_24k_normal_payment").validate({
        rules: {  
            payment_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            payment_amount: "Please enter paid amount",   
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_make_24k_normal_payment",
                type: "POST",
                data: $("#make_24k_normal_payment").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_24k_sale?24k_sale_id="+response.sale_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $('#24k_rate_fixing').on('keyup', function () {
        k_rate = $(this).val();
        payment_amount = $('#fixing_payment_amount').val();
        no_of_sale_items = $('#no_of_sale_items').val();
        
        if(payment_amount != ''){
            payment_amount = parseFloat(payment_amount);
        }else{
            payment_amount = 0;
        }
            
        for (i = 0; i < no_of_sale_items; i++) { 
            sales_grams = $('#fixing_sales_grams_'+i).val();
            
            sale_amount = (k_rate/8) * sales_grams;
            je_c_amount = Math.round(sale_amount * 100) / 100;
            
            $("#fixing_item_total_"+i).val(je_c_amount);
            
            tot = (je_c_amount).toLocaleString('en');

            $("#div_fixing_item_total_"+i).html('Rs. '+tot);
          
        }
        
        item_total = 0;
        
        $('.fixing_item_total').each(function(){
            if (this.value != "") {
                item_total +=  parseFloat($(this).val());
            }
        });

        item_total = item_total.toFixed(2);
        $("#fixing_total_amount").val(item_total);
        
        item_total = Math.round(item_total * 100) / 100;
        item_total = (item_total).toLocaleString('en'); 
        $("#div_fixing_total_amount").html('Rs. '+item_total);
        
        total_paid_in_grams = $('#fixing_total_paid_in_grams').val();
        total_paid_in_rupees = (k_rate/8) * total_paid_in_grams;  
        total_paid_in_rupees = total_paid_in_rupees.toFixed(2);
        total_paid_in_rupees = Math.round(total_paid_in_rupees * 100) / 100;

        tot_total_paid_in_rupees = (total_paid_in_rupees).toLocaleString('en');

        $("#div_fixing_total_paid").html('Rs. '+tot_total_paid_in_rupees);
        
        balance_in_grams = $('#fixing_balance_in_grams').val();
        balance_in_rupees = (k_rate/8) * balance_in_grams;
        
        balance_in_rupees = balance_in_rupees.toFixed(2);
        $("#payment_total_in_rupees").val(balance_in_rupees);   
        $("#fixing_balance_total_in_rupees").val(balance_in_rupees);   
        
        balance_in_rupees = Math.round(balance_in_rupees * 100) / 100;

        tot_balance_in_rupees = (balance_in_rupees).toLocaleString('en');

        $("#fixing_balance_in_rupees").html('Rs. '+tot_balance_in_rupees);
        
        $("#amount_to_be_paid").html(balance_in_grams+' g - '+'Rs. '+tot_balance_in_rupees);
        $("#fixing_div_balance_total").html(balance_in_grams+' g - '+'Rs. '+tot_balance_in_rupees);
        
    });
    
    $('#fixing_payment_amount').on('keyup', function () {
        payment_amount = $(this).val();
        
        k_rate_fixing = $('#24k_rate_fixing').val();
        payment_total_in_grams = $('#payment_total_in_grams').val();
        payment_total_in_rupees = $('#payment_total_in_rupees').val();
        
        balance_total_in_rupees = parseFloat(payment_total_in_rupees - payment_amount);
        balance_total_in_rupees = balance_total_in_rupees.toFixed(2);
        
        $("#fixing_balance_total_in_rupees").val(balance_total_in_rupees);
        
        balance_total_in_rupees = Math.round(balance_total_in_rupees * 100) / 100;
        balance_total_in_rupees = (balance_total_in_rupees).toLocaleString('en');
        
        balance_total_in_grams =  payment_amount / (k_rate_fixing/8);
        balance_total_in_grams = payment_total_in_grams - balance_total_in_grams.toFixed(3);
        
        $("#fixing_balance_total_in_grams").val(balance_total_in_grams);
        
        $('#fixing_div_balance_total').html(balance_total_in_grams+' g - '+'Rs. '+balance_total_in_rupees);
                
        console.log('balance_total_in_grams - '+balance_total_in_grams);        
                
        if(balance_total_in_grams > 0){
            $("#fixing_div_balance_total").css('color', '#2d823a');
            $("#div_fixing_submit_button").removeClass("hidden");
            
        }else if(amount_to_be_paid == 0){
            $("#fixing_div_balance_total").css('color', '#000000');
            $("#div_fixing_submit_button").removeClass("hidden");
            
        }else{
            $("#fixing_div_balance_total").css('color', '#ff0000');
//            $("#div_fixing_submit_button").addClass("hidden");
            
        }
        
        
        
    });    
    
    $("#make_fixing_payment").validate({
        rules: {  
            k_rate_fixing: {
                required: true
            },
            fixing_payment_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            k_rate_fixing: "Please enter 24K amount",   
            fixing_payment_amount: "Please enter paid amount",
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_make_fixing_payment",
                type: "POST",
                data: $("#make_fixing_payment").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_sale?sale_id="+response.sale_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $('#payment_amount_credit').on('keyup', function () {
        tot_payment_amount = parseFloat($(this).val());
        tot_paid = 0;
        
        payment_method = $('#payment_method').val();
        
        $('.debtor_payment_amount').each(function(){
            if (this.value != "") {
                tot_paid +=  parseFloat($(this).val());
            }
        });
        
        if(tot_paid > tot_payment_amount){
            $("#debtor_total_paid").css('color', '#ff0000');
            $("#div_submit_button").addClass("hidden");
            
        }else{
            $("#debtor_total_paid").css('color', '#000000');
            $("#div_submit_button").removeClass("hidden");
            
        }
        
        tot_paid = tot_paid - tot_payment_amount;
        tot_paid = tot_paid.toFixed(2);
                
        if(payment_method == 'Over Paid Cash'){
            
            over_paid_amount = parseFloat($('#over_paid_cash').val());
            
            if(over_paid_amount < tot_payment_amount){
                
                $("#alert_error").removeClass("hidden");
                $("#alert_error").html("<strong>Error</strong> Entered Amount is more than Over Paid Amount");
            
                $("#debtor_total_paid_gold").css('color', '#ff0000');
                $("#div_submit_button").addClass("hidden");
                
            }else {
        
                $("#alert_error").addClass("hidden");
                
                if(tot_paid > tot_payment_amount){
                    $("#debtor_total_paid_gold").css('color', '#ff0000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }else{
                    $("#debtor_total_paid_gold").css('color', '#000000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }

            }
            
        }
        
        $("#debtor_total_paid").html('Rs. '+tot_paid);
    });
    
    $('.debtor_payment_amount').on('keyup', function () {
        tot_payment_amount = parseFloat($('#payment_amount_credit').val());
        payment_amount = $(this).val();
        item_id = $(this).attr('item-id');
        bal_amount = $(this).attr('bal-amount');
        
        amount_to_be_paid = bal_amount - payment_amount;
        
        $('#debtor_balance_amount'+item_id).val(amount_to_be_paid);
        
        if(amount_to_be_paid > 0){
            $("#div_debtor_bal_amount"+item_id).css('color', '#2d823a');
            $("#div_submit_button").removeClass("hidden");
            
        }else if(amount_to_be_paid == 0){
            $("#div_debtor_bal_amount"+item_id).css('color', '#000000');
            $("#div_submit_button").removeClass("hidden");
            
        }else{
            $("#div_debtor_bal_amount"+item_id).css('color', '#ff0000');
            $("#div_submit_button").addClass("hidden");
            
        }
         
        amount_to_be_paid = Math.round(amount_to_be_paid * 100) / 100;
        amount_to_be_paid = (amount_to_be_paid).toLocaleString('en');
        
        $('#div_debtor_bal_amount'+item_id).html('Rs. '+amount_to_be_paid);
        
        tot_paid = 0;
        $('.debtor_payment_amount').each(function(){
            if (this.value != "") {
                tot_paid +=  parseFloat($(this).val());
            }
        });
        
        if(tot_paid > tot_payment_amount){
            $("#debtor_total_paid").css('color', '#ff0000');
            $("#div_submit_button").addClass("hidden");
            
        }else{
            $("#debtor_total_paid").css('color', '#000000');
            $("#div_submit_button").removeClass("hidden");
            
        }
        
        $('#tot_payment_amount').val(tot_paid);
        
        tot_amount_to_be_paid = $('#tot_amount_to_be_paid').val();
        tot_balance_amount = tot_amount_to_be_paid - tot_paid;

        tot_paid = tot_paid - tot_payment_amount;
        tot_paid = Math.round(tot_paid * 100) / 100;
        tot_paid = (tot_paid).toLocaleString('en'); 

        $("#debtor_total_paid").html('Rs. '+tot_paid);

        tot_balance_amount = Math.round(tot_balance_amount * 100) / 100;
        tot_balance_amount = (tot_balance_amount).toLocaleString('en'); 

        $("#debtor_total_balance_amount").html('Rs. '+tot_balance_amount);
        
    });
    
    $('#payment_amount_gold').on('keyup', function () {
        
        tot_payment_amount = parseFloat($(this).val());
        tot_paid = 0;
        
        payment_method = $('#payment_method').val();
                
        $('.debtor_payment_amount_gold').each(function(){
            if (this.value != "") {
                tot_paid +=  parseFloat($(this).val());
            }
        });
        
        tot_paid = tot_paid - tot_payment_amount;
        tot_paid = tot_paid.toFixed(3);
                
        if(payment_method == 'Over Paid Gold'){
            
            over_paid_amount = parseFloat($('#over_paid_gold').val());
            
            if(over_paid_amount < tot_payment_amount){
                
                $("#alert_error").removeClass("hidden");
                $("#alert_error").html("<strong>Error</strong> Entered Amount is more than Over Paid Amount");
            
                $("#debtor_total_paid_gold").css('color', '#ff0000');
                $("#div_submit_button").addClass("hidden");
                
            }else {
        
                $("#alert_error").addClass("hidden");
                
                if(tot_paid > tot_payment_amount){
                    $("#debtor_total_paid_gold").css('color', '#ff0000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }else{
                    $("#debtor_total_paid_gold").css('color', '#000000');
                    $("#div_submit_button").removeClass("hidden");
                    
                    $("#alert_info").addClass("hidden");

                }

            }
            
        }
        
        
        
        $("#debtor_total_paid_gold").html(tot_paid+' g');
    });
    
    $('.debtor_payment_amount_gold').on('keyup', function () {
        tot_payment_amount = parseFloat($('#payment_amount_gold').val());
        payment_amount = $(this).val();
        item_id = $(this).attr('item-id');
        bal_amount = $(this).attr('bal-amount');
        
        amount_to_be_paid = bal_amount - payment_amount;
        
        $('#debtor_balance_amount_gold'+item_id).val(amount_to_be_paid.toFixed(3));
        
        if(amount_to_be_paid > 0){
            $("#div_debtor_bal_amount_gold"+item_id).css('color', '#2d823a');
            $("#div_submit_button").removeClass("hidden");
            
        }else if(amount_to_be_paid == 0){
            $("#div_debtor_bal_amount_gold"+item_id).css('color', '#000000');
            $("#div_submit_button").removeClass("hidden");
            
        }else{
            $("#div_debtor_bal_amount_gold"+item_id).css('color', '#ff0000');
            $("#div_submit_button").addClass("hidden");
            
        }
        
        $('#div_debtor_bal_amount_gold'+item_id).html(amount_to_be_paid.toFixed(3)+' g');
        
        tot_paid = 0;
        $('.debtor_payment_amount_gold').each(function(){
            if (this.value != "") {
                tot_paid +=  parseFloat($(this).val());
            }
        });
        
        if(tot_paid > tot_payment_amount){
            $("#debtor_total_paid_gold").css('color', '#ff0000');
//            $("#div_submit_button").addClass("hidden");
            
        }else{
            $("#debtor_total_paid_gold").css('color', '#000000');
            $("#div_submit_button").removeClass("hidden");
            
        }
        
        $('#tot_payment_amount_gold').val(tot_paid);
        
        tot_paid = tot_paid.toFixed(3);
        
        tot_amount_to_be_paid = $('#tot_amount_to_be_paid_gold').val();
        tot_balance_amount = tot_amount_to_be_paid - tot_paid;

        tot_paid = tot_paid - tot_payment_amount;
        $("#debtor_total_paid_gold").html(tot_paid.toFixed(3)+' g');
        
        tot_balance_amount = tot_balance_amount.toFixed(3);

        $("#debtor_total_balance_amount_gold").html(tot_balance_amount+' g');
        
    });
    
    $("#make_normal_debtor_payment").validate({
        rules: {  
            payment_method: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            payment_method: "Please select a payment method",   
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_make_normal_debtor_payment",
                type: "POST",
                data: $("#make_normal_debtor_payment").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
//                        window.location.href = BASE_URL+"view_debtor?customer_id="+response.customer_id+"&debtor_type="+response.debtor_type;
                        window.location.href = BASE_URL+"view_debtor?customer_id="+response.customer_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $('#24k_rate_debtor_fixing').on('keyup', function () {
        k_rate = $(this).val();
        no_of_sales = $('#no_of_sales_debtor_fixing').val();
        
        total_bal_amount_gold = $('#tot_amount_debtor_fixing_to_be_paid_gold').val();
        total_bal_amount_cash = $('#debtor_fixing_total_amount').val();
        
        for (i = 0; i < no_of_sales; i++) { 
            sales_grams = $('#debtor_fixing_payment_amount_cash_'+i).attr('bal-amount');
            
            sale_amount = (k_rate/8) * sales_grams;
            je_c_amount = Math.round(sale_amount * 100) / 100;
            
            $("#debtor_fixing_balance_amount_gold"+i).val(sales_grams);
            $("#debtor_fixing_balance_amount_cash"+i).val(je_c_amount);
            
            $("#debtor_fixing_item_total_"+i).val(je_c_amount);
            
            tot = (je_c_amount).toLocaleString('en');

            $("#div_debtor_fixing_bal_amount_cash_"+i).html('Rs. '+tot);
            
            $("#div_debtor_fixing_bal_amount"+i).html(sales_grams+' g - '+'Rs. '+tot);
            
        }
        
        item_total_cash = 0;
        item_total_gold = 0;
        
        $('.debtor_fixing_item_total').each(function(){
            if (this.value != "") {
                item_total_cash +=  parseFloat($(this).val());
            }
        });
        
        $('.debtor_fixing_payment_amount_cash').each(function(){
            if ($(this).attr('bal-amount') != "") {
                item_total_gold += parseFloat($(this).attr('bal-amount'));
            }
        });
        
        $("#debtor_fixing_total_amount").val(item_total_cash);
        
//        item_total_gold = item_total_gold.toFixed(3);
//        item_total_cash = item_total_cash.toFixed(2);
//        
//        
//        total_paid_gold = total_bal_amount_gold - item_total_gold;
//        $("#tot_debtor_fixing_payment_amount_gold").val(total_paid_gold);
//        
//        total_paid_cash = total_bal_amount_cash - item_total_cash;
//        $("#tot_debtor_fixing_payment_amount_cash").val(total_paid_cash);
        
        item_total_cash = Math.round(item_total_cash * 100) / 100;
        item_total_cash = (item_total_cash).toLocaleString('en'); 
        $("#div_debtor_fixing_total_amount").html('Rs. '+item_total_cash);
        
        $("#debtor_fixing_total_balance_amount").html(item_total_gold+' g - '+'Rs. '+item_total_cash);
        
    });
    
    $('.debtor_fixing_payment_amount_cash').on('keyup', function () {
        payment_amount_cash = $(this).val();
        k_rate = $('#24k_rate_debtor_fixing').val();
        item_id = $(this).attr('item-id');
        item_key = $(this).attr('item-key');
        bal_amount_gold = parseFloat($(this).attr('bal-amount'));;
        bal_amount_cash = $('#debtor_fixing_item_total_'+item_key).val();
        
        total_bal_amount_gold = $('#tot_amount_debtor_fixing_to_be_paid_gold').val();
                
        cash_to_be_paid = bal_amount_cash - payment_amount_cash;
        
        gold_calc =  payment_amount_cash / (k_rate/8);
        gold_to_be_paid = bal_amount_gold - gold_calc.toFixed(3);
        
        gold_to_be_paid = gold_to_be_paid.toFixed(3);
        
        console.log('gold_calc - '+gold_calc);
        console.log('bal_amount_gold - '+bal_amount_gold);
        console.log('gold_to_be_paid - '+gold_to_be_paid);
        
                
        $('#debtor_fixing_balance_amount_gold'+item_key).val(gold_to_be_paid);
        $('#debtor_fixing_balance_amount_cash'+item_key).val(cash_to_be_paid);
        
        if(cash_to_be_paid > 0){
            $("#div_debtor_fixing_bal_amount"+item_key).css('color', '#2d823a');
            $("#div_fixing_submit_button").removeClass("hidden");
            
        }else if(cash_to_be_paid == 0){
            $("#div_debtor_fixing_bal_amount"+item_key).css('color', '#000000');
            $("#div_fixing_submit_button").removeClass("hidden");
            
        }else{
            $("#div_debtor_fixing_bal_amount"+item_key).css('color', '#ff0000');
            $("#div_fixing_submit_button").addClass("hidden");
            
        }
        
        cash_to_be_paid = (cash_to_be_paid).toLocaleString('en');
        
        $('#div_debtor_fixing_bal_amount'+item_key).html(gold_to_be_paid+' g - '+'Rs. '+cash_to_be_paid);
                
        item_total_cash = 0;
        item_total_gold = 0;
        
        $('.debtor_fixing_balance_amount_cash').each(function(){
            if (this.value != "") {
                item_total_cash +=  parseFloat($(this).val());
            }else{
                item_total_cash +=  0.00;
            }
        });
        
        $('.debtor_fixing_balance_amount_gold').each(function(){
            if (this.value != "") {
                item_total_gold += parseFloat($(this).val());
            }else{
                item_total_gold +=  0.000;
            }
        });
        
        total_paid_gold = total_bal_amount_gold - item_total_gold;
        $("#tot_debtor_fixing_payment_amount_gold").val(total_paid_gold.toFixed(3));
        
        item_total_cash = Math.round(item_total_cash * 100) / 100;
        item_total_cash = (item_total_cash).toLocaleString('en'); 
        
        $("#debtor_fixing_total_balance_amount").html(item_total_gold+' g - '+'Rs. '+item_total_cash);
        
        total_paid_cash = 0;
        
        $('.debtor_fixing_payment_amount_cash').each(function(){
            if (this.value != "") {
                total_paid_cash +=  parseFloat($(this).val());
            }
        });
        
        total_paid_cash = total_paid_cash.toFixed(2);
        $('#tot_debtor_fixing_payment_amount_cash').val(total_paid_cash);
        
        total_paid_cash = Math.round(total_paid_cash * 100) / 100;
        total_paid_cash = (total_paid_cash).toLocaleString('en'); 
        
        $('#debtor_fixing_total_paid_cash').html('Rs. '+total_paid_cash);
        
    });
    
    $('#payment_method_debtor_fixing').on("change", function () {
        var payment_method = $(this).find('option:selected').val();
        
        if(payment_method == 'Cash'){
            $("#div_cheque_details_debtor_fixing").addClass("hidden");
            $("#div_deposit_details_debtor_fixing").addClass("hidden");
            
        }else if(payment_method == 'Cheque'){
            $("#div_cheque_details_debtor_fixing").removeClass("hidden");
            $("#div_deposit_details_debtor_fixing").addClass("hidden");
            
        }else if(payment_method == 'Bank Deposit'){
            $("#div_deposit_details_debtor_fixing").removeClass("hidden");
            $("#div_cheque_details_debtor_fixing").addClass("hidden");
            
        }
    });
    
    $("#make_fixing_debtor_payment").validate({
        rules: {  
            invoice_date: {
                required: true
            },  
            k_rate_debtor_fixing: {
                required: true
            },
            payment_method_debtor_fixing: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            invoice_date: "Please select an invoice date",  
            k_rate_debtor_fixing: "Please enter 24K Rate amount",   
            payment_method_debtor_fixing: "Please enter paid amount",
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_make_fixing_debtor_payment",
                type: "POST",
                data: $("#make_fixing_debtor_payment").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
//                        window.location.href = BASE_URL+"view_debtor?customer_id="+response.customer_id+"&debtor_type="+response.debtor_type;
                        window.location.href = BASE_URL+"view_debtor?customer_id="+response.customer_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#add_bank_account").validate({
        rules: {  
            account_name: {
                required: true
            },
            bank_name: {
                required: true
            },
            account_number: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            account_name: "Please select a account name",  
            bank_name: "Please select a bank",    
            account_number: "Please enter account number"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_bank_account_details",
                type: "POST",
                data: $("#add_bank_account").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_bank_ammount').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#edit_bank_account").validate({
        rules: {  
            account_name: {
                required: true
            },
            bank_name: {
                required: true
            },
            account_number: {
                required: true
            },
            bank_balance: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            account_name: "Please select a account name",  
            bank_name: "Please select a bank",    
            account_number: "Please enter account number",
            bank_balance: "Please enter bank balance"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_bank_account_details",
                type: "POST",
                data: $("#edit_bank_account").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        
                        window.location.href = BASE_URL+"view_bank_account?account_id="+response.account_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $('#submit_action').on("change", function () {
        var submit_action = $(this).find('option:selected').val();
        
        if(submit_action == 'Bank Deposited'){
            $("#div_chq_submit_bank_account").removeClass("hidden");
            
        }else {
            $("#div_chq_submit_bank_account").addClass("hidden");
            
        }
    });
    
    $("#submit_cheque_action").validate({
        rules: {  
            submit_action: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            submit_action: "Please select a cheque action"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_cheque_action",
                type: "POST",
                data: $("#submit_cheque_action").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#submit_this_cheque').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#add_stock_item").validate({
        rules: {  
            item_code: {
                required: true
            },
            item_name: {
                required: true
            },
            stock_item_category: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            item_code: "Please enter an item code",    
            item_name: "Please enter an item name",    
            stock_item_category: "Please select an item category"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_stock_item_details",
                type: "POST",
                data: $("#add_stock_item").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_stock_item').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#add_stock_item_sale").validate({
        rules: {  
            item_code: {
                required: true
            },
            item_name: {
                required: true
            },
            stock_item_category: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            item_code: "Please enter an item code",    
            item_name: "Please enter an item name",    
            stock_item_category: "Please select an item category"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_stock_item_details",
                type: "POST",
                data: $("#add_stock_item_sale").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_stock_item').modal('hide');
                        
                        $.ajax({
                            url: BASE_URL+"ajax_get_last_added_stock_items",
                            type: "POST",
                            data: "item_type=" + $('#item_type').val(),
                            success: function (response) {
                                
                                var item_name_credit = $("#item_name_credit");
                                var item_name_gold = $("#item_name_gold");
                                
                                $.each(response, function(k, v) {
                                    item_name_credit.append('<option value="' + v.item_code + ' - ' + v.item_name + '" itemid="' + v.id + '">' + v.item_code + ' - ' + v.item_name+ '</option>');
                                    item_name_gold.append('<option value="' + v.item_code + ' - ' + v.item_name + '" itemid="' + v.id + '">' + v.item_code + ' - ' + v.item_name+ '</option>');
                                });
                                
                                $('#item_code').val('');
                                $('#item_code').val('');
                                
                                $('#item_code').val('');
                                $('#item_name').val('');
                                $('#item_description').val('');
                                
                            }
                        }); 
                        
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#edit_stock_item").validate({
        rules: {  
            item_code: {
                required: true
            },
            item_name: {
                required: true
            },
            stock_item_category: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            item_code: "Please enter an item code",    
            item_name: "Please enter an item name",    
            stock_item_category: "Please select an item category"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_stock_item_details",
                type: "POST",
                data: $("#edit_stock_item").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        
                        window.location.href = BASE_URL+"view_stock_item?item_id="+response.item_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $('#rate_change_description').on("change", function () {
        var description_type = $(this).find('option:selected').val();
        
        if(description_type == 'Other'){
            $("#div_other_description").removeClass("hidden");
            
        }else {
            $("#div_other_description").addClass("hidden");
            
        }
    });
    
    $("#change_rate_item").validate({
        rules: {  
            current_rate: {
                required: true
            },
            description: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            current_rate: "Please enter current rate",      
            description: "Please select a description"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_change_rate_item",
                type: "POST",
                data: $("#change_rate_item").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#change_rate').modal('hide');
                        if(response.user_type == 1){
                            $('#success_modal_admin').modal('show');
                        }else{
                            $('#success_modal').modal('show');
                        }
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#change_stock_balance").validate({
        rules: {  
            stock_balance: {
                required: true
            },
            description: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            stock_balance: "Please enter balance",
            description: "Please enter description"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_change_stock_balance",
                type: "POST",
                data: $("#change_stock_balance").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#change_stock').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#save_add_previous_debts").validate({
        rules: {  
            bill_date: {
                required: true
            },
            sale_type: {
                required: true
            },
            total_amount: {
                required: true
            },
            description: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            bill_date: "Please enter bill date",      
            sale_type: "Please select a sale type",      
            total_amount: "Please enter debt amount",      
            description: "Please enter the description"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_previous_debts",
                type: "POST",
                data: $("#save_add_previous_debts").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_previous_debts').modal('hide');
                        $('#previous_debts_success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#add_expense_category").validate({
        rules: {  
            expense_type: {
                required: true
            }, 
            category_name: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            expense_type: "Please select an expense type",
            category_name: "Please enter category name"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_expense_category_details",
                type: "POST",
                data: $("#add_expense_category").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_expense_category').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#edit_expense_category").validate({
        rules: {    
            category_name: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            category_name: "Please enter category name"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_expense_category_details",
                type: "POST",
                data: $("#edit_expense_category").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_expense_category?category_id="+response.category_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $('#payment_method_expense, #expense_type').on("change", function () {
        var payment_method = $(this).find('option:selected').val();
        
        $.ajax({
            url: BASE_URL+"get_bank_details_by_acc_type",
            type: "POST",
            data: "acc_type=" + $('#expense_type').val(),
            success: function (response) {
                
                $("#cheq_bank_account").empty();
                $("#transfer_bank_account").empty();

                var cheq_bank_account = $("#cheq_bank_account");
                var transfer_bank_account = $("#transfer_bank_account");

                $.each(response, function(k, v) {
                    cheq_bank_account.append('<option value="' + v.id + '">' + v.account_name + ' - ' + v.account_number+ ' - ' + v.bank_name+ '</option>');
                    transfer_bank_account.append('<option value="' + v.id + '">' + v.account_name + ' - ' + v.account_number+ ' - ' + v.bank_name+ '</option>');
                });

            }
        }); 
        
        if(payment_method == 'Cash'){
            $("#div_cheque_details_expense").addClass("hidden");
            $("#div_bank_details_expense").addClass("hidden");
            $("#div_bank_tranfer_expense").addClass("hidden");
            
        }else if(payment_method == 'Cheque'){            
            $("#div_cheque_details_expense").removeClass("hidden");
            $("#div_bank_details_expense").addClass("hidden");
            $("#div_bank_tranfer_expense").addClass("hidden");
            
        }else if(payment_method == 'Bank Transfer'){
            $("#div_bank_details_expense").removeClass("hidden");
            $("#div_bank_tranfer_expense").removeClass("hidden");
            $("#div_cheque_details_expense").addClass("hidden");
            
        }else if(payment_method == 'Bank Deposit'){
            $("#div_bank_details_expense").removeClass("hidden");
            $("#div_cheque_details_expense").addClass("hidden");
            $("#div_bank_tranfer_expense").addClass("hidden");
            
        }
    });
    
    $('#expense_category').on("change", function () {
        var expense_category = $(this).find('option:selected').val();
        
        if(expense_category == 'Add New Category'){
            $("#add_new_category").removeClass("hidden");
            
        }else if(expense_category == ''){
            $("#add_new_category").addClass("hidden");
            
        }else{
            $("#add_new_category").addClass("hidden");
        }
    });
    
    $("#add_expense").validate({
        rules: {  
            expense_date: {
                required: true
            }, 
            expense_category: {
                required: true
            }, 
            payment_amount: {
                required: true
            }, 
            payment_method: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            expense_date: "Please select a expense date",
            expense_category: "Please select a expense category",
            payment_amount: "Please enter a payment amount",
            payment_method: "Please select a payment method"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_expense_details",
                type: "POST",
                data: $("#add_expense").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_expense').modal('hide');
                        if(response.approval){
                            $('#success_modal_request').modal('show');
                        }else{
                            $('#success_modal').modal('show');
                        }
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#add_creditor").validate({
        rules: {  
            creditor_name: {
                required: true
            },
            contact_num: {
                required: true,
                maxlength: 10
            },
            creditor_type: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            creditor_name: "Please enter your contact name",                       
            contact_num: {
                required: "Please enter your contact number.",
                maxength: "Your provide a valid contact number"
            },
            creditor_type: "Please select a customer type"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_creditor_details",
                type: "POST",
                data: $("#add_creditor").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_creditor').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#edit_creditor").validate({
        rules: {  
            creditor_name: {
                required: true
            },
            contact_num: {
                required: true,
                maxlength: 10,
                number: true
            },
            creditor_type: {
                required: true
            },
        },
        // Specify the validation error messages
        messages: { 
            creditor_name: "Please enter your creditor name",                       
            contact_num: {
                required: "Please enter your contact number.",
                maxength: "Your provide a valid contact number"
            },
            creditor_type: "Please select a creditor type"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_creditor_details",
                type: "POST",
                data: $("#edit_creditor").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $('#una_add_creditor').on("change", function () {
        var add_creditor = $(this).find('option:selected').val();
        
        if(add_creditor == 'Add New Creditor'){
            $("#add_new_creditor").removeClass("hidden");
            $("#div_creditor_details").addClass("hidden");
            
        }else if(add_creditor == ''){
            $("#add_new_creditor").addClass("hidden");
            $("#div_creditor_details").addClass("hidden");
            
        }else{
            $("#add_new_creditor").addClass("hidden");
            $("#div_creditor_details").removeClass("hidden");
            
            $.ajax({
                url: BASE_URL+"ajax_get_creditor_details",
                type: "POST",
                data: "creditor_id=" + add_creditor,
                success: function (response) {
                    $("#txt_creditor_contact_num").val(response.contact_number);
                    $("#txt_creditor_tel_num").val(response.tel_number);
                    $("#do_sales_submit_btn").removeClass("hidden");                    
                }
            }); 
        }
    });
    
    $('#una_amount').live('keyup', function() {
        
        una_amount = $(this).val();
        una_rate = $('#una_rate').val();
        
        lkr_amount = una_amount*una_rate;
        
        $('#lkr_amount').val(lkr_amount);
        
//        lkr_amount = lkr_amount.toFixed(2);
        lkr_amount = Math.round(lkr_amount * 100) / 100;
        lkr_amount = (lkr_amount).toLocaleString('en'); 
        
        $('#div_lkr_amount').html('Rs. '+lkr_amount);
    });
    
    $('#una_rate').live('keyup', function() {
        
        una_rate = $(this).val();
        una_amount = $('#una_amount').val();
        
        lkr_amount = una_amount*una_rate;
        
        $('#lkr_amount').val(lkr_amount);
        
//        lkr_amount = lkr_amount.toFixed(2);
        lkr_amount1 = Math.round(lkr_amount * 100) / 100;
        lkr_amount = (lkr_amount).toLocaleString('en'); 
        
        $('#div_lkr_amount').html('Rs. '+lkr_amount);
    });
    
    $("#save_add_una").validate({
        rules: {  
            invoice_date: {
                required: true
            },
            select_creditor: {
                required: true
            },
            una_amount: {
                required: true
            },
            una_rate: {
                required: true
            },
            recipient: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            invoice_date: "Please select a date",   
            select_creditor: "Please select a UNA creditor",
            una_amount: "Please enter an UNA amount",
            una_rate: "Please enter an UNA rate",
            recipient: "Please enter recipient"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_una",
                type: "POST",
                data: $("#save_add_una").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"una";
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#save_edit_una").validate({
        rules: {  
            invoice_date: {
                required: true
            },
            select_creditor: {
                required: true
            },
            una_amount: {
                required: true
            },
            una_rate: {
                required: true
            },
            recipient: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            invoice_date: "Please select a date",   
            select_creditor: "Please select a UNA creditor",
            una_amount: "Please enter an UNA amount",
            una_rate: "Please enter an UNA rate",
            recipient: "Please enter recipient"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_edit_una",
                type: "POST",
                data: $("#save_edit_una").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_una?una_id="+response.una_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#add_una_admin_remarks").validate({
        rules: {  
            admin_remarks: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            admin_remarks: "Please enter an admin remarks"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_una_admin_remarks",
                type: "POST",
                data: $("#add_una_admin_remarks").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    $('#add_admin_remarks').modal('hide');
                    window.location.href = BASE_URL+"view_una?una_id="+response.una_id;
                }
            });
        }
    });
    
    $("#add_expense_admin_remarks").validate({
        rules: {  
            admin_remarks: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            admin_remarks: "Please enter an admin remarks"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_expense_admin_remarks",
                type: "POST",
                data: $("#add_expense_admin_remarks").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    $('#add_admin_remarks').modal('hide');
                    window.location.href = BASE_URL+"view_expense?expense_id="+response.expense_id;
                }
            });
        }
    });
    
    $('#previous_credit_type').on("change", function () {
        var credit_type = $(this).find('option:selected').val();
        
        if(credit_type == 'UNA Credit'){
            $("#div_prev_una_credit").removeClass("hidden");
            $("#div_prev_credit").addClass("hidden");
            
        }else{
            $("#div_prev_una_credit").addClass("hidden");
            $("#div_prev_credit").removeClass("hidden");
        }
    });
    
    $("#save_add_previous_credits").validate({
        rules: {  
            bill_date: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            bill_date: "Please enter bill date"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_previous_credits",
                type: "POST",
                data: $("#save_add_previous_credits").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_previous_credits').modal('hide');
                        $('#previous_credits_success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $('#settle_creditor').on("change", function () {
        var creditor = $(this).find('option:selected').val();
        
        if(creditor == ''){
            $("#div_creditor_details").addClass("hidden");
            
        }else{
            $("#div_creditor_details").removeClass("hidden");
            
            $.ajax({
                url: BASE_URL+"ajax_get_creditor_details",
                type: "POST",
                data: "creditor_id=" + creditor,
                success: function (response) {
                    $("#div_cre_mob_num").html(response.contact_number);
                    $("#div_cre_tel_num").html(response.tel_number);
                    $("#div_cre_type").html(response.creditor_type);  
                    
                    $("#div_cre_tot_amount").html('Rs. '+response.tot_amount); 
                    $("#div_cre_paid_amount").html('Rs. '+response.paid_amount); 
                    $("#div_cre_bal_amount").html('Rs. '+response.bal_amount); 
                    
                    $("#txt_cre_tot_amount").val(response.tot_amount); 
                    $("#txt_cre_paid_amount").val(response.paid_amount); 
                    $("#txt_cre_bal_amount").val(response.bal_amount); 
                    
                }
            }); 
        }
    });
    
    $("#save_settle_creditor").validate({
        rules: {  
            credit_date: {
                required: true
            },
            select_creditor: {
                required: true
            },
            payment_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            credit_date: "Please select date",          
            select_creditor: "Please select a creditor",          
            payment_amount: "Please enter a payment amount"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_settle_creditor",
                type: "POST",
                data: $("#save_settle_creditor").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"creditor_settlements";
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#save_una_settle_creditor").validate({
        rules: {  
            invoice_date: {
                required: true
            },
            select_creditor: {
                required: true
            },
            payment_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            invoice_date: "Please select date",          
            select_creditor: "Please select a creditor",          
            payment_amount: "Please enter a payment amount"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_una_settle_creditor",
                type: "POST",
                data: $("#save_una_settle_creditor").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_creditor?creditor_id="+response.creditor_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $('#settle_una_creditor').on("change", function () {
        var creditor = $(this).find('option:selected').val();
        
        if(creditor == ''){
            $("#div_una_creditor_details").addClass("hidden");
            
        }else{
            $("#div_una_creditor_details").removeClass("hidden");
            
            $.ajax({
                url: BASE_URL+"ajax_get_creditor_details",
                type: "POST",
                data: "creditor_id=" + creditor,
                success: function (response) {
                    $("#div_una_cre_mob_num").html(response.contact_number);
                    $("#div_una_cre_tel_num").html(response.tel_number);
                    $("#div_una_cre_type").html(response.creditor_type);  
                    
                    $("#div_una_cre_tot_amount").html('Rs. '+response.una_tot_amount); 
                    $("#div_una_cre_paid_amount").html('Rs. '+response.una_paid_amount); 
                    $("#div_una_cre_bal_amount").html('Rs. '+response.una_bal_amount); 
                    
                    $("#txt_una_cre_tot_amount").val(response.una_tot_amount); 
                    $("#txt_una_cre_paid_amount").val(response.una_paid_amount); 
                    $("#txt_una_cre_bal_amount").val(response.una_bal_amount); 
                    
                }
            }); 
            
            $.ajax({
                url: BASE_URL+"ajax_get_una_to_settle",
                type: "POST",
                data: "creditor_id=" + creditor,
                success: function (response) {
                    $("#div_una_settlements").html(response);
                    
                }
            }); 
        }
    });
    
    $('.una_payment_amount').on('keyup', function () {
        una_payment_amount = $('#una_settle_amount').val();
        payment_amount = $(this).val();
        item_id = $(this).attr('item-id');
        bal_amount = $(this).attr('bal-amount');
        
        if(una_payment_amount != ''){
            una_payment_amount = parseFloat(una_payment_amount);
        }else{
            una_payment_amount = 0.00;
        }
        
        amount_to_be_paid = bal_amount - payment_amount;
        
        $('#una_balance_amount'+item_id).val(amount_to_be_paid);
        
        if(amount_to_be_paid > 0){
            $("#div_una_bal_amount"+item_id).css('color', '#2d823a');
            $("#submit_btn").removeClass("hidden");
            
        }else if(amount_to_be_paid == 0){
            $("#div_una_bal_amount"+item_id).css('color', '#000000');
            $("#submit_btn").removeClass("hidden");
            
        }else{
            $("#div_una_bal_amount"+item_id).css('color', '#ff0000');
            
            $("#submit_btn").addClass("hidden");
            $("#error_msg_bal_amount").removeClass("hidden"); 
            $("#error_msg_bal_amount").html("<strong>Error!</strong> Payment Amount is more than the Balance UNA Amount.");
            
        }
        
        amount_to_be_paid = (amount_to_be_paid).toLocaleString('en'); 
        $('#div_una_bal_amount'+item_id).html('Rs. '+amount_to_be_paid);
        
        tot_paid = 0;
        $('.una_payment_amount').each(function(){
            if (this.value != "") {
                tot_paid +=  parseFloat($(this).val());
            }
        });
        
        console.log(tot_paid);
        
        if(tot_paid > una_payment_amount){
            $("#una_total_paid").css('color', '#ff0000');
            $("#submit_btn").addClass("hidden");
            $("#error_msg_bal_amount").removeClass("hidden"); 
            $("#error_msg_bal_amount").html("<strong>Error!</strong> Total Paid Amount doesn't match UNA settlement accounts.");
            
        }else{
            $("#una_total_paid").css('color', '#000000');
            $("#submit_btn").removeClass("hidden");
            $("#error_msg_bal_amount").addClass("hidden"); 
            
        }
        
        $('#tot_payment_amount').val(tot_paid);
        
        tot_amount_to_be_paid = $('#tot_amount_to_be_paid').val();
        tot_balance_amount = tot_amount_to_be_paid - tot_paid;

        tot_paid = tot_paid - una_payment_amount;
        tot_paid = Math.round(tot_paid * 100) / 100;
        tot_paid = (tot_paid).toLocaleString('en'); 

        $("#una_total_paid").html('Rs. '+tot_paid);

        tot_balance_amount = Math.round(tot_balance_amount * 100) / 100;
        tot_balance_amount = (tot_balance_amount).toLocaleString('en'); 

        $("#una_total_balance_amount").html('Rs. '+tot_balance_amount);
        
    });
    
    $('#una_settle_amount').live('keyup', function() {
        
        una_settle_amount = parseFloat($(this).val());
        una_settle_bal_amount = parseFloat($('#una_settle_bal_amount').val());
        
        cash_payment = $('#cash_payment').val();
        gold_cash_payment = $('#gold_cash_payment').val();
        var bank_total = 0;
        var creditor_total = 0;
        
        $(".bank_payment").each(function () {
            if($(this).val()!=''){
                bank_total +=  parseFloat($(this).val());
            }
        });
        $(".creditor_payment").each(function () {
            if($(this).val()!=''){
                creditor_total +=  parseFloat($(this).val());
            }
        });
        
        var total_paid = +cash_payment + +gold_cash_payment + +bank_total + +creditor_total;
        
        total_balance_amount = una_settle_amount - total_paid;
        
        if(una_settle_amount > una_settle_bal_amount){
            
            $("#submit_btn").addClass("hidden");
            $("#error_msg_bal_amount").removeClass("hidden"); 
            $("#error_msg_bal_amount").html("<strong>Error!</strong> Total settlement amount can't be greater than UNA balance anount.");
        }else{
            
            $("#submit_btn").removeClass("hidden");
            $("#error_msg_bal_amount").addClass("hidden"); 
        
            if(total_balance_amount != 0){
                $("#submit_btn").addClass("hidden");
                $("#error_msg_bal_amount").removeClass("hidden"); 
                $("#error_msg_bal_amount").html("<strong>Error!</strong> Total Paid Amount doesn't match UNA settlement accounts.");
            }else{
                $("#submit_btn").removeClass("hidden");
                $("#error_msg_bal_amount").addClass("hidden"); 
            }
        }
        
        total_balance_amount = Math.round(total_balance_amount * 100) / 100;
        tot = (total_balance_amount).toLocaleString('en');
        $("#div_total_bal_amount").html('Rs. '+tot);
    });
    
    $('#txt_24k_rate').live('keyup', function() {
        
        k_rate = $(this).val();
        gold_in_hand = $('#txt_avb_gold_amount').val();
        gold_cash_payment = $('#gold_cash_payment').val();
        
        if(gold_cash_payment != '' && k_rate == ''){
            $("#submit_btn").addClass("hidden");
            $("#error_msg").removeClass("hidden"); 
            $("#error_msg").html('<strong>Error!</strong> Please enter 24K Rate.');
        }else if(gold_cash_payment != '' && k_rate != ''){
            $("#submit_btn").addClass("hidden");
            $("#error_msg").removeClass("hidden"); 
            $("#error_msg").html('<strong>Error!</strong> Please enter 24K Rate.');
            
        }else{
            $("#submit_btn").removeClass("hidden");
           $("#error_msg").addClass("hidden"); 
        }
        
        gold_in_cash = k_rate * (gold_in_hand/8);
        $("#txt_gold_cash_amount").val(gold_in_cash);
        
        bal_gold_cash = gold_in_cash - gold_cash_payment;
        
        bal_gold = (bal_gold_cash / k_rate) * 8;
        $("#txt_gold_available_balance").val(bal_gold.toFixed(3));
        
        gold_in_cash = Math.round(gold_in_cash * 100) / 100;
        gold_in_cash = (gold_in_cash).toLocaleString('en');
        $("#div_gold_cash_amount").html('Rs. '+gold_in_cash);
        
        bal_gold_cash = Math.round(bal_gold_cash * 100) / 100;
        bal_gold_cash = (bal_gold_cash).toLocaleString('en');
        $("#div_gold_cash_available_balance").html('Rs. '+bal_gold_cash+' - '+bal_gold.toFixed(3)+' g');
    });
    
    $('.payment_items').live('keyup', function() {
        
        una_settle_amount = parseFloat($('#una_settle_amount').val());
        una_settle_bal_amount = parseFloat($('#una_settle_bal_amount').val());
        
        cash_payment = $('#cash_payment').val();
        k_rate = $('#txt_24k_rate').val();
        gold_cash_payment = $('#gold_cash_payment').val();
        var bank_total = 0;
        var creditor_total = 0;
        
        if(k_rate != ''){
            gold_cash_payment = gold_cash_payment;
        }else{
            gold_cash_payment = 0;
        }
        
        $(".bank_payment").each(function () {
            if($(this).val()!=''){
                bank_total +=  parseFloat($(this).val());
            }
        });
        $(".creditor_payment").each(function () {
            if($(this).val()!=''){
                creditor_total +=  parseFloat($(this).val());
            }
        });
        
        var total_paid = +cash_payment + +gold_cash_payment + +bank_total + +creditor_total;
        
        total_balance_amount = una_settle_amount - total_paid;
        
        console.log('total_balance_amount = '+total_balance_amount);
        
        if(una_settle_amount > una_settle_bal_amount){
            console.log('true');
            
            $("#submit_btn").addClass("hidden");
            $("#error_msg_bal_amount").removeClass("hidden"); 
            $("#error_msg_bal_amount").html("<strong>Error!</strong> Total settlement amount can't be greater than UNA balance anount.");
        }else{
            console.log('false');
            
//            $("#submit_btn").removeClass("hidden");
//            $("#error_msg_bal_amount").addClass("hidden"); 
        
            if(total_balance_amount != 0){
                $("#submit_btn").addClass("hidden");
                $("#error_msg_bal_amount").removeClass("hidden"); 
                $("#error_msg_bal_amount").html("<strong>Error!</strong> Total Paid Amount doesn't match UNA settlement accounts.");
            }else{
                $("#submit_btn").removeClass("hidden");
                $("#error_msg_bal_amount").addClass("hidden"); 
            }
        }
        
        total_balance_amount = Math.round(total_balance_amount * 100) / 100;
        tot = (total_balance_amount).toLocaleString('en');
        $("#div_total_bal_amount").html('Rs. '+tot);
    });
    
    $('#cash_payment').live('keyup', function() {
        
        cash_payment = $(this).val();
        cash_in_hand = $('#cash_in_hand').val();
        
        avb_cash_bal = cash_in_hand - cash_payment;
        
        if(avb_cash_bal < 0){
            $("#submit_btn").addClass("hidden");
            $("#error_msg_bal_amount").removeClass("hidden"); 
            $("#error_msg_bal_amount").html("<strong>Error!</strong> Cash Payment can't be more than cash in hand.");
        }
        
        $("#txt_cash_available_balance").val(avb_cash_bal);
        
        avb_cash_bal = Math.round(avb_cash_bal * 100) / 100;
        avb_cash_bal = (avb_cash_bal).toLocaleString('en');
        $("#div_cash_available_balance").html('Rs. '+avb_cash_bal);
    });
    
    $('#gold_cash_payment').live('keyup', function() {
        
        gold_cash_payment = $(this).val();
        cash_gold_in_hand = $('#txt_gold_cash_amount').val();
        k_rate = $('#txt_24k_rate').val();
        
        if(k_rate != ''){
            
            $("#submit_btn").removeClass("hidden");
            $("#error_msg").addClass("hidden");
        
            gold_amount = (gold_cash_payment / k_rate) * 8;
            $("#txt_gold_amount").val(gold_amount.toFixed(3));

            avb_cash_gold_bal = cash_gold_in_hand - gold_cash_payment;

            bal_gold = (avb_cash_gold_bal / k_rate) * 8;
            $("#txt_gold_available_balance").val(bal_gold.toFixed(3));
        
            if(bal_gold < 0){
                $("#submit_btn").addClass("hidden");
                $("#error_msg_bal_amount").removeClass("hidden"); 
                $("#error_msg_bal_amount").html("<strong>Error!</strong> Gold Payment can't be more than gold in hand.");
            }

            avb_cash_gold_bal = Math.round(avb_cash_gold_bal * 100) / 100;
            avb_cash_gold_bal = (avb_cash_gold_bal).toLocaleString('en');
            $("#div_gold_cash_available_balance").html('Rs. '+avb_cash_gold_bal+' - '+bal_gold.toFixed(3)+' g');
        
        }else{
            $("#submit_btn").addClass("hidden");
            $("#error_msg").removeClass("hidden");
            $("#error_msg").html('<strong>Error!</strong> Please enter 24K Rate.');
        }
    });
    
    $('.bank_payment').live('keyup', function() {
        
        bank_payment = $(this).val();
        item_id = $(this).attr('item-id');
        bank_balance = $('#bank_balance_'+item_id).val();
        
        avb_bank_balance = bank_balance - bank_payment;
        
        if(avb_bank_balance < 0){
            $("#submit_btn").addClass("hidden");
            $("#error_msg_bal_amount").removeClass("hidden"); 
            $("#error_msg_bal_amount").html("<strong>Error!</strong> Bank Payment can't be more than cash at bank.");
        }
        
        $("#txt_bank_available_balance_"+item_id).val(avb_bank_balance);
        
        avb_bank_balance = Math.round(avb_bank_balance * 100) / 100;
        avb_bank_balance = (avb_bank_balance).toLocaleString('en');
        $("#div_cash_available_balance_"+item_id).html('Rs. '+avb_bank_balance);
    });
    
    $("#save_settle_una").validate({
        rules: {  
            invoice_date: {
                required: true
            },
            una_settle_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            invoice_date: "Please select date",          
            una_settle_amount: "Please enter the total settlement amount"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_settle_una",
                type: "POST",
                data: $("#save_settle_una").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_una?una_id="+response.una_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $('.selling_percentage_ret_sale_gold').live('keyup', function() {
        
        item_id = $(this).attr('item-id');
        selling_percentage = $(this).val();
        sales_grams = $('#sales_grams_ret_sale_gold_'+item_id).val();
        
        if(sales_grams){
            sales_grams = sales_grams;
        }else{
            sales_grams = 0;
        }
        if(selling_percentage){
            selling_percentage = selling_percentage;
        }else{
            selling_percentage = 0;
        }
        
        tot = (selling_percentage/100) * sales_grams;
        
        $("#txt_ret_sale_item_amount_gold_"+item_id).val(tot.toFixed(3));
        
        $("#ret_sale_item_amount_gold_"+item_id).html(tot.toFixed(3)+' g');
    });
    
    $('.sales_grams_ret_sale_gold').live('keyup', function() {
        
        item_id = $(this).attr('item-id');
        sales_grams = parseFloat($(this).val());
        selling_percentage = $('#selling_percentage_ret_sale_gold_'+item_id).val();
        prev_sales_grams = parseFloat($('#prev_sales_grams_ret_sale_gold_'+item_id).val());
        
        if(sales_grams){
            sales_grams = sales_grams;
        }else{
            sales_grams = 0;
        }
        if(selling_percentage){
            selling_percentage = selling_percentage;
        }else{
            selling_percentage = 0;
        }
        
        tot = (selling_percentage/100) * sales_grams;
        
        $("#txt_ret_sale_item_amount_gold_"+item_id).val(tot.toFixed(3));
        
        $("#ret_sale_item_amount_gold_"+item_id).html(tot.toFixed(3)+' g');
        
        $(".sales_grams_ret_sale_gold").each(function () {
            if($(this).val()!=''){
                
                item_ids = $(this).attr('item-id');
                all_sales_grams =  parseFloat($(this).val());
                all_prev_sales_grams = parseFloat($('#prev_sales_grams_ret_sale_gold_'+item_ids).val());
        
                console.log('all_sales_grams - '+all_sales_grams);
                console.log('all_prev_sales_grams - '+all_prev_sales_grams);
                
                if(all_sales_grams <= all_prev_sales_grams){
            
                    $("#return_sale_error_msg").addClass("hidden");
                    $("#btn_submit_ret_sale").removeClass("hidden"); 

                }else{

                    $("#btn_submit_ret_sale").addClass("hidden");
                    $("#return_sale_error_msg").removeClass("hidden"); 
                    $("#return_sale_error_msg").html("<strong>Error!</strong> Return Sale Grams cannot exceed Sale Grams.");

                }
            }
        });
    });
    
    $('.selling_rate_ret_sale_credit').live('keyup', function() {
        
        item_id = $(this).attr('item-id');
        selling_rate = $(this).val();
        sales_grams = $('#sales_grams_ret_sale_credit_'+item_id).val();
        k_rate = $('#24k_rate_ret_sale').val();
        
        if(sales_grams){
            sales_grams = sales_grams;
        }else{
            sales_grams = 0;
        }
        if(selling_rate){
            selling_rate = selling_rate;
        }else{
            selling_rate = 0;
        }
        if(k_rate){
            k_rate = k_rate;
        }else{
            k_rate = 0;
        }
        
        sale_amount = (selling_rate * sales_grams)/8;
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#ret_sale_item_amount_credit_"+item_id).html('Rs. '+tot);
        
        selling_percentage = (selling_rate / k_rate)*100;
        
        selling_percentage = selling_percentage.toFixed(2);
        
        $("#selling_percentage_ret_sale_credit_"+item_id).val(selling_percentage);
                
    });
    
    $('.selling_percentage_ret_sale_credit').live('keyup', function() {
        
        item_id = $(this).attr('item-id');
        selling_percentage = $(this).val();
        sales_grams = $('#sales_grams_ret_sale_credit_'+item_id).val();
        k_rate = $('#24k_rate_ret_sale').val();
        
        if(sales_grams){
            sales_grams = sales_grams;
        }else{
            sales_grams = 0;
        }
        if(selling_percentage){
            selling_percentage = selling_percentage;
        }else{
            selling_percentage = 0;
        }
        if(k_rate){
            k_rate = k_rate;
        }else{
            k_rate = 0;
        }
        
        sale_amount = (k_rate * selling_percentage/100)/8 * sales_grams;
        $("#txt_ret_sale_item_amount_credit_"+item_id).val(sale_amount);
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#ret_sale_item_amount_credit_"+item_id).html('Rs. '+tot);
        
        selling_rate = (k_rate * selling_percentage)/100;
        
        $("#selling_rate_ret_sale_credit_"+item_id).val(selling_rate);
        
        
    });
    
    $('.sales_grams_ret_sale_credit').live('keyup', function() {
        
        item_id = $(this).attr('item-id');
        sales_grams = parseFloat($(this).val());
        selling_percentage = $('#selling_percentage_ret_sale_credit_'+item_id).val();
        prev_sales_grams = parseFloat($('#prev_sales_grams_ret_sale_credit_'+item_id).val());
        k_rate = $('#24k_rate_ret_sale').val();
        
        if(sales_grams){
            sales_grams = sales_grams;
        }else{
            sales_grams = 0;
        }
        if(selling_percentage){
            selling_percentage = selling_percentage;
        }else{
            selling_percentage = 0;
        }
        if(k_rate){
            k_rate = k_rate;
        }else{
            k_rate = 0;
        }
        
        sale_amount = (k_rate * selling_percentage/100)/8 * sales_grams;
        $("#txt_ret_sale_item_amount_credit_"+item_id).val(sale_amount);
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#ret_sale_item_amount_credit_"+item_id).html('Rs. '+tot);
        
        $(".sales_grams_ret_sale_credit").each(function () {
            if($(this).val()!=''){
                
                item_ids = $(this).attr('item-id');
                all_sales_grams =  parseFloat($(this).val());
                all_prev_sales_grams = parseFloat($('#prev_sales_grams_ret_sale_credit_'+item_ids).val());
        
                console.log('all_sales_grams - '+all_sales_grams);
                console.log('all_prev_sales_grams - '+all_prev_sales_grams);
                
                if(all_sales_grams <= all_prev_sales_grams){
            
                    $("#return_sale_error_msg").addClass("hidden");
                    $("#btn_submit_ret_sale").removeClass("hidden"); 

                }else{

                    $("#btn_submit_ret_sale").addClass("hidden");
                    $("#return_sale_error_msg").removeClass("hidden"); 
                    $("#return_sale_error_msg").html("<strong>Error!</strong> Return Sale Grams cannot exceed Sale Grams.");

                }
            }
        });
    });
    
    $('#24k_rate_ret_sale').live('keyup', function() {
        
        item_id = $(this).attr('item-id');
        sales_grams = parseFloat($(this).val());
        selling_percentage = $('#selling_percentage_ret_sale_credit_'+item_id).val();
        prev_sales_grams = parseFloat($('#prev_sales_grams_ret_sale_credit_'+item_id).val());
        k_rate = $('#24k_rate_ret_sale').val();
        
        if(sales_grams){
            sales_grams = sales_grams;
        }else{
            sales_grams = 0;
        }
        if(selling_percentage){
            selling_percentage = selling_percentage;
        }else{
            selling_percentage = 0;
        }
        if(k_rate){
            k_rate = k_rate;
        }else{
            k_rate = 0;
        }
        
        $(".sales_grams_ret_sale_credit").each(function () {
            if($(this).val()!=''){
                
                item_ids = $(this).attr('item-id');
                all_sales_grams =  parseFloat($(this).val());
                all_prev_sales_grams = parseFloat($('#prev_sales_grams_ret_sale_credit_'+item_ids).val());
        
                sale_amount = (k_rate * all_prev_sales_grams/100)/8 * all_sales_grams;
                $("#txt_ret_sale_item_amount_credit_"+item_ids).val(sale_amount);
                je_c_amount = Math.round(sale_amount * 100) / 100;
                tot = (je_c_amount).toLocaleString('en');
                
                $("#ret_sale_item_amount_credit_"+item_ids).html('Rs. '+tot);
                
                if(all_sales_grams <= all_prev_sales_grams){
            
                    $("#return_sale_error_msg").addClass("hidden");
                    $("#btn_submit_ret_sale").removeClass("hidden"); 

                }else{

                    $("#btn_submit_ret_sale").addClass("hidden");
                    $("#return_sale_error_msg").removeClass("hidden"); 
                    $("#return_sale_error_msg").html("<strong>Error!</strong> Return Sale Grams cannot exceed Sale Grams.");

                }
            }
        });
    });
    
    $("#return_sale").validate({
        rules: {  
            return_date: {
                required: true
            },
            invoice_number: {
                required: true
            },
            k_rate_ret_sale: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            return_date: "Please select return date",
            invoice_number: "Please enter the invoice number", 
            k_rate_ret_sale: "Please enter 24K amount"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_return_sale",
                type: "POST",
                data: $("#return_sale").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_sale?sale_id="+response.sale_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#add_daily_audit").validate({
        rules: {  
            audit_date: {
                required: true
            },
            cash_balance: {
                required: true
            },
            gold_balance: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            audit_date: "Please select a date",    
            cash_balance: "Please enter cash balance",    
            gold_balance: "Please enter gold balance"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_daily_audit_details",
                type: "POST",
                data: $("#add_daily_audit").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_daily_audit').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#edit_daily_audit").validate({
        rules: {   
            audit_date: {
                required: true
            },
            cash_balance: {
                required: true
            },
            gold_balance: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            audit_date: "Please select a date",    
            cash_balance: "Please enter cash balance",    
            gold_balance: "Please enter gold balance"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_daily_audit_details",
                type: "POST",
                data: $("#edit_daily_audit").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_daily_audit?audit_id="+response.audit_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $('#discount_amount').on('keyup', function () {
        discount_amount = $(this).val();
        payment_total = $('#payment_total').val();
        sale_type = $('#sale_type').val(); 
        
        payment_method = $('#payment_method').val();
        
        if(discount_amount != ''){
            discount_amount = parseFloat(discount_amount);
        }else{
            discount_amount = 0;
        }
        
        console.log(discount_amount);
        
        if(sale_type == 'Credit Sale'){
            balance_total = parseFloat(payment_total - discount_amount);
            balance_total = balance_total.toFixed(2);
            
        }else if(sale_type == 'Gold Sale'){
            balance_total = parseFloat(payment_total - discount_amount);
            balance_total = balance_total.toFixed(3);
            
        }
        
        if(balance_total > 0){
            $("#div_dis_amount_to_be_paid").css('color', '#2d823a');
            $("#div_discount_submit_button").removeClass("hidden");

            $("#discount_alert_error").addClass("hidden");

        }else{
            $("#div_dis_amount_to_be_paid").css('color', '#ff0000');
            $("#div_discount_submit_button").addClass("hidden");

            $("#discount_alert_error").removeClass("hidden");
            $("#discount_alert_error").html("<strong>Error</strong> Entered Discount Amount is more than Balance Amount");
        }
        
        $('#txt_dis_amount_to_be_paid').val(balance_total);
        balance_total = Math.abs(balance_total);
        
        if(sale_type == 'Credit Sale'){
            balance_total = (balance_total).toLocaleString('en'); 
            $('#div_dis_amount_to_be_paid').html('Rs. '+balance_total);
            
        }else if(sale_type == 'Gold Sale'){
            balance_total = (balance_total).toLocaleString('en'); 
            $('#div_dis_amount_to_be_paid').html(balance_total+' g');
            
        }
    });
    
    $("#apply_sale_discount").validate({
        rules: {   
            discount_date: {
                required: true
            },
            discount_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            discount_date: "Please select a date",
            discount_amount: "Please enter discount amount"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $('#sale_discount').modal('hide');
            $.ajax({
                url: BASE_URL+"save_sale_discount",
                type: "POST",
                data: $("#apply_sale_discount").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_sale?sale_id="+response.sale_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $('#other_income').on("change", function () {
        var other_income = $(this).find('option:selected').val();
        
        if(other_income == 'Other'){
            $("#div_other_income").removeClass("hidden");
            $("#div_customers").addClass("hidden");
            
        }else{
            $("#div_other_income").addClass("hidden");
            $("#div_customers").removeClass("hidden");
            
        }
        
    });
    
    $('#payment_method_income').on("change", function () {
        var payment_method = $(this).find('option:selected').val();
        
        if(payment_method == 'Cash'){
            $("#div_cheque_details_income").addClass("hidden");
            $("#div_bank_details_income").addClass("hidden");
            
        }else if(payment_method == 'Cheque'){
            $("#div_cheque_details_income").removeClass("hidden");
            $("#div_bank_details_income").addClass("hidden");
            
        }else if(payment_method == 'Bank Transfer'){
            $("#div_bank_details_income").removeClass("hidden");
            $("#div_cheque_details_income").addClass("hidden");
            
        }else if(payment_method == 'Bank Deposit'){
            $("#div_bank_details_income").removeClass("hidden");
            $("#div_cheque_details_income").addClass("hidden");
            
        }
    });
    
    $("#add_other_income").validate({
        rules: {  
            income_date: {
                required: true
            }, 
            other_income: {
                required: true
            }, 
            payment_amount: {
                required: true
            }, 
            payment_method: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            income_date: "Please select a income date",
            other_income: "Please select a other income",
            payment_amount: "Please enter a payment amount",
            payment_method: "Please select a payment method"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_other_income_details",
                type: "POST",
                data: $("#add_other_income").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_other_income').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#save_do_box_sale").validate({
        rules: {  
            invoice_date: {
                required: true
            }, 
            invoice_number: {
                required: true
            },
            sale_type: {
                required: true
            },
            select_customer: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            invoice_date: "Please select a date",   
            invoice_number: "Please enter the invoice number",  
            sale_type: "Please select a sale type",
            select_customer: "Please select a customer"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            sale_type = $('#sale_type').val(); 
            var appended = false;
            
            if(sale_type == 'Credit Sale'){
                if(credit_appended){
                    appended = true;
                }else{
                    appended = false;
                    
                }
            }else if(sale_type == 'Gold Sale'){
                if(gold_appended){
                    appended = true;
                }else{
                    appended = false;
                    
                }
                
            }
            
            if(appended){
                $(".loaderFull").removeClass("hidden");
                $.ajax({
                    url: BASE_URL+"save_do_box_sale",
                    type: "POST",
                    data: $("#save_do_box_sale").serialize(),
                    success: function (response) {
                        $(".loaderFull").addClass("hidden");
                        if(response.status == 1){
                            window.location.href = BASE_URL+"box_sales";
                            $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                        }else if(response.status == 0){
                            $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                        }
                    }
                });
            }else{
                $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>Please add an item before submitting the invoice</div>");
                $( "html, body" ).scrollTop( 300 );
            }
        }
    });
    
    $("#apply_box_sale_discount").validate({
        rules: {   
            discount_date: {
                required: true
            },
            discount_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            discount_date: "Please select a date",
            discount_amount: "Please enter discount amount"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $('#sale_discount').modal('hide');
            $.ajax({
                url: BASE_URL+"save_box_sale_discount",
                type: "POST",
                data: $("#apply_box_sale_discount").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_box_sale?box_sale_id="+response.sale_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $("#make_normal_box_payment").validate({
        rules: {  
            payment_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            payment_amount: "Please enter paid amount",   
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_make_normal_box_payment",
                type: "POST",
                data: $("#make_normal_box_payment").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_box_sale?box_sale_id="+response.sale_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#make_fixing_box_payment").validate({
        rules: {  
            k_rate_fixing: {
                required: true
            },
            fixing_payment_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            k_rate_fixing: "Please enter 24K amount",   
            fixing_payment_amount: "Please enter paid amount",
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_make_fixing_box_payment",
                type: "POST",
                data: $("#make_fixing_box_payment").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_box_sale?box_sale_id="+response.sale_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#return_box_sale").validate({
        rules: {  
            return_date: {
                required: true
            },
            invoice_number: {
                required: true
            },
            k_rate_ret_sale: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            return_date: "Please select return date",
            invoice_number: "Please enter the invoice number", 
            k_rate_ret_sale: "Please enter 24K amount"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_return_box_sale",
                type: "POST",
                data: $("#return_box_sale").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_box_sale?box_sale_id="+response.sale_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#make_normal_debtor_box_payment").validate({
        rules: {  
            payment_method: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            payment_method: "Please select a payment method",   
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_make_normal_debtor_box_payment",
                type: "POST",
                data: $("#make_normal_debtor_box_payment").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
//                        window.location.href = BASE_URL+"view_debtor?customer_id="+response.customer_id+"&debtor_type="+response.debtor_type;
                        window.location.href = BASE_URL+"view_box_debtor?customer_id="+response.customer_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#make_fixing_debtor_box_payment").validate({
        rules: {  
            invoice_date: {
                required: true
            },  
            k_rate_debtor_fixing: {
                required: true
            },
            payment_method_debtor_fixing: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            invoice_date: "Please select an invoice date",  
            k_rate_debtor_fixing: "Please enter 24K Rate amount",   
            payment_method_debtor_fixing: "Please enter paid amount",
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_make_fixing_debtor_box_payment",
                type: "POST",
                data: $("#make_fixing_debtor_box_payment").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
//                        window.location.href = BASE_URL+"view_debtor?customer_id="+response.customer_id+"&debtor_type="+response.debtor_type;
                        window.location.href = BASE_URL+"view_box_debtor?customer_id="+response.customer_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#add_24k_customer").validate({
        rules: {  
            customer_name: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            customer_name: "Please enter your contact name"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_24k_customer_details",
                type: "POST",
                data: $("#add_24k_customer").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_24k_customer').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#edit_24k_customer").validate({
        rules: {  
            customer_name: {
                required: true
            },
//            contact_num: {
//                required: true,
//                maxlength: 10,
//                number: true
//            },
        },
        // Specify the validation error messages
        messages: { 
            customer_name: "Please enter your contact name"                      
//            contact_num: {
//                required: "Please enter your contact number.",
//                maxength: "Your provide a valid contact number"
//            },
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_24k_customer_details",
                type: "POST",
                data: $("#edit_24k_customer").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#24k_customer_success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $('#24k_customer_sale_24k_rate').live('keyup', function() {
        
        k_rate = $(this).val();
        sales_grams = $('#24k_customer_sale_grams').val();
        
        sale_amount = (k_rate/8)*sales_grams; 
        
        $("#txt_24k_customer_sale_total_amount").val(sale_amount);
        
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#24k_customer_sale_total_amount").html('Rs. '+tot);
                
    });
    
    $('#24k_customer_sale_grams').live('keyup', function() {
        
        sales_grams = $(this).val();
        k_rate = $('#24k_customer_sale_24k_rate').val();
        
        console.log('k_rate - '+k_rate);
        console.log('sales_grams - '+sales_grams);
        
        sale_amount = (k_rate/8)*sales_grams;
        
        $("#txt_24k_customer_sale_total_amount").val(sale_amount);
        
        je_c_amount = Math.round(sale_amount * 100) / 100;
        tot = (je_c_amount).toLocaleString('en');
        
        $("#24k_customer_sale_total_amount").html('Rs. '+tot);
                
    });
    
    $("#save_add_previous_debts_24k_sale").validate({
        rules: {  
            bill_date: {
                required: true
            },
            twofourk_customer_sale_24k_rate: {
                required: true
            },
            twofourk_customer_sale_grams: {
                required: true
            },
            description: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            bill_date: "Please enter bill date",      
            twofourk_customer_sale_24k_rate: "Please enter 24k sale rate",      
            twofourk_customer_sale_grams: "Please enter 24k sale grams",      
            description: "Please enter the description"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_previous_debts_24k_sale",
                type: "POST",
                data: $("#save_add_previous_debts_24k_sale").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_previous_debts').modal('hide');
                        $('#previous_debts_success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $('#withdrawal_amount').on('keyup', function () {
        withdrawal_amount = $(this).val();
        balance_amount = $('#bank_balance_amount').val();
        
        if(withdrawal_amount != ''){
            withdrawal_amount = parseFloat(withdrawal_amount);
        }else{
            withdrawal_amount = 0;
        }
        
        actual_balance_amount = parseFloat(balance_amount - withdrawal_amount);
        actual_balance_amount = actual_balance_amount.toFixed(2);
        
        if(actual_balance_amount > 0){
            $("#div_actual_acc_bal").css('color', '#2d823a');
            $("#div_withdrawal_submit_button").removeClass("hidden");

            $("#withdrawal_alert_error").addClass("hidden");

        }else{
            $("#div_actual_acc_bal").css('color', '#ff0000');
            $("#div_withdrawal_submit_button").addClass("hidden");

            $("#withdrawal_alert_error").removeClass("hidden");
            $("#withdrawal_alert_error").html("<strong>Error</strong> Entered Withdrawal Amount is more than Balance Amount");
        }
        
        $('#txt_actual_acc_bal').val(actual_balance_amount);
        actual_balance_amount = Math.abs(actual_balance_amount);
        
        $('#div_actual_acc_bal').html('Rs. '+actual_balance_amount);
    });
    
    $("#withdraw_cash").validate({
        rules: {   
            withdraw_date: {
                required: true
            },
            withdrawal_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            withdraw_date: "Please select a date",
            withdrawal_amount: "Please enter withdrawal amount"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $('#withdraw_cash_modal').modal('hide');
            $.ajax({
                url: BASE_URL+"save_withdraw_cash",
                type: "POST",
                data: $("#withdraw_cash").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_bank_account?account_id="+response.account_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $("#dxb_sales_report").validate({
        rules: {   
            from_date: {
                required: true
            },
            to_date: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            from_date: "Please select from date",
            to_date: "Please select to date"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
//            $(".loaderFull").removeClass("hidden");
            
            var dataTable = $('#view_dxb_sales_report').DataTable({
                destroy: true,
                order: [[ 0, "desc" ]],
                select: true,
                pageLength: 10,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "Json_data/json_data_records?json_type=dxb_sales_report", // json datasource
                    type: "post", // method  , by default get,
                    data: function ( d ) {
                        d.from_date = $('#sales_report_from_date').val(),
                        d.to_date = $('#sales_report_to_date').val();
                    },
                    error: function () {  // error handling
                        $(".employee-grid-error").html("");
                        $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display", "none");

                    }
                }, "aoColumns": [
                    {"sTitle": "", "sClass": "hidden"},
                    {"sTitle": "Invoice No."},
                    {"sTitle": "Date"},
                    {"sTitle": "Customer Name"},
                    {"sTitle": "Sale Type"},
                    {"sTitle": "Sale Status"},
                    {"sTitle": "Credit Duration Days", "sClass": "hidden"},
                    {"sTitle": "Cr. Du"},
                    {"sTitle": "Balance Amount"},
                    {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', '' + aData[0]);

                }
            });
        }
    });
    
    $('#btn_download_dxb_sales_report').live('click', function() {
        var from_date = $('#sales_report_from_date').val();
        var to_date = $('#sales_report_to_date').val();
        
        if(from_date != '' && to_date != ''){
            window.location.href = BASE_URL+"download_dxb_sales_report?from_date=" + from_date + "&to_date=" + to_date;
        }else{
            alert('Please select data range');
        }
    });
    
    $("#box_sales_report").validate({
        rules: {   
            from_date: {
                required: true
            },
            to_date: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            from_date: "Please select from date",
            to_date: "Please select to date"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
//            $(".loaderFull").removeClass("hidden");
            
            var dataTable = $('#view_box_sales_report').DataTable({
                destroy: true,
                order: [[ 0, "desc" ]],
                select: true,
                pageLength: 10,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "Json_data/json_data_records?json_type=box_sales_report", // json datasource
                    type: "post", // method  , by default get,
                    data: function ( d ) {
                        d.from_date = $('#sales_report_from_date').val(),
                        d.to_date = $('#sales_report_to_date').val();
                    },
                    error: function () {  // error handling
                        $(".employee-grid-error").html("");
                        $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display", "none");

                    }
                }, "aoColumns": [
                    {"sTitle": "", "sClass": "hidden"},
                    {"sTitle": "Invoice No."},
                    {"sTitle": "Date"},
                    {"sTitle": "Customer Name"},
                    {"sTitle": "Sale Type"},
                    {"sTitle": "Sale Status"},
                    {"sTitle": "Credit Duration Days", "sClass": "hidden"},
                    {"sTitle": "Cr. Du"},
                    {"sTitle": "Balance Amount"},
                    {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', '' + aData[0]);

                }
            });
        }
    });
    
    $('#btn_download_box_sales_report').live('click', function() {
        var from_date = $('#sales_report_from_date').val();
        var to_date = $('#sales_report_to_date').val();
        
        if(from_date != '' && to_date != ''){
            window.location.href = BASE_URL+"download_box_sales_report?from_date=" + from_date + "&to_date=" + to_date;
        }else{
            alert('Please select data range');
        }
    });
    
    $("#dxb_debtors_detailed_report").validate({
        rules: {   
            date_as_of: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            date_as_of: "Please select from date"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
//            $(".loaderFull").removeClass("hidden");
            
            var dataTable = $('#view_dxb_debtors_detailed_report').DataTable({
                destroy: true,
                order: [[ 3, "asc" ],[ 0, "asc" ]],
                select: true,
                pageLength: 10,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "Json_data/json_data_records?json_type=dxb_debtors_detailed_report", // json datasource
                    type: "post", // method  , by default get,
                    data: function ( d ) {
                        d.date_as_of = $('#date_as_of').val();
                    },
                    error: function () {  // error handling
                        $(".employee-grid-error").html("");
                        $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display", "none");

                    }
                }, "aoColumns": [
                    {"sTitle": "", "sClass": "hidden"},
                    {"sTitle": "Invoice No."},
                    {"sTitle": "Date"},
                    {"sTitle": "Customer Name"},
                    {"sTitle": "Sale Type"},
                    {"sTitle": "Sale Status"},
                    {"sTitle": "Credit Duration Days", "sClass": "hidden"},
                    {"sTitle": "Cr. Du"},
                    {"sTitle": "Balance Amount"},
                    {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', '' + aData[0]);

                }
            });
        }
    });
    
    $('#btn_download_dxb_debtors_detailed_report').live('click', function() {
        var date_as_of = $('#date_as_of').val();
        
        if(date_as_of != ''){
            window.location.href = BASE_URL+"download_dxb_debtors_detailed_report?date_as_of=" + date_as_of;
        }else{
            alert('Please select data range');
        }
    });
    
    $("#dxb_debtors_aging_report").validate({
        rules: {   
            sale_type: {
                required: true
            },
            date_as_of: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            sale_type: "Please select a sale type",
            date_as_of: "Please select date as of"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
//            $(".loaderFull").removeClass("hidden");
            
            var dataTable = $('#view_dxb_debtors_aging_report').DataTable({
                destroy: true,
                order: [[ 3, "asc" ],[ 0, "asc" ]],
                select: true,
                pageLength: 10,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "Json_data/json_data_records?json_type=dxb_debtors_aging_report", // json datasource
                    type: "post", // method  , by default get,
                    data: function ( d ) {
                        d.sale_type = $('#sale_type').val(),
                        d.date_as_of = $('#date_as_of').val()
                    },
                    error: function () {  // error handling
                        $(".employee-grid-error").html("");
                        $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display", "none");

                    }
                }, "aoColumns": [
                    {"sTitle": "", "sClass": "hidden"},
                    {"sTitle": "Customer Name"},
                    {"sTitle": "0 - 7 Days"},
                    {"sTitle": "8 - 14 Days"},
                    {"sTitle": "15 - 30 Days"},
                    {"sTitle": "Above 30 Days"},
                    {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', '' + aData[0]);

                }
            });
        }
    });
    
    $('#btn_download_dxb_debtors_aging_report').live('click', function() {
        var date_as_of = $('#date_as_of').val();
        var sale_type = $('#sale_type').val();
        
        if(date_as_of != '' && sale_type != ''){
            window.location.href = BASE_URL+"download_dxb_debtors_aging_report?date_as_of=" + date_as_of + "&sale_type=" + sale_type;
        }else{
            alert('Please select data range');
        }
    });
    
    $("#dxb_cash_logs_report").validate({
        rules: {   
            from_date: {
                required: true
            },
            to_date: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            from_date: "Please select from date",
            to_date: "Please select to date"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
//            $(".loaderFull").removeClass("hidden");
            
            var dataTable = $('#view_dxb_cash_logs_report').DataTable({
                destroy: true,
                order: [[ 6, "desc" ]],
                select: true,
                pageLength: 10,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "Json_data/json_data_records?json_type=dxb_cash_logs_report", // json datasource
                    type: "post", // method  , by default get,
                    data: function ( d ) {
                        d.from_date = $('#cash_logs_report_from_date').val(),
                        d.to_date = $('#cash_logs_report_to_date').val();
                    },
                    error: function () {  // error handling
                        $(".employee-grid-error").html("");
                        $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display", "none");

                    }
                }, "aoColumns": [
                    {"sTitle": "", "sClass": "hidden"},
                    {"sTitle": "ID"},
                    {"sTitle": "Action"},
                    {"sTitle": "Description"},
                    {"sTitle": "Amount", "Classname": "dt[-head|-body]-right"},
                    {"sTitle": "Action By"},
                    {"sTitle": "Action On"},
                ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', '' + aData[0]);

                }
            });
        }
    });
    
    $('#btn_download_dxb_cash_logs_report').live('click', function() {
        var from_date = $('#cash_logs_report_from_date').val();
        var to_date = $('#cash_logs_report_to_date').val();
        
        if(from_date != '' && to_date != ''){
            window.location.href = BASE_URL+"download_dxb_cash_logs_report?from_date=" + from_date + "&to_date=" + to_date;
        }else{
            alert('Please select data range');
        }
    });
    
    $("#sales_return_report").validate({
        rules: {   
            from_date: {
                required: true
            },
            to_date: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            from_date: "Please select from date",
            to_date: "Please select to date"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
//            $(".loaderFull").removeClass("hidden");
            
            var dataTable = $('#view_dxb_sales_return_report').DataTable({
                destroy: true,
                order: [[ 0, "desc" ]],
                select: true,
                pageLength: 10,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "Json_data/json_data_records?json_type=dxb_sales_return_report", // json datasource
                    type: "post", // method  , by default get,
                    data: function ( d ) {
                        d.from_date = $('#sales_return_report_from_date').val(),
                        d.to_date = $('#sales_return_report_to_date').val();
                    },
                    error: function () {  // error handling
                        $(".employee-grid-error").html("");
                        $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display", "none");

                    }
                }, "aoColumns": [
                    {"sTitle": "", "sClass": "hidden"},
                    {"sTitle": "Date"},
                    {"sTitle": "Invoice No"},
                    {"sTitle": "Sale Type"},
                    {"sTitle": "Customer"},
                    {"sTitle": "Item"},
                    {"sTitle": "Sale Status"},
                    {"sTitle": "Gross Weight"},
                    {"sTitle": "Gold Price 24K", "Classname": "dt[-head|-body]-right"},
                    {"sTitle": "Selling Rate", "Classname": "dt[-head|-body]-right"},
                    {"sTitle": "Billed Amount", "Classname": "dt[-head|-body]-right"},
                    {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', '' + aData[0]);

                }
            });
            
            var dataTable = $('#view_box_sales_return_report').DataTable({
                destroy: true,
                order: [[ 0, "desc" ]],
                select: true,
                pageLength: 10,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "Json_data/json_data_records?json_type=box_sales_return_report", // json datasource
                    type: "post", // method  , by default get,
                    data: function ( d ) {
                        d.from_date = $('#sales_return_report_from_date').val(),
                        d.to_date = $('#sales_return_report_to_date').val();
                    },
                    error: function () {  // error handling
                        $(".employee-grid-error").html("");
                        $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display", "none");

                    }
                }, "aoColumns": [
                    {"sTitle": "", "sClass": "hidden"},
                    {"sTitle": "Date"},
                    {"sTitle": "Invoice No"},
                    {"sTitle": "Sale Type"},
                    {"sTitle": "Customer"},
                    {"sTitle": "Item"},
                    {"sTitle": "Sale Status"},
                    {"sTitle": "Gross Weight"},
                    {"sTitle": "Gold Price 24K", "Classname": "dt[-head|-body]-right"},
                    {"sTitle": "Selling Rate", "Classname": "dt[-head|-body]-right"},
                    {"sTitle": "Billed Amount", "Classname": "dt[-head|-body]-right"},
                    {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', '' + aData[0]);

                }
            });
        }
    });

    $('#btn_download_sales_return_report').live('click', function() {
        var from_date = $('#sales_return_report_from_date').val();
        var to_date = $('#sales_return_report_to_date').val();
        
        if(from_date != '' && to_date != ''){
            window.location.href = BASE_URL+"download_sales_return_report?from_date=" + from_date + "&to_date=" + to_date;
        }else{
            alert('Please select data range');
        }
    });
    
    $("#24k_sales_report").validate({
        rules: {   
            from_date: {
                required: true
            },
            to_date: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            from_date: "Please select from date",
            to_date: "Please select to date"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
//            $(".loaderFull").removeClass("hidden");
             
            var dataTable = $('#view_24k_sales_report').DataTable({
                destroy: true,
                order: [[ 0, "desc" ]],
                select: true,
                pageLength: 10,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "Json_data/json_data_records?json_type=24k_sales_report", // json datasource
                    type: "post", // method  , by default get,
                    data: function ( d ) {
                        d.from_date = $('#sales_report_from_date').val(),
                        d.to_date = $('#sales_report_to_date').val();
                    },
                    error: function () {  // error handling
                        $(".employee-grid-error").html("");
                        $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display", "none");

                    }
                }, "aoColumns": [
                    {"sTitle": "", "sClass": "hidden"},
                    {"sTitle": "Invoice No."},
                    {"sTitle": "Date"},
                    {"sTitle": "Customer Name"},
                    {"sTitle": "Sale Status"},
                    {"sTitle": "Gold Price 24K"},
                    {"sTitle": "Total Amount"},
                    {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', '' + aData[0]);

                }
            });
        }
    });
    
    $('#btn_download_24k_sales_report').live('click', function() {
        var from_date = $('#sales_report_from_date').val();
        var to_date = $('#sales_report_to_date').val();
        
        if(from_date != '' && to_date != ''){
            window.location.href = BASE_URL+"download_24k_sales_report?from_date=" + from_date + "&to_date=" + to_date;
        }else{
            alert('Please select data range');
        }
    });
    
    $("#dxb_sales_receipt_report").validate({
        rules: {   
            from_date: {
                required: true
            },
            to_date: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            from_date: "Please select from date",
            to_date: "Please select to date"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
//            $(".loaderFull").removeClass("hidden");
            
            var dataTable = $('#view_dxb_fixing_history_report').DataTable({
                destroy: true,
                order: [[ 0, "desc" ]],
                select: true,
                pageLength: 10,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "Json_data/json_data_records?json_type=dxb_fixing_history_report", // json datasource
                    type: "post", // method  , by default get,
                    data: function ( d ) {
                        d.from_date = $('#dxb_sales_receipt_report_from_date').val(),
                        d.to_date = $('#dxb_sales_receipt_report_to_date').val();
                    },
                    error: function () {  // error handling
                        $(".employee-grid-error").html("");
                        $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display", "none");

                    }
                }, "aoColumns": [
                    {"sTitle": "", "sClass": "hidden"},
                    {"sTitle": "Date"},
                    {"sTitle": "Receipt No"},
                    {"sTitle": "Customer"},
                    {"sTitle": "Payment Method"},
                    {"sTitle": "Bank Name"},
                    {"sTitle": "Cheque Num"},
                    {"sTitle": "Deposit Date"},
                    {"sTitle": "Amount", "Classname": "dt[-head|-body]-right"},
                    {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', '' + aData[0]);

                }
            });
            
            var dataTable = $('#view_dxb_gold_receipts_report').DataTable({
                destroy: true,
                order: [[ 0, "desc" ]],
                select: true,
                pageLength: 10,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "Json_data/json_data_records?json_type=dxb_gold_receipts_report", // json datasource
                    type: "post", // method  , by default get,
                    data: function ( d ) {
                        d.from_date = $('#dxb_sales_receipt_report_from_date').val(),
                        d.to_date = $('#dxb_sales_receipt_report_to_date').val();
                    },
                    error: function () {  // error handling
                        $(".employee-grid-error").html("");
                        $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display", "none");

                    }
                }, "aoColumns": [
                    {"sTitle": "", "sClass": "hidden"},
                    {"sTitle": "Date"},
                    {"sTitle": "Receipt No"},
                    {"sTitle": "Customer"},
                    {"sTitle": "Amount", "Classname": "dt[-head|-body]-right"},
                    {"sTitle": "Gold Rate", "Classname": "dt[-head|-body]-right"},
                    {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', '' + aData[0]);

                }
            });
        }
    });

    $('#btn_download_sales_return_report').live('click', function() {
        var from_date = $('#sales_return_report_from_date').val();
        var to_date = $('#sales_return_report_to_date').val();
        
        if(from_date != '' && to_date != ''){
            window.location.href = BASE_URL+"download_sales_return_report?from_date=" + from_date + "&to_date=" + to_date;
        }else{
            alert('Please select data range');
        }
    });
    
    $('#stock_item_category').on("change", function () {
        var stock_item_category = $(this).find('option:selected').val();
        
        if(stock_item_category == 'Add New Category'){
            $("#add_new_category").removeClass("hidden");
            
        }else if(stock_item_category == ''){
            $("#add_new_category").addClass("hidden");
            
        }else{
            $("#add_new_category").addClass("hidden");
        }
    });
    
    $("#add_stock_item_category").validate({
        rules: {  
            category_name: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            category_name: "Please enter category name"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_stock_item_category_details",
                type: "POST",
                data: $("#add_stock_item_category").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_stock_item_category').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#edit_stock_item_category").validate({
        rules: {    
            category_name: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            category_name: "Please enter category name"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_stock_item_category_details",
                type: "POST",
                data: $("#edit_stock_item_category").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_stock_item_category?category_id="+response.category_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $("#add_supplier").validate({
        rules: {  
            supplier_name: {
                required: true
            },
//            contact_num: {
//                required: true,
//                maxlength: 10
//            },
        },
        // Specify the validation error messages
        messages: { 
            supplier_name: "Please enter your contact name",                       
//            contact_num: {
//                required: "Please enter your contact number.",
//                maxength: "Your provide a valid contact number"
//            }
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_supplier_details",
                type: "POST",
                data: $("#add_supplier").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_supplier').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#edit_supplier").validate({
        rules: {  
            supplier_name: {
                required: true
            },
//            contact_num: {
//                required: true,
//                maxlength: 10,
//                number: true
//            }
        },
        // Specify the validation error messages
        messages: { 
            supplier_name: "Please enter your contact name",                       
//            contact_num: {
//                required: "Please enter your contact number.",
//                maxength: "Your provide a valid contact number"
//            }
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_supplier_details",
                type: "POST",
                data: $("#edit_supplier").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#customer_success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $("#add_carrier").validate({
        rules: {  
            carrier_name: {
                required: true
            },
//            contact_num: {
//                required: true,
//                maxlength: 10
//            },
        },
        // Specify the validation error messages
        messages: { 
            carrier_name: "Please enter your contact name",                       
//            contact_num: {
//                required: "Please enter your contact number.",
//                maxength: "Your provide a valid contact number"
//            }
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_add_carrier_details",
                type: "POST",
                data: $("#add_carrier").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#add_new_carrier').modal('hide');
                        $('#success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
    
    $("#edit_carrier").validate({
        rules: {  
            carrier_name: {
                required: true
            },
//            contact_num: {
//                required: true,
//                maxlength: 10,
//                number: true
//            }
        },
        // Specify the validation error messages
        messages: { 
            carrier_name: "Please enter your contact name",                       
//            contact_num: {
//                required: "Please enter your contact number.",
//                maxength: "Your provide a valid contact number"
//            }
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_edit_carrier_details",
                type: "POST",
                data: $("#edit_carrier").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        $('#carrier_success_modal').modal('show');
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");
                        
                    }
                }
            });
        }
    });
    
    $('#quantity_1, #rate_1').live('keyup', function() {
        quantity_1 = $('#quantity_1').val();
        rate_1 = $('#rate_1').val();
        
        if(quantity_1 != ''){
            quantity_1 = parseFloat(quantity_1);
        }
        
        if(rate_1 != ''){
           rate_1 = parseFloat(rate_1);
        }

        amount_1 = (quantity_1/8)*rate_1;
        
        $('#txt_amount_1').val(amount_1);
        amount_1 = Math.abs(amount_1);

        $('#div_amount_1').html('Rs. '+amount_1);
         
    });
    
    $('#quantity_2, #rate_2').live('keyup', function() {
        quantity_2 = $('#quantity_2').val();
        rate_2 = $('#rate_2').val();
        
        if(quantity_2 != ''){
            quantity_2 = parseFloat(quantity_2);
        }
        
        if(rate_2 != ''){
           rate_2 = parseFloat(rate_2);
        }

        amount_2 = (quantity_2/8)*rate_2;
        
        $('#txt_amount_2').val(amount_2);
        amount_2 = Math.abs(amount_2);

        $('#div_amount_2').html('Rs. '+amount_2);
         
    });
    
    $('#quantity_3, #rate_3').live('keyup', function() {
        quantity_3 = $('#quantity_3').val();
        rate_3 = $('#rate_3').val();
        
        if(quantity_3 != ''){
            quantity_3 = parseFloat(quantity_3);
        }
        
        if(rate_3 != ''){
           rate_3 = parseFloat(rate_3);
        }

        amount_3 = (quantity_3/8)*rate_3;
        
        $('#txt_amount_3').val(amount_3);
        amount_3 = Math.abs(amount_3);

        $('#div_amount_3').html('Rs. '+amount_3);
         
    });
    
    $('#purchase_supplier').on("change", function () {
        var purchase_supplier = $(this).find('option:selected').attr('itemid');
               
        $("#purchase_invoice option").remove();

        var purchase_invoice = $("#purchase_invoice");
        
        purchase_invoice.append('<option value="Add New Invoice" itemid="">Add New Invoice</option>');
        
        if(purchase_supplier != ''){
            $.ajax({
                url: BASE_URL+"ajax_get_pending_purchase_supplier_invoices",
                type: "POST",
                data: "supplier_id=" + purchase_supplier,
                success: function (response) {

                    $.each(response, function(k, v) {
                        purchase_invoice.append('<option value="' + v.invoice_num + '" itemid="' + v.id + '">' + v.invoice_num+ '</option>');
                    });


                }
            }); 
        }else{            
            $('#new_purchase_invoice').removeClass("hidden");
            
            $('#invoice_weight').removeAttr("disabled");
            $('#actual_weight').removeAttr("disabled");
            $('#pending_weight').removeAttr("disabled");

            $('#invoice_weight').val('');
            $('#actual_weight').val('');
            $('#pending_weight').val('');
        }
    });
    
    $('#purchase_invoice').on("change", function () {
        var purchase_invoice_id = $(this).find('option:selected').attr('itemid');
        var purchase_invoice = $(this).find('option:selected').val();
        
        if(purchase_invoice != 'Add New Invoice'){
            
            $('#new_purchase_invoice').addClass("hidden");
            $.ajax({
                url: BASE_URL+"ajax_get_invoice_details_purchase",
                type: "POST",
                data: "purchase_supplier_id=" + purchase_invoice_id,
                success: function (response) {
                    $('#invoice_weight').attr("disabled", 'disabled');
                    $('#actual_weight').attr("disabled", 'disabled');
                    $('#pending_weight').attr("disabled", 'disabled');
                    
                    $('#invoice_weight').val(response.invoice_weight);
                    $('#actual_weight').val(response.actual_weight);
                    $('#pending_weight').val(response.pending_weight);
                    
                }
            }); 
        }else{
            $('#new_purchase_invoice').removeClass("hidden");
            
            $('#invoice_weight').removeAttr("disabled");
            $('#actual_weight').removeAttr("disabled");
            $('#pending_weight').removeAttr("disabled");

            $('#invoice_weight').val('');
            $('#actual_weight').val('');
            $('#pending_weight').val('');
            
        }
    });
    
    $('#append_purchase_supplier').click(function(){
                
        $("#btn_append_purchase_supplier").removeClass("hidden");
        
        purchase_supplier = $('#purchase_supplier').val();      
        new_purchase_invoice = $('#new_purchase_invoice').val();
        invoice_weight = $('#invoice_weight').val();
        actual_weight = $('#actual_weight').val();
        pending_weight = $('#pending_weight').val();
        received_weight = $('#received_weight').val();
        
        purchase_invoice_id = $('#purchase_invoice').find('option:selected').attr('itemid');
        purchase_supplier_id = $('#purchase_supplier').find('option:selected').attr('itemid');
        
        purchase_invoice = $('#purchase_invoice').find('option:selected').val();
        purchase_invoice_select = $('#purchase_invoice').find('option:selected').val();
        
        if(purchase_invoice == 'Add New Invoice'){
            purchase_invoice = new_purchase_invoice;
            
        }
        
        item_id = $('#purchase_supplier').find('option:selected').attr('itemid');
        
        console.log('asd');

        if(purchase_supplier !== "" && purchase_invoice !== "" && invoice_weight !== "" && actual_weight !== "" && received_weight !== ""){

            $('#purchase_supplier_table').append('<tr id="delete_purchase_supplier' + item_id + '">\n\\n\
            <td>' + purchase_supplier + '<input type="hidden" name="purchase_data[purchase_supplier][]" value="'+purchase_supplier+'"  /><input type="hidden" name="purchase_data[purchase_supplier_id][]" value="'+purchase_supplier_id+'"  /></td> \n\
            <td>' + purchase_invoice + '<input type="hidden" name="purchase_data[purchase_invoice][]" value="'+purchase_invoice+'"  /><input type="hidden" name="purchase_data[purchase_invoice_id][]" value="'+purchase_invoice_id+'"  /></td> \n\
            <input type="hidden" name="purchase_data[purchase_invoice_select][]" value="'+purchase_invoice_select+'"  /><input type="hidden" name="purchase_data[new_purchase_invoice][]" value="'+new_purchase_invoice+'"  /> \n\
            <td>' + invoice_weight + ' g<input type="hidden" name="purchase_data[invoice_weight][]" value="'+invoice_weight+'"  /></td> \n\
            <td>' + actual_weight + ' g<input type="hidden" name="purchase_data[actual_weight][]" value="'+actual_weight+'"  /></td></td> \n\
            <td>' + pending_weight + ' g<input type="hidden" name="purchase_data[pending_weight][]" value="'+pending_weight+'"  /></td></td> \n\
            <td>' + received_weight + ' g<input type="hidden" name="purchase_data[received_weight][]" value="'+received_weight+'"  /></td></td> \n\
            <td><a title="Remove Item" id="delete_purchase_supplier' + item_id + '" value="' +  purchase_supplier + '" text_value="' +  purchase_supplier + '" class="fa fa-trash-o delete_purchase_supplier"></a></td> </tr>');

            $('#purchase_supplier').val('');
            $('#purchase_supplier').val('');
            $('#new_purchase_invoice').val('');
            $('#invoice_weight').val('');
            $('#actual_weight').val('');
            $('#pending_weight').val('');
            $('#received_weight').val('');
            
        }
        
    });
    
    $('.delete_purchase_supplier').live('click', function() {
        clas = $(this).attr('id');
        
        $('#' + clas).remove();
        
    });
    
    $("#save_do_purchase").validate({
        rules: {  
            invoice_date: {
                required: true
            },
            select_carrier: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            invoice_date: "Please select a date",   
            select_carrier: "Please select a carrier"
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");    
            $(".loaderFull").removeClass("hidden");
            $.ajax({
                url: BASE_URL+"save_do_purchase",
                type: "POST",
                data: $("#save_do_purchase").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    if(response.status == 1){
                        window.location.href = BASE_URL+"grns";
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg_modal").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });          
        }
    });
    
    $('#carrier_payment_amount').on('keyup', function () {
        payment_amount = $(this).val();
        
        console.log(payment_amount);
        
        payment_total = $('#carrier_payment_total').val();
        
        payment_method = $('#payment_method').val();
        
        if(payment_amount != ''){
            payment_amount = parseFloat(payment_amount);
        }else{
            payment_amount = 0;
        }
        
        balance_total = parseFloat(payment_total - payment_amount);
        balance_total = balance_total.toFixed(2);
        
        if(balance_total > 0){
            $("#div_carrier_balance_total").css('color', '#ff0000');
            $("#div_purchase_submit_button").removeClass("hidden");

            $("#alert_info").addClass("hidden");

        }else if(balance_total == 0){
            $("#div_carrier_balance_total").css('color', '#000000');
            $("#div_purchase_submit_button").removeClass("hidden");

            $("#alert_info").addClass("hidden");

        }else{
            $("#div_carrier_balance_total").css('color', '#2d823a');
            $("#div_purchase_submit_button").addClass("hidden");

            $("#alert_info").removeClass("hidden");
            $("#alert_info").html("<strong>Info</strong> Entered Amount is more than Balance Payment. The Excess payment will be add as over payment");

        }
        
        $('#carrier_balance_total').val(balance_total);
        balance_total = Math.abs(balance_total);
        
        balance_total = (balance_total).toLocaleString('en'); 
        $('#div_carrier_balance_total').html('Rs. '+balance_total);
    });
    
    $("#make_carrier_charges_payment").validate({
        rules: {  
            payment_amount: {
                required: true
            }
        },
        // Specify the validation error messages
        messages: { 
            payment_amount: "Please enter paid amount",   
        },
        submitHandler: function (form) {
//            $(".footer-login").addClass("buttonload");
            $(".loaderFull").removeClass("hidden");

            $.ajax({
                url: BASE_URL+"save_make_carrier_charges_payment",
                type: "POST",
                data: $("#make_carrier_charges_payment").serialize(),
                success: function (response) {
                    $(".loaderFull").addClass("hidden");
                    
                    console.log(response);
                    
                    if(response.status == 1){
                        window.location.href = BASE_URL+"view_purchase?purchase_id="+response.purchase_id;
                        $("#response_msg").html("<div class='alert alert-success'><strong>Success! </strong>"+response.message+"</div>");
                    }else if(response.status == 0){
                        $("#response_msg").html("<div class='alert alert-danger'><strong>Error! </strong>"+response.message+"</div>");

                    }
                }
            });
        }
    });
});

function openCreditorAccounts(id){
    var currentRow = $('#'+id).closest('tr'); // Get a reference to the row that has the button we clicked
    var formdata = {'id': id};
    $(".loaderFull").attr("style", '');

    $.ajax({
        url: BASE_URL+"view_creditor_account",
        type: "POST",
        data: formdata,
        success: function (response) {
            $('#view_credit_account').html(response);

        }
    });
}

function openCreditorPayments(id){
    var currentRow = $('#'+id).closest('tr'); // Get a reference to the row that has the button we clicked
    var formdata = {'id': id};
    $(".loaderFull").attr("style", '');

    $.ajax({
        url: BASE_URL+"view_creditor_payment",
        type: "POST",
        data: formdata,
        success: function (response) {
            $('#view_payment_account').html(response);

        }
    });
}

function openSubmitCheque(id){
    var currentRow = $('#'+id).closest('tr'); // Get a reference to the row that has the button we clicked
    var formdata = {'id': id};
    
    $.ajax({
        url: BASE_URL+"view_cheque_details_to_submit",
        type: "POST",
        data: formdata,
        success: function (response) {
            $('#view_cheque_details').html(response);

        }
    });
}
