var EcommerceIndex = function () {

    function showTooltip(x, y, labelX, labelY) {
        $('<div id="tooltip" class="chart-tooltip">RS ' + (labelY.toFixed(2).replace(/(\d)(?=(\d{3})+\.)/g, '$1,')) + '<\/div>').css({
            position: 'absolute',
            display: 'none',
            top: y - 40,
            left: x - 60,
            border: '0px solid #ccc',
            padding: '2px 6px',
            'background-color': '#fff'
        }).appendTo("body").fadeIn(200);
    }

    var initChart1 = function () {
        
        $.ajax({
            url: BASE_URL+"get_monthly_collection_graph_data",
            type: "POST",
            dataType: 'json',
            success: function (response) {
                
                data1 = [];
                data = [];
                $.each(response, function (id, info) {
                    var month = info['month'];
                    var amount = parseInt(info['total']);
                    data1 = [''+month+'', amount]; 
                    data.push(data1);
                    
                });
                
                var plot_statistics = $.plot(
                    $("#statistics_1"), 
                    [
                        {
                            data:data,
                            lines: {
                                fill: 0.6,
                                lineWidth: 0
                            },
                            color: ['#f89f9f']
                        },
                        {
                            data: data,
                            points: {
                                show: true,
                                fill: true,
                                radius: 5,
                                fillColor: "#f89f9f",
                                lineWidth: 3
                            },
                            color: '#fff',
                            shadowSize: 0
                        }
                    ], 
                    {

                        xaxis: {
                            tickLength: 0,
                            tickDecimals: 0,                        
                            mode: "categories",
                            min: 2,
                            font: {
                                lineHeight: 15,
                                style: "normal",
                                variant: "small-caps",
                                color: "#6F7B8A"
                            }
                        },
                        yaxis: {
                            ticks: 3,
                            tickDecimals: 0,
                            tickColor: "#f0f0f0",
                            font: {
                                lineHeight: 15,
                                style: "normal",
                                variant: "small-caps",
                                color: "#6F7B8A"
                            }
                        },
                        grid: {
                            backgroundColor: {
                                colors: ["#fff", "#fff"]
                            },
                            borderWidth: 1,
                            borderColor: "#f0f0f0",
                            margin: 0,
                            minBorderMargin: 0,
                            labelMargin: 20,
                            hoverable: true,
                            clickable: true,
                            mouseActiveRadius: 6
                        },
                        legend: {
                            show: false
                        }
                    }
                );

                var previousPoint = null;

                $("#statistics_1").bind("plothover", function (event, pos, item) {
                    $("#x").text(pos.x.toFixed(2));
                    $("#y").text(pos.y.toFixed(2));
                    if (item) {
                        if (previousPoint != item.dataIndex) {
                            previousPoint = item.dataIndex;

                            $("#tooltip").remove();
                            var x = item.datapoint[0].toFixed(2),
                                y = item.datapoint[1].toFixed(2);

                            showTooltip(item.pageX, item.pageY, item.datapoint[0], item.datapoint[1]);
                        }
                    } else {
                        $("#tooltip").remove();
                        previousPoint = null;
                    }
                }); 
            }
        });
        
        
//        var data = [['01/2018',0], ['02/2018',0], ['03/2018',0], ['04/2018',0], ['05/2018',0], ['06/2018',0], ['07/2018',0], ['08/2018',0], ['09/2018',0], ['10/2018',0], ['11/2018',0], ['12/2018',0], ['01/2019',1870000]];
        
        
        
        
        
        
        
        
        
        
        
        

//        var data = [
//            ['01/2013', 4],
//            ['02/2013', 8],
//            ['03/2013', 10],
//            ['04/2013', 12],
//            ['05/2013', 2125],
//            ['06/2013', 324],
//            ['07/2013', 1223],
//            ['08/2013', 1365],
//            ['09/2013', 250],
//            ['10/2013', 999],
//            ['11/2013', 390]
//        ];

            

    }

    var initChart2 = function() {

        var data = [
            ['01/2013', 10],
            ['02/2013', 0],
            ['03/2013', 10],
            ['04/2013', 12],
            ['05/2013', 212],
            ['06/2013', 324],
            ['07/2013', 122],
            ['08/2013', 136],
            ['09/2013', 250],
            ['10/2013', 99],
            ['11/2013', 190]
        ];
        
        console.log(data);

            var plot_statistics = $.plot(
                $("#statistics_2"), 
                [
                    {
                        data:data,
                        lines: {
                            fill: 0.6,
                            lineWidth: 0
                        },
                        color: ['#BAD9F5']
                    },
                    {
                        data: data,
                        points: {
                            show: true,
                            fill: true,
                            radius: 5,
                            fillColor: "#BAD9F5",
                            lineWidth: 3
                        },
                        color: '#fff',
                        shadowSize: 0
                    }
                ], 
                {

                    xaxis: {
                        tickLength: 0,
                        tickDecimals: 0,                        
                        mode: "categories",
                        min: 2,
                        font: {
                            lineHeight: 14,
                            style: "normal",
                            variant: "small-caps",
                            color: "#6F7B8A"
                        }
                    },
                    yaxis: {
                        ticks: 3,
                        tickDecimals: 0,
                        tickColor: "#f0f0f0",
                        font: {
                            lineHeight: 14,
                            style: "normal",
                            variant: "small-caps",
                            color: "#6F7B8A"
                        }
                    },
                    grid: {
                        backgroundColor: {
                            colors: ["#fff", "#fff"]
                        },
                        borderWidth: 1,
                        borderColor: "#f0f0f0",
                        margin: 0,
                        minBorderMargin: 0,
                        labelMargin: 20,
                        hoverable: true,
                        clickable: true,
                        mouseActiveRadius: 6
                    },
                    legend: {
                        show: false
                    }
                }
            );

            var previousPoint = null;

            $("#statistics_2").bind("plothover", function (event, pos, item) {
                $("#x").text(pos.x.toFixed(2));
                $("#y").text(pos.y.toFixed(2));
                if (item) {
                    if (previousPoint != item.dataIndex) {
                        previousPoint = item.dataIndex;

                        $("#tooltip").remove();
                        var x = item.datapoint[0].toFixed(2),
                            y = item.datapoint[1].toFixed(2);

                       showTooltip(item.pageX, item.pageY, item.datapoint[0], item.datapoint[1]);
                    }
                } else {
                    $("#tooltip").remove();
                    previousPoint = null;
                }
            });

    }

    return {

        //main function
        init: function () {
            initChart1();

            $('#statistics_amounts_tab').on('shown.bs.tab', function (e) {
                initChart2();
            });
        }

    };

}();