
            <div class="row profile">
                <div class="col-md-12">
                    
                    <div id="response_msg"></div>

                    <div id="view_payment_history" class="modal fade" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                    <h4 class="modal-title">Payment History</h4>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-bordered">
                                        <thead>
                                            <th style="width: 10%">
                                                Date
                                            </th>
                                            <th style="width: 16%">
                                                Payment Method
                                            </th>
                                            <th>
                                                Bank
                                            </th>
                                            <th>
                                                Chq. num / Acc. num
                                            </th>
                                            <th style="width: 13%">
                                                Deposit Date
                                            </th>
                                            <th style="width: 13%">
                                                Chq Status
                                            </th>
                                            <?php if($sale_details->sale_type == 'Gold Sale'){ ?>
                                                <th style="width: 15%">
                                                    Paid Amount In Gold
                                                </th>
                                            <?php } ?>
                                            <th style="width: 15%">
                                                Paid Amount In Cash
                                            </th>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            $total_paid_amount_gold = 0;
                                            $total_paid_amount_cash = 0;
                                            foreach($payment_items as $payment_item){ 
                                            if($payment_item['payment_status'] == 2){
                                                $pulse_effect = "style='background-color: #ffe492;'";
                                            }elseif($payment_item['payment_status'] == 3 || $payment_item['payment_status'] == 4){
                                                $pulse_effect = "style='background-color: #ef888c;'";
                                            }else{
                                                $pulse_effect = "";
                                            }    
                                            ?>
                                            <tr <?php echo $pulse_effect; ?>>
                                                <td>
                                                    <?php echo date("d-m-Y", strtotime($payment_item['date'])); ?>
                                                </td>
                                                <td>
                                                    <?php echo $payment_item['payment_method']; ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    if($payment_item['payment_method'] == 'Cheque'){
                                                        echo $payment_item['bank_name'];
                                                    }elseif($payment_item['payment_method'] == 'Bank Deposit'){
                                                        $bank_details = $this->admin_db->get_bank_by_id($payment_item['bank_id']);
                                                        echo $bank_details->bank_name;
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    if($payment_item['payment_method'] == 'Cheque'){
                                                        echo $payment_item['cheque_number'];
                                                    }elseif($payment_item['payment_method'] == 'Bank Deposit'){
                                                        echo $payment_item['account_number'];
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    if($payment_item['payment_method'] == 'Cheque'){
                                                        echo date("d-m-Y", strtotime($payment_item['cheque_deposit_date']));
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    if($payment_item['payment_method'] == 'Cheque'){
                                                        if($payment_item['payment_status'] == 1){
                                                            echo '<span class="label label-success">Deposited</span>';
                                                        }else if($payment_item['payment_status'] == 2){
                                                            echo '<span class="label label-warning">Pending</span>';
                                                        }else if($payment_item['payment_status'] == 3){
                                                            echo '<span class="label label-danger">Rejected</span>';
                                                        }else if($payment_item['payment_status'] == 4){
                                                            echo '<span class="label label-danger">Cancelled</span>';
                                                        }
                                                    }
                                                    ?>
                                                </td>
                                                <?php if($payment_item['payment_type'] == 'Normal'){ ?>
                                                    <td style="text-align: right;">
                                                        <?php
                                                        if($payment_item['payment_status'] == 1){
                                                            $total_paid_amount_gold += $payment_item['paid_amount'];
                                                        }
                                                        if($payment_item['payment_method'] != 'Gold'){
                                                            $total_paid_amount_cash += $payment_item['paid_amount'];
                                                            echo 'Rs. '.number_format($payment_item['paid_amount'],2,'.',','); 
                                                        }else{
                                                            echo number_format($payment_item['paid_amount'],3,'.',',').' g';
                                                        }
                                                        ?>
                                                    </td>
                                                    <?php if($sale_details->sale_type == 'Gold Sale'){ ?>
                                                        <td></td>
                                                    <?php } ?> 
                                                <?php } ?> 
                                                <?php if($sale_details->sale_type == 'Gold Sale' && $payment_item['payment_type'] == 'Fixing'){ 
                                                    $total_paid_amount_gold += $payment_item['fixing_gold']; ?>
                                                    <td style="text-align: right;"><?php echo number_format($payment_item['fixing_gold'],3,'.',',').' g'; ?> </td>
                                                    <td style="text-align: right;">
                                                        <?php
                                                        if($payment_item['payment_status'] == 1){
                                                            $total_paid_amount_cash += $payment_item['paid_amount'];
                                                        }
                                                        if($payment_item['payment_method'] != 'Gold'){
                                                            echo 'Rs. '.number_format($payment_item['paid_amount'],2,'.',','); 
                                                        }else{
                                                            echo number_format($payment_item['fixing_gold'],3,'.',',').' g';
                                                        }
                                                        ?>
                                                    </td>
                                                <?php } ?>
                                            </tr>
                                            <?php } ?>
                                            <tr>
                                                <th colspan="6">
                                                    Total Amount
                                                </th>
                                                <?php if($sale_details->sale_type == 'Gold Sale'){ ?>
                                                    <th style="text-align: right;">
                                                        <?php echo number_format($total_paid_amount_gold,3,'.',',').' g'; ?>
                                                    </th>
                                                <?php } ?>
                                                <th style="text-align: right;">
                                                    <?php if($payment_item['payment_method'] != 'Gold'){ 
                                                        echo 'Rs. '.number_format($total_paid_amount_cash,2,'.',','); 
                                                    }else{
                                                        echo 'Rs. '.number_format($total_paid_amount_cash,2,'.',','); 
                                                    }
                                                    ?>
                                                </th>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div id="sale_discount" class="modal fade" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                    <h4 class="modal-title">Add Discount to this Sale</h4>
                                </div>
                                <form id="apply_sale_discount" class="form-horizontal" method="post">
                                    <div class="modal-body">
                                        <div class="alert alert-danger hidden" id="discount_alert_error"></div>
                                        <div class="scroller" style="height:190px" data-always-visible="1" data-rail-visible1="1">
                                            <input type="hidden" name="sale_id" value="<?php echo $sale_details->id ?>"/>
                                            <input type="hidden" name="customer_id" value="<?php echo $sale_details->customer_id ?>"/>
                                            <input type="hidden" value="<?php echo $sale_details->sale_type ?>" name="sale_type" />
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-body">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-4">Date</label>
                                                            <div class="col-md-3">
                                                                <input class="form-control form-control-inline input-medium date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="discount_date" value="<?php echo date('d-m-Y') ?>"/>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-4">Balance Amount</label>
                                                            <div class="col-md-3">
                                                                <?php if($sale_details->sale_type == 'Credit Sale'){ ?>
                                                                    <div class="control-label pull-left"><?php echo 'Rs. '.number_format($sale_details->balance_amount,2,'.',','); ?></div>
                                                                <?php }elseif($sale_details->sale_type == 'Gold Sale'){ ?>
                                                                    <div class="control-label pull-left"><?php echo number_format($sale_details->balance_amount,3,'.',',').' g'; ?></div>
                                                                <?php } ?>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-4">Discount Amount</label>
                                                            <div class="col-md-3">
                                                                <div class="input-group input-small">
                                                                    <?php if($sale_details->sale_type == 'Credit Sale'){ ?>
                                                                        <span class="input-group-addon">
                                                                            Rs. 
                                                                        </span>
                                                                    <?php } ?>
                                                                    <input class="form-control input-small" type="number" id="discount_amount" name="discount_amount"/>
                                                                    <?php if($sale_details->sale_type == 'Gold Sale'){ ?>
                                                                        <span class="input-group-addon">
                                                                            g
                                                                        </span>
                                                                    <?php } ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-4">Amount to be paid</label>
                                                            <div class="col-md-3">
                                                                <?php if($sale_details->sale_type == 'Credit Sale'){ 
                                                                    $balance_amount = 'Rs. '.number_format($sale_details->balance_amount,2,'.',',');
                                                                    
                                                                }elseif($sale_details->sale_type == 'Gold Sale'){
                                                                    $balance_amount = number_format($sale_details->balance_amount,3,'.',',').' g';

                                                                } ?>
                                                                
                                                                <div class="control-label pull-left" id="div_dis_amount_to_be_paid" style="color: #2d823a"><?php echo $balance_amount; ?></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" data-dismiss="modal" class="btn default">Close</button>
                                        <button type="submit" class="btn green" id="div_discount_submit_button">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="modal fade" id="delete_sale" tabindex="-1" role="basic" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                    <h4 class="modal-title">Delete This Sale!</h4>
                                </div>
                                <div class="modal-body">
                                    Are you sure to delete this sale?
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn red" data-dismiss="modal" onclick="window.location.href='<?php echo base_url().'delete_sale?id=' . $sale_details->id . '\&status=6'; ?>'">Delete</button>
                                    <button type="button" class="btn default" data-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                    
                    <!--BEGIN TABS-->
                    <div class="tabbable tabbable-custom tabbable-full-width">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab_1_1" data-toggle="tab"> Sales Invoice </a>
                            </li>
                            <?php if($sale_details->total_amount > 0 && $sale_details->sale_status != 6) {?>
                                <?php if($sale_details->sale_category == 'Normal' && $sale_details->sale_status != 1 && $sale_details->sale_status != 5) {?>
                                <li>
                                    <a href="#tab_1_2" data-toggle="tab"> Receipt </a>
                                </li>
                                <?php } ?>
                                <?php if($sale_details->sale_category == 'Normal' && $sale_details->sale_status != 1 && $sale_details->sale_status != 4 && $sale_details->sale_status != 5 && $sale_details->sale_type == 'Gold Sale') {?>
                                <li>
                                    <a href="#tab_1_3" data-toggle="tab"> Fixing </a>
                                </li>
                                <?php } ?>
                                <?php if($sale_details->sale_category == 'Normal' && $sale_details->sale_status != 4 && $sale_details->sale_status != 5) {?>
                                <li>
                                    <a href="#tab_1_4" data-toggle="tab"> Return Sale </a>
                                </li>
                                <?php } ?>
                            <?php } ?>
                            <?php if($sale_details->sale_category == 'Normal' && $sale_details->return_sale_amount > 0) {?>
                                <li>
                                    <a href="#tab_1_5" data-toggle="tab"> Returned Sale </a>
                                </li>
                            <?php } ?>
                            <?php if(($this->session->userdata('user_type_id') == 1 || $this->session->userdata('user_type_id') == 3) && $sale_details->sale_status == 4){ ?>
                                <div class="pull-right">
                                    <a class="btn default btn-sm green"  data-toggle="modal" href="<?php echo base_url().'change_this_approval_status?id='.$approval_details->id.'&type=Dxb Sale&status=Approved'; ?>"> Approve</a>
                                    <a class="btn default btn-sm red"  data-toggle="modal" href="<?php echo base_url().'change_this_approval_status?id='.$approval_details->id.'&type=Dxb Sale&status=Rejected'; ?>"> Reject</a>
                                    <a class="btn default btn-sm red"  data-toggle="modal" href="#delete_sale"> Delete Sale</a>
                                    <a class="btn default btn-sm purple-stripe" href="<?php echo base_url().'print_sale?sale_id='.$sale_details->id; ?>"> Print Sale</a>
                                </div>
                            <?php } ?>
                            <?php if($sale_details->sale_status != 4 && $sale_details->sale_status != 6){ ?>
                                <div class="pull-right">
                                    <a class="btn default btn-sm red"  data-toggle="modal" href="#delete_sale"> Delete Sale</a>
                                    <?php if($sale_details->sale_category == 'Normal'){ ?>
                                        <a class="btn default btn-sm purple-stripe" href="<?php echo base_url().'print_sale?sale_id='.$sale_details->id; ?>"> Print Sale</a>
                                    <?php } ?>
                                </div>
                            <?php }elseif($sale_details->sale_status == 5 && $sale_details->sale_category == 'Normal'){ ?>
                                <div class="pull-right">
                                    <a class="btn default btn-sm purple-stripe" href="<?php echo base_url().'print_sale?sale_id='.$sale_details->id; ?>"> Print Sale</a>
                                </div>
                            <?php } ?>
                        </ul>

                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_1_1">
                                <div class="row">
                                    <div class="col-md-12">
                                        <?php if($payment_items){ ?>
                                            <div class="pull-right">
                                                <a class="btn default green-stripe" data-toggle="modal" href="#view_payment_history"> View Payment History</a>
                                            </div>
                                        <?php } ?>
                                        <h4>Sale Details</h4>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-offset-1 col-md-10">
                                                <table class="table table-hover table-bordered table-striped" align="center">
                                                    <tr>
                                                        <td>
                                                            <strong>Invoice Number</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $sale_details->invoice_num; ?>
                                                        </td>
                                                        <td>
                                                            <strong>Date</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo date("d-m-Y", strtotime($sale_details->date)); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Customer Name</strong>
                                                        </td>
                                                        <td>
                                                            <a href="<?php echo base_url().'view_customer?customer_id='.$sale_details->customer_id; ?>"><?php echo $sale_details->customer_name; ?></a>
                                                        </td>
                                                        <td>
                                                            <strong>Contact Number</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $sale_details->contact_number; ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Customer Type</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $sale_details->customer_type; ?>
                                                        </td>
                                                        <td>
                                                            <strong>Customer Status</strong>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            if($sale_details->customer_status == 1){
                                                                echo '<span class="label label-success">Active</span>';
                                                            }else if($sale_details->customer_status == 2){
                                                                echo '<span class="label label-warning">Inactive</span>';
                                                            }else if($sale_details->customer_status == 3){
                                                                echo '<span class="label label-danger">Deleted</span>';
                                                            }else if($sale_details->customer_status == 4){
                                                                echo '<span class="label label-info">Hold-On</span>';
                                                            }
                                                            ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Sale Status</strong>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            if($sale_details->sale_status == 1){
                                                                echo '<span class="label label-success">Payment Completed</span>';
                                                            }else if($sale_details->sale_status == 2){
                                                                echo '<span class="label label-warning">Payment Incomplete</span>';
                                                            }else if($sale_details->sale_status == 3){
                                                                echo '<span class="label label-danger">Payment Pending</span>';
                                                            }else if($sale_details->sale_status == 4){
                                                                echo '<span class="label label-info">Pending Approval</span>';
                                                            }else if($sale_details->sale_status == 5){
                                                                echo '<span class="label label-danger">Rejected</span>';
                                                            }else if($sale_details->sale_status == 6){
                                                                echo '<span class="label label-danger">Deleted</span>';
                                                            }
                                                            ?>
                                                        </td>
                                                        <td>
                                                            <strong>Total Amount</strong>
                                                        </td>
                                                        <td>
                                                            <?php 

                                                            if($sale_details->sale_type == 'Credit Sale'){
                                                                echo 'Rs. '.number_format($sale_details->total_amount,2,'.',',');
                                                            }else if($sale_details->sale_type == 'Gold Sale'){
                                                                echo number_format($sale_details->total_amount,3,'.',',').' g';
                                                            }
                                                            ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Sale Type</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $sale_details->sale_type; ?>
                                                        </td>
                                                        <?php if($sale_details->sale_category == 'Normal'){ ?>
                                                        <?php if($sale_details->sale_type == 'Credit Sale'){ ?>
                                                        <td>
                                                            <strong>24K Rate</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo 'Rs. '.number_format($sale_details->k_rate,2,'.',','); ?>
                                                        </td>
                                                        <?php }else{ ?>
                                                        <td></td>
                                                        <td></td>
                                                        <?php } ?>
                                                        <?php }else{ ?>
                                                        <td colspan="2"><strong>Previous Debt</strong></td>
                                                        <?php } ?>
                                                    </tr>
                                                    <?php if($sale_details->sale_category == 'Old Debts'){ ?>
                                                    <tr>
                                                        <td>
                                                            <strong>Description</strong>
                                                        </td>
                                                        <td colspan="3">
                                                            <?php echo $sale_details->description; ?>
                                                        </td>
                                                    </tr>
                                                    <?php } ?>
                                                </table>
                                            </div>
                                            <!--end col-md-8-->
                                        </div>
                                        <!--end row-->
                                        
                                        <h4>Account Details</h4>
                                        <hr>

                                        <?php if($sale_details->sale_type == 'Credit Sale'){ ?>                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                    <tr>
                                                        <td>
                                                            <strong>Total Amount</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo 'Rs. '.number_format($sale_details->total_amount,2,'.',','); ?></strong>
                                                        </td>
                                                        <?php if($sale_details->return_sale_amount != ''){ ?>
                                                        <td>
                                                            <strong>Returned Amount</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo 'Rs. '.number_format($sale_details->return_sale_amount,2,'.',','); ?></strong>
                                                        </td>
                                                        <?php } ?>
                                                        <?php if($sale_details->discount_amount != ''){ ?>
                                                        <td>
                                                            <strong>Discounted Amount</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo 'Rs. '.number_format($sale_details->discount_amount,2,'.',','); ?></strong>
                                                        </td>
                                                        <?php } ?>
                                                        <td>
                                                            <strong>Total Paid Amount</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo 'Rs. '.number_format($sale_details->total_amount - ($sale_details->balance_amount + $sale_details->discount_amount + $sale_details->return_sale_amount),2,'.',','); ?></strong>
                                                        </td>
                                                        <td>
                                                            <strong>Total Balance</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount = $sale_details->balance_amount;
                                                            if($balance_amount > 0){
                                                                $col_colour = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour; ?>">
                                                            <strong><?php echo 'Rs. '.number_format($balance_amount,2,'.',','); ?></strong>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        <?php }else if($sale_details->sale_type == 'Gold Sale'){ ?>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                    <tr>
                                                        <td>
                                                            <strong>Total Amount</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($sale_details->total_amount,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                        <?php if($sale_details->return_sale_amount != ''){ ?>
                                                        <td>
                                                            <strong>Returned Amount</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($sale_details->return_sale_amount,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                        <?php } ?>
                                                        <?php if($sale_details->discount_amount != ''){ ?>
                                                        <td>
                                                            <strong>Discounted Amount</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($sale_details->discount_amount,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                        <?php } ?>
                                                        <td>
                                                            <strong>Total Paid Amount</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($sale_details->total_amount - ($sale_details->balance_amount + $sale_details->discount_amount + $sale_details->return_sale_amount),3,'.',',').' g'; ?></strong>
                                                        </td>
                                                        <td>
                                                            <strong>Total Balance</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount = $sale_details->balance_amount;
                                                            if($balance_amount > 0){
                                                                $col_colour = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour; ?>">
                                                            <strong><?php echo number_format($balance_amount,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        
                                        <?php if($fixing_items){ ?>
                                                                                
                                        <h4>Fixing Details</h4>
                                        <hr>
                                        
                                        <div id="view_fixing_history" class="modal fade" tabindex="-1" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                        <h4 class="modal-title">Fixing History</h4>
                                                    </div>
                                                    <div class="modal-body">
                                                        <table class="table table-bordered">
                                                            <thead>
                                                                <th style="width: 10%">
                                                                    Date
                                                                </th>
                                                                <th style="width: 16%">
                                                                    24K Rate
                                                                </th>
                                                                <th style="width: 15%">
                                                                    Paid Amount In Cash
                                                                </th>
                                                                <th style="width: 15%">
                                                                    Amount in Gold
                                                                </th>
                                                            </thead>
                                                            <tbody>
                                                                <?php 
                                                                $total_fixing_cash = 0;
                                                                $total_fixing_gold = 0;
                                                                foreach($fixing_items as $fixing_item){    
                                                                ?>
                                                                <tr>
                                                                    <td>
                                                                        <?php echo date("d-m-Y", strtotime($fixing_item['date'])); ?>
                                                                    </td>
                                                                    <td>
                                                                        <?php echo 'Rs. '.number_format($fixing_item['24k_rate'],2,'.',','); ?>
                                                                    </td>
                                                                    <td style="text-align: right;">
                                                                        <?php
                                                                            $total_fixing_cash += $fixing_item['paid_amount_in_cash'];
                                                                            echo 'Rs. '.number_format($fixing_item['paid_amount_in_cash'],2,'.',','); 
                                                                        ?>
                                                                    </td>
                                                                    <td style="text-align: right;">
                                                                        <?php
                                                                            $total_fixing_gold += $fixing_item['paid_amount_in_gold'];
                                                                            echo number_format($fixing_item['paid_amount_in_gold'],3,'.',',').' g'; 
                                                                        ?>
                                                                    </td>
                                                                </tr>
                                                                <?php } ?>
                                                                <tr>
                                                                    <th colspan="2">
                                                                        Total Amount
                                                                    </th>
                                                                    <th style="text-align: right;">
                                                                        <?php echo 'Rs. '.number_format($total_fixing_cash,2,'.',','); ?>
                                                                    </th>
                                                                    <th style="text-align: right;">
                                                                        <?php echo number_format($total_fixing_gold,3,'.',',').' g'; ?>
                                                                    </th>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                    <tr>
                                                        <td>
                                                            <strong>Total Paid In Cash</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo 'Rs. '.number_format($total_fixing_cash,2,'.',','); ?></strong>
                                                        </td>
                                                        <td>
                                                            <strong>Total in Gold</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($total_fixing_gold,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                        <td>
                                                            <strong>
                                                                <div class="pull-right">
                                                                    <a class="btn default green-stripe"  data-toggle="modal" href="#view_fixing_history"> View Fixing History</a>
                                                                </div>
                                                            </strong>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        <?php }} ?>
                                        
                                        <?php if($sale_items){ ?>
                                        <h4>Sale Items</h4>
                                        <hr>
                                        <?php if($sale_details->sale_type == 'Credit Sale'){ ?>
                                            <table class="table table-striped table-bordered table-hover" id="">
                                                <thead>
                                                    <tr>
                                                        <th style=""><strong>Item Name</strong></th>
                                                        <th style=""><strong>Description</strong></th>
                                                        <th style=""><strong>Selling Percentage</strong></th>
                                                        <th style=""><strong>Selling Rate</strong></th>
                                                        <th style=""><strong>Sales in Grams (g) - 22K</strong></th>
                                                        <th style=""><strong>Amount</strong></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php 
                                                    $total_amount = 0;
                                                    $total_grams = 0;

                                                    foreach($sale_items as $sale_item) { ?>                                                        
                                                    <tr>
                                                        <td><?php echo $sale_item['item_name']; ?></td>
                                                        <td><?php echo $sale_item['description']; ?></td>
                                                        <td><?php echo $sale_item['selling_percentage'].' %'; ?></td>
                                                        <td><?php echo 'Rs. '.number_format($sale_item['selling_rate'],2,'.',','); ?></td>
                                                        <td><?php $total_grams += $sale_item['sales_grams']; echo number_format($sale_item['sales_grams'],3,'.',','). ' g'; ?></td>
                                                        <td><?php $total_amount += $sale_item['amount']; echo 'Rs. '.number_format($sale_item['amount'],2,'.',','); ?></td>
                                                    </tr> 
                                                    <?php }?> 
                                                    <tr>
                                                        <th colspan="4">Total</th>
                                                        <th><?php echo number_format($total_grams,3,'.',','). ' g'; ?></th>
                                                        <th><?php echo 'Rs. '.number_format($total_amount,2,'.',','); ?></th>
                                                    </tr>  
                                                </tbody>
                                            </table>                                            
                                        <?php }else if($sale_details->sale_type == 'Gold Sale'){ ?>
                                            <table class="table table-striped table-bordered table-hover" id="">
                                                <thead>
                                                    <tr>
                                                        <th style=""><strong>Item Name</strong></th>
                                                        <th style=""><strong>Description</strong></th>
                                                        <th style=""><strong>Selling Percentage</strong></th>
                                                        <th style=""><strong>Sales in Grams (g) - 22K</strong></th>
                                                        <th style=""><strong>Amount</strong></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php 
                                                    $total_amount = 0;
                                                    $total_grams = 0;

                                                    foreach ($sale_items as $sale_item) { ?>                                                        
                                                    <tr>
                                                        <td><?php echo $sale_item['item_name']; ?></td>
                                                        <td><?php echo $sale_item['description']; ?></td>
                                                        <td><?php echo $sale_item['selling_percentage'].' %'; ?></td>
                                                        <td><?php $total_grams += $sale_item['sales_grams']; echo number_format($sale_item['sales_grams'],3,'.',','). ' g'; ?></td>
                                                        <td><?php $total_amount += $sale_item['amount']; echo number_format($sale_item['amount'],3,'.',','). ' g'; ?></td>
                                                    </tr>
                                                    <?php }?> 
                                                    <tr>
                                                        <th colspan="3">Total</th>
                                                        <th><?php echo number_format($total_grams,3,'.',','). ' g'; ?></th>
                                                        <th><?php echo number_format($total_amount,3,'.',','). ' g'; ?></th>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        <?php } ?>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                            <!--tab_1_2-->
                            <div class="tab-pane" id="tab_1_2">
                                <div class="row profile-account">
                                    <div class="col-md-12">
                                        <div class="portlet box grey-cascade">
                                            <div class="portlet-title">
                                                <div class="caption">
                                                    <i class="fa fa-money"></i>Make Payment
                                                </div>
                                            </div>
                                            <div class="portlet-body form">
                                                <div class="alert alert-info hidden" id="alert_info"></div>
                                                <div class="alert alert-danger hidden" id="alert_error"></div>
							
                                                <!-- BEGIN FORM-->
                                                <form id="make_normal_payment" class="form-horizontal" method="POST" enctype="multipart/form-data">
                                                    <input type="hidden" name="sale_id" value="<?php echo $sale_details->id ?>"/>
                                                    <input type="hidden" name="customer_id" value="<?php echo $sale_details->customer_id ?>"/>
                                                    <div class="form-body">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">Date</label>
                                                            <div class="col-md-3">
                                                                <input class="form-control form-control-inline input-large date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="invoice_date" value="<?php echo date('d-m-Y') ?>"/>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">Sale Type</label>
                                                            <div class="col-md-3">
                                                                <div class="control-label pull-left"><?php echo $sale_details->sale_type; ?></div>
                                                            </div>
                                                        </div>
                                                        <?php if($sale_details->sale_type == 'Credit Sale'){ ?>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">24K Rate</label>
                                                            <div class="col-md-3">
                                                                <div class="control-label pull-left"><?php echo 'Rs. '.number_format($sale_details->k_rate,2,'.',','); ?></div>
                                                            </div>
                                                        </div>
                                                        <?php } ?>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">Payment Method</label>
                                                            <div class="col-md-3">
                                                                <select class="form-control input-large" name="payment_method" id="payment_method">
                                                                    <?php if($sale_details->sale_type == 'Credit Sale'){ ?>
                                                                        <option value="Cash">Cash</option>
                                                                        <?php if($sale_details->over_paid_cash > 0){ ?>
                                                                            <option value="Over Paid Cash">Over Paid Cash</option>
                                                                        <?php } ?>
                                                                        <option value="Cheque">Cheque</option>
                                                                        <option value="Bank Deposit">Bank Deposit</option>
                                                                    <?php }elseif($sale_details->sale_type == 'Gold Sale'){?>
                                                                        <option value="Gold">Gold</option>
                                                                        <?php if($sale_details->over_paid_cash > 0){ ?>
                                                                            <option value="Over Paid Gold">Over Paid Gold</option>
                                                                        <?php } ?>
                                                                    <?php }?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div id="div_over_paid_gold_details" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Over Paid Gold</label>
                                                                <div class="col-md-3">
                                                                    <div class="control-label pull-left"><?php echo number_format($sale_details->over_paid_gold,3,'.',',').' g'; ?></div>
                                                                    <input type="hidden" id="over_paid_gold" value="<?php echo $sale_details->over_paid_gold; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="div_over_paid_cash_details" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Over Paid Cash</label>
                                                                <div class="col-md-3">
                                                                    <div class="control-label pull-left"><?php echo 'Rs. '.number_format($sale_details->over_paid_cash,2,'.',','); ?></div>
                                                                    <input type="hidden" id="over_paid_gold" value="<?php echo $sale_details->over_paid_cash; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div id="div_cheque_details" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Bank Name</label>
                                                                <div class="col-md-3">
                                                                    <select class="form-control input-large select2me" name="cheq_bank" id="cheq_bank">
                                                                    <?php
                                                                        $banks = $this->admin_db->get_banks_for_receipts();
                                                                        foreach ($banks as $bank) {
                                                                            $sel = '';
                                                                    ?>

                                                                    <option value="<?php echo $bank['id']; ?>" <?php echo $sel; ?>><?php echo $bank['bank_name']; ?></option>

                                                                    <?php } ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Cheque Number</label>
                                                                <div class="col-md-3">
                                                                    <input class="form-control input-large" type="number" name="cheq_cheque_number" id="cheq_cheque_number"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Deposit Date</label>
                                                                <div class="col-md-3">
                                                                    <input class="form-control form-control-inline input-large date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="cheq_deposit_date" value="<?php echo date('d-m-Y') ?>"/>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="div_deposit_details" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Bank Account</label>
                                                                <div class="col-md-3">
                                                                    <select class="form-control input-large select2me" name="deposit_bank_account" id="deposit_bank_account">
                                                                    <?php
                                                                        $accounts = $this->admin_db->get_dxb_bank_accounts_for_receipts();
                                                                        foreach ($accounts as $account) {
                                                                            $sel = '';
                                                                    ?>

                                                                    <option value="<?php echo $account['id']; ?>" <?php echo $sel; ?>><?php echo $account['account_name'].' - '.$account['account_number'].' - '.$account['bank_name']; ?></option>

                                                                    <?php } ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        
                                                        <h4>Sale Items</h4>
                                                        <hr>
                                                        <?php if($sale_details->sale_type == 'Credit Sale'){ ?>
                                                            <table class="table table-striped table-bordered table-hover" id="">
                                                                <thead>
                                                                    <tr>
                                                                        <th style=""><strong>Item Name</strong></th>
                                                                        <th style=""><strong>Description</strong></th>
                                                                        <th style=""><strong>Selling Percentage</strong></th>
                                                                        <th style=""><strong>Selling Rate</strong></th>
                                                                        <th style=""><strong>Sales in Grams (g) - 22K</strong></th>
                                                                        <th style=""><strong>Amount</strong></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $total_amount = 0;

                                                                    foreach($sale_items as $sale_item) { ?>                                                        
                                                                    <tr>
                                                                        <td><?php echo $sale_item['item_name']; ?></td>
                                                                        <td><?php echo $sale_item['description']; ?></td>
                                                                        <td><?php echo $sale_item['selling_percentage'].' %'; ?></td>
                                                                        <td><?php echo 'Rs. '.number_format($sale_item['selling_rate'],2,'.',','); ?></td>
                                                                        <td><?php echo number_format($sale_item['sales_grams'],3,'.',','). ' g'; ?></td>
                                                                        <td><?php $total_amount += $sale_item['amount']; echo 'Rs. '.number_format($sale_item['amount'],2,'.',','); ?></td>
                                                                    </tr> 
                                                                    <?php }?> 
                                                                    <tr>
                                                                        <th colspan="5">Total</th>
                                                                        <th><?php echo 'Rs. '.number_format($total_amount,2,'.',','); ?></th>
                                                                    </tr> 
                                                                    <?php if($sale_details->return_sale_amount != ''){ ?>
                                                                    <tr>
                                                                        <th colspan="5">Returned Amount</th>
                                                                        <th><?php echo 'Rs. '.number_format($sale_details->return_sale_amount,2,'.',','); ?></th>
                                                                    </tr>
                                                                    <?php }?> 
                                                                    <?php if($sale_details->discount_amount != ''){ ?>
                                                                    <tr>
                                                                        <th colspan="5">Discounted Amount</th>
                                                                        <th><?php echo 'Rs. '.number_format($sale_details->discount_amount,2,'.',','); ?></th>
                                                                    </tr>
                                                                    <?php }?>
                                                                    <?php 
                                                                    if($sale_details->status == 2){ 
                                                                        $paid_amount = $total_amount - ($sale_details->balance_amount + $sale_details->discount_amount + $sale_details->return_sale_amount);
                                                                        $total_amount = $sale_details->balance_amount;
                                                                    ?>
                                                                        <tr>
                                                                            <th colspan="5">Paid Amount</th>
                                                                            <th><?php echo 'Rs. '.number_format($paid_amount,2,'.',','); ?></th>
                                                                        </tr> 
                                                                        <tr>
                                                                            <th colspan="5">Balance Amount</th>
                                                                            <th><?php echo 'Rs. '.number_format($total_amount,2,'.',','); ?></th>
                                                                        </tr> 
                                                                    <?php } else{
                                                                        $paid_amount = $total_amount - ($sale_details->balance_amount + $sale_details->discount_amount + $sale_details->return_sale_amount);
                                                                        $total_amount = $sale_details->balance_amount;
                                                                    } ?>
                                                                </tbody>
                                                            </table>                                            
                                                        <?php }else if($sale_details->sale_type == 'Gold Sale'){ ?>
                                                            <table class="table table-striped table-bordered table-hover" id="">
                                                                <thead>
                                                                    <tr>
                                                                        <th style=""><strong>Item Name</strong></th>
                                                                        <th style=""><strong>Description</strong></th>
                                                                        <th style=""><strong>Selling Percentage</strong></th>
                                                                        <th style=""><strong>Sales in Grams (g) - 22K</strong></th>
                                                                        <th style=""><strong>Amount</strong></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $total_amount = 0;
                                                                    
                                                                    foreach ($sale_items as $sale_item) { ?>                                                        
                                                                    <tr>
                                                                        <td><?php echo $sale_item['item_name']; ?></td>
                                                                        <td><?php echo $sale_item['description']; ?></td>
                                                                        <td><?php echo $sale_item['selling_percentage'].' %'; ?></td>
                                                                        <td><?php echo number_format($sale_item['sales_grams'],3,'.',','). ' g'; ?></td>
                                                                        <td><?php $total_amount += $sale_item['amount']; echo number_format($sale_item['amount'],3,'.',','). ' g'; ?></td>
                                                                    </tr>
                                                                    <?php }?> 
                                                                    <tr>
                                                                        <th colspan="4">Total</th>
                                                                        <th><?php echo number_format($sale_details->total_amount,3,'.',','). ' g'; ?></th>
                                                                    </tr>
                                                                    <?php if($sale_details->return_sale_amount != ''){ ?>
                                                                    <tr>
                                                                        <th colspan="4">Returned Amount</th>
                                                                        <th><?php echo number_format($sale_details->return_sale_amount,3,'.',',').' g'; ?></th>
                                                                    </tr>
                                                                    <?php }?> 
                                                                    <?php if($sale_details->discount_amount != ''){ ?>
                                                                    <tr>
                                                                        <th colspan="4">Discounted Amount</th>
                                                                        <th><?php echo number_format($sale_details->discount_amount,3,'.',',').' g'; ?></th>
                                                                    </tr>
                                                                    <?php }?>
                                                                    <?php 
                                                                    if($sale_details->status == 2){ 
                                                                        $paid_amount = $total_amount - ($sale_details->balance_amount + $sale_details->discount_amount);
                                                                        $total_amount = $sale_details->balance_amount - $sale_details->return_sale_amount;
                                                                    ?>
                                                                        <tr>
                                                                            <th colspan="4">Paid Amount</th>
                                                                            <th><?php echo number_format($paid_amount,3,'.',',').' g'; ?></th>
                                                                        </tr> 
                                                                        <tr>
                                                                            <th colspan="4">Balance Amount</th>
                                                                            <th><?php echo number_format($total_amount,3,'.',',').' g'; ?></th>
                                                                        </tr> 
                                                                    <?php } else{
                                                                            $paid_amount = $total_amount - ($sale_details->balance_amount + $sale_details->discount_amount);
                                                                            $total_amount = $sale_details->balance_amount;
                                                                    } ?>
                                                                </tbody>
                                                            </table>
                                                        <?php } ?>
                                                        
                                                        <div class="invoice">
                                                            <div class="row">
                                                                <div class="col-xs-4"> </div>
                                                                <div class="col-xs-8 invoice-block" align="right">
                                                                    <ul class="list-unstyled amounts" style="font-size: 20px">
                                                                        <li>
                                                                            <?php if($sale_details->sale_type == 'Credit Sale'){
                                                                                $total_amount_display = 'Rs. '.number_format($total_amount,2,'.',',');
                                                                            }else if($sale_details->sale_type == 'Gold Sale'){
                                                                                $total_amount_display = number_format($total_amount,3,'.',','). ' g';
                                                                            } ?>
                                                                            <input type="hidden" value="<?php echo $sale_details->sale_type ?>" id="sale_type" />
                                                                            
                                                                            <strong>Amount to be Paid : </strong><div><?php echo $total_amount_display; ?></div>
                                                                            <input type="hidden" name="payment_total" value="<?php echo $total_amount ?>" id="payment_total" />
                                                                        </li>
                                                                        <li>
                                                                            <strong>Payment Amount : </strong>
                                                                            <div class="input-group input-small">
                                                                                <?php if($sale_details->sale_type == 'Credit Sale'){ ?>
                                                                                    <span class="input-group-addon">
                                                                                        Rs.
                                                                                    </span>
                                                                                <?php } ?>
                                                                                <input type="number" name="payment_amount" class="form-control input-small" value="" id="payment_amount" />
                                                                                <?php if($sale_details->sale_type == 'Gold Sale'){ ?>
                                                                                    <span class="input-group-addon">
                                                                                        g
                                                                                    </span>
                                                                                <?php } ?>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <strong>Balance Amount : </strong><div id="div_balance_total" style="color: #ff0000"><?php echo $total_amount_display; ?></div>
                                                                            <input type="hidden" name="balance_total" value="<?php echo $sale_details->total_amount ?>" id="balance_total" />
                                                                        </li>
                                                                    </ul>
                                                                    <br/>
                                                                    
                                                                    <button type="button" class="btn btn-lg hidden-print margin-bottom-5" data-toggle="modal" href="#sale_discount">
                                                                        Apply Discount
                                                                    </button>
                                                                    <button type="submit" class="btn btn-lg green hidden-print margin-bottom-5" id="div_submit_button">
                                                                    Submit Payment <i class="fa fa-check"></i>
                                                                    </button>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--tab_1_3-->
                            <div class="tab-pane" id="tab_1_3">
                                <div class="row profile-account">
                                    <div class="col-md-12">
                                        <div class="portlet box grey-cascade">
                                            <div class="portlet-title">
                                                <div class="caption">
                                                    <i class="fa fa-money"></i>Make Fixing Payment
                                                </div>
                                            </div>
                                            <div class="portlet-body form">
                                                <!-- BEGIN FORM-->
                                                <form id="make_fixing_payment" class="form-horizontal" method="POST" enctype="multipart/form-data">
                                                    <input type="hidden" name="sale_id" value="<?php echo $sale_details->id ?>"/>
                                                    <input type="hidden" name="customer_id" value="<?php echo $sale_details->customer_id ?>"/>
                                                    <div class="form-body">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">Date</label>
                                                            <div class="col-md-3">
                                                                <input class="form-control form-control-inline input-large date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="invoice_date" value="<?php echo date('d-m-Y') ?>"/>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">Sale Type</label>
                                                            <div class="col-md-3">
                                                                <div class="control-label pull-left"><?php echo $sale_details->sale_type; ?></div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">24K Rate</label>
                                                            <div class="col-md-3">
                                                                <input class="form-control" type="number" id="24k_rate_fixing" name="k_rate_fixing"/>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">Payment Method</label> 
                                                            <div class="col-md-3">
                                                                <select class="form-control input-large" name="payment_method" id="payment_method_fixing">
                                                                    <option value="Cash">Cash</option>
                                                                    <option value="Cheque">Cheque</option>
                                                                    <option value="Bank Deposit">Bank Deposit</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div id="div_cheque_details_fixing" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Bank Name</label>
                                                                <div class="col-md-3">
                                                                    <select class="form-control input-large select2me" name="cheq_bank" id="cheq_bank">
                                                                    <?php
                                                                        $banks = $this->admin_db->get_banks_for_receipts();
                                                                        foreach ($banks as $bank) {
                                                                            $sel = '';
                                                                    ?>

                                                                    <option value="<?php echo $bank['id']; ?>" <?php echo $sel; ?>><?php echo $bank['bank_name']; ?></option>

                                                                    <?php } ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Cheque Number</label>
                                                                <div class="col-md-3">
                                                                    <input class="form-control input-large" type="number" name="cheq_cheque_number" id="cheq_cheque_number"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Deposit Date</label>
                                                                <div class="col-md-3">
                                                                    <input class="form-control form-control-inline input-large date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="cheq_deposit_date" value="<?php echo date('d-m-Y') ?>"/>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="div_deposit_details_fixing" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Bank Account</label>
                                                                <div class="col-md-3">
                                                                    <select class="form-control input-large select2me" name="deposit_bank_account" id="deposit_bank_account">
                                                                    <?php
                                                                        $accounts = $this->admin_db->get_dxb_bank_accounts_for_receipts();
                                                                        foreach ($accounts as $account) {
                                                                            $sel = '';
                                                                    ?>

                                                                    <option value="<?php echo $account['id']; ?>" <?php echo $sel; ?>><?php echo $account['account_name'].' - '.$account['account_number'].' - '.$account['bank_name']; ?></option>

                                                                    <?php } ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        
                                                        <h4>Sale Items</h4>
                                                        <hr>
                                                        <?php if($sale_details->sale_type == 'Gold Sale'){ ?>
                                                            <table class="table table-striped table-bordered table-hover" id="">
                                                                <thead>
                                                                    <tr>
                                                                        <th style=""><strong>Item Name</strong></th>
                                                                        <th style=""><strong>Description</strong></th>
                                                                        <th style=""><strong>Selling Percentage</strong></th>
                                                                        <th style=""><strong>Sales in Grams (g) - 22K</strong></th>
                                                                        <th style=""><strong>Amount in Grams</strong></th>
                                                                        <th style=""><strong>Amount in Rupees</strong></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $total_amount = 0;
                                                                    $x = 0;
                                                                    foreach ($sale_items as $key => $sale_item) { 
                                                                    ?>                                                        
                                                                    <tr>
                                                                        <td>
                                                                            <?php echo $sale_item['item_name']; ?>
                                                                        </td>
                                                                        <td>
                                                                            <?php echo $sale_item['description']; ?>
                                                                        </td>
                                                                        <td>
                                                                            <?php echo $sale_item['selling_percentage'].' %'; ?>
                                                                        </td>
                                                                        <td>
                                                                            <?php echo number_format($sale_item['sales_grams'],3,'.',','). ' g'; ?>
                                                                        </td>
                                                                        <td>
                                                                            <?php $total_amount += $sale_item['amount']; echo number_format($sale_item['amount'],3,'.',','). ' g'; ?>
                                                                            <input type="hidden" id="fixing_sales_grams_<?php echo $key; ?>" value="<?php echo $sale_item['amount'];?>">
                                                                        </td>
                                                                        <td>
                                                                            <div class="pull-right">
                                                                                <div id="div_fixing_item_total_<?php echo $key; ?>">Rs. 0.00</div>
                                                                                <input type="hidden" id="fixing_item_total_<?php echo $key; ?>" class="fixing_item_total" value="0.00">
                                                                            </div>
                                                                        </td>
                                                                    </tr>
                                                                    <?php $x++; }?> 
                                                                    <input type="hidden" id="no_of_sale_items" value="<?php echo $x; ?>">
                                                                    <tr>
                                                                        <th colspan="4">Total</th>
                                                                        <th><?php echo number_format($sale_details->total_amount,3,'.',','). ' g'; ?></th>
                                                                        <th>
                                                                            <div class="pull-right">
                                                                                <div id="div_fixing_total_amount">Rs. 0.00</div>
                                                                                <input type="hidden" id="fixing_total_amount" value="0.00">
                                                                            </div>
                                                                        </th>
                                                                    </tr>
                                                                    <?php if($sale_details->discount_amount != ''){ ?> 
                                                                    <tr>
                                                                        <th colspan="4">Total Discounts</th>
                                                                        <th><?php echo number_format($sale_details->discount_amount,3,'.',','). ' g'; ?></th>
                                                                        <th>
                                                                            <div class="pull-right">
                                                                                <div id="div_fixing_total_amount">Rs. 0.00</div>
                                                                                <input type="hidden" id="fixing_total_amount" value="0.00">
                                                                            </div>
                                                                        </th>
                                                                    </tr>
                                                                    <?php if($sale_details->status != 2){ 
                                                                        $total_amount = $sale_details->balance_amount;
                                                                    ?>
                                                                    <tr>
                                                                        <th colspan="4">Balance Amount</th>
                                                                        <th>
                                                                            <?php echo number_format($total_amount,3,'.',','). ' g'; ?>
                                                                        </th>
                                                                        <th>
                                                                            <div class="pull-right">
                                                                                <div id="fixing_balance_in_rupees">Rs. 0.00</div>
                                                                            </div>
                                                                        </th>
                                                                    </tr>
                                                                    <?php }} ?>
                                                                    <?php 
                                                                    if($sale_details->status == 2){ 
                                                                        $paid_amount = $total_amount - ($sale_details->balance_amount + $sale_details->discount_amount);
                                                                        $total_amount = $sale_details->balance_amount;
                                                                    ?>
                                                                        <tr>
                                                                            <th colspan="4">Total Paid</th>
                                                                            <th>
                                                                                <?php echo number_format($paid_amount,3,'.',','). ' g'; ?>
                                                                                <input type="hidden" id="fixing_total_paid_in_grams" value="<?php echo $paid_amount; ?>">
                                                                            </th>
                                                                            <th>
                                                                                <div class="pull-right">
                                                                                    <div id="div_fixing_total_paid">Rs. 0.00</div>
                                                                                </div>
                                                                            </th>
                                                                        </tr> 
                                                                        <tr>
                                                                            <th colspan="4">Balance Amount</th>
                                                                            <th>
                                                                                <?php echo number_format($total_amount,3,'.',','). ' g'; ?>
                                                                                <input type="hidden" id="fixing_balance_in_grams" value="<?php echo $total_amount; ?>">
                                                                            </th>
                                                                            <th>
                                                                                <div class="pull-right">
                                                                                    <div id="fixing_balance_in_rupees">Rs. 0.00</div>
                                                                                </div>
                                                                            </th>
                                                                        </tr> 
                                                                    <?php }else{
                                                                        $paid_amount = $total_amount - ($sale_details->balance_amount + $sale_details->discount_amount);
                                                                        $total_amount = $sale_details->balance_amount;
                                                                    } ?>
                                                                    
                                                                    <input type="hidden" id="fixing_balance_in_grams" value="<?php echo $total_amount; ?>">
                                                                </tbody>
                                                            </table>
                                                        <?php } ?>
                                                        
                                                        
                                                        

                                                        <div class="invoice">
                                                            <div class="row">
                                                                <div class="col-xs-4"> </div>
                                                                <div class="col-xs-8 invoice-block" align="right">
                                                                    <ul class="list-unstyled amounts" style="font-size: 20px">
                                                                        <li>
                                                                            <?php if($sale_details->sale_type == 'Credit Sale'){
                                                                                $total_amount_display = 'Rs. '.number_format($total_amount,2,'.',',');
                                                                            }else if($sale_details->sale_type == 'Gold Sale'){
                                                                                $total_amount_display = number_format($total_amount,3,'.',','). ' g';
                                                                            } ?>
                                                                            <strong>Amount to be Paid : </strong><div id="amount_to_be_paid"><?php echo $total_amount_display; ?> - Rs. 0.00</div>
                                                                            <input type="hidden" name="payment_total_in_grams" value="<?php echo $total_amount ?>" id="payment_total_in_grams" />
                                                                            <input type="hidden" name="payment_total_in_rupees" value="0.00 "id="payment_total_in_rupees" />
                                                                        </li>
                                                                        <li>
                                                                            <strong>Payment Amount : </strong><input type="number" name="fixing_payment_amount" class="form-control input-small" value="" id="fixing_payment_amount" />
                                                                        </li>
                                                                        <li>
                                                                            <strong>Balance Amount : </strong><div id="fixing_div_balance_total" style="color: #2d823a"><?php echo $total_amount_display; ?> - Rs. 0.00</div>
                                                                            <input type="hidden" name="fixing_balance_total_in_grams" value="<?php echo $sale_details->balance_amount ?>" id="fixing_balance_total_in_grams" />
                                                                            <input type="hidden" name="fixing_balance_total_in_rupees" value="0.00" id="fixing_balance_total_in_rupees" />
                                                                        </li>
                                                                    </ul>
                                                                    <br/>

                                                                    <button type="submit" class="btn btn-lg green hidden-print margin-bottom-5" id="div_fixing_submit_button">
                                                                    Submit Payment <i class="fa fa-check"></i>
                                                                    </button>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--tab_1_4-->
                            <div class="tab-pane" id="tab_1_4">
                                <div class="row profile-account">
                                    <div class="table-scrollable">   
                                        <div class="col-md-12">
                                            <div class="portlet box grey-cascade">
                                                <div class="portlet-title">
                                                    <div class="caption">
                                                        <i class="fa fa-money"></i>Return Sale
                                                    </div>
                                                </div>
                                                <div class="portlet-body form">
                                                    <div id="return_sale_error_msg" class="alert alert-danger hidden"> </div>
                                                    <!-- BEGIN FORM-->
                                                    <form id="return_sale" class="form-horizontal" method="POST" enctype="multipart/form-data">
                                                        <input type="hidden" name="sale_id" value="<?php echo $sale_details->id ?>"/>
                                                        <input type="hidden" name="customer_id" value="<?php echo $sale_details->customer_id ?>"/>
                                                        <input type="hidden" name="sale_type" value="<?php echo $sale_details->sale_type ?>"/>
                                                        <div class="form-body">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Sale Date</label>
                                                                <div class="col-md-3">
                                                                    <div class="control-label pull-left"><?php echo $sale_details->date; ?></div>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Sale Invoice Number</label>
                                                                <div class="col-md-3">
                                                                    <div class="control-label pull-left"><?php echo $sale_details->invoice_num; ?></div>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Return Invoice Number</label>
                                                                <div class="col-md-3">
                                                                    <input type="text" class="form-control input-medium" name="invoice_number"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Return Sale Date</label>
                                                                <div class="col-md-3">
                                                                    <input class="form-control form-control-inline date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="return_date" value="<?php echo date('d-m-Y') ?>"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Sale Type</label>
                                                                <div class="col-md-3">
                                                                    <div class="control-label pull-left"><?php echo $sale_details->sale_type; ?></div>
                                                                </div>
                                                            </div>
                                                            <?php if($sale_details->sale_type == 'Credit Sale') { ?>
                                                                <div class="form-group">
                                                                    <label class="control-label col-md-3">Sold 24K Rate</label>
                                                                    <div class="col-md-3">
                                                                        <div class="control-label pull-left"><?php echo 'Rs. '.number_format($sale_details->k_rate,2,'.',','); ?></div>
                                                                        <input class="form-control" type="hidden" id="24k_rate_ret_sale" name="k_rate_ret_sale" value="<?php echo $sale_details->k_rate; ?>"/>
                                                                    </div>
                                                                </div>
                                                            <?php } ?>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Return Note</label>
                                                                <div class="col-md-3">
                                                                    <textarea name="description" id="description" class="form-control input-large"></textarea>
                                                                </div>
                                                            </div>
                                                            <h4>Sale Items</h4>
                                                            <hr>
                                                            <?php if($sale_details->sale_type == 'Credit Sale'){ ?>
                                                                <table class="table table-striped table-bordered table-hover" id="">
                                                                    <thead>
                                                                        <tr>
                                                                            <th style=""><strong>Item Name</strong></th>
                                                                            <th style=""><strong>Description</strong></th>
                                                                            <th style=""><strong>Selling Percentage</strong></th>
                                                                            <th style=""><strong>Selling Rate</strong></th>
                                                                            <th style=""><strong>Sales in Grams (g) - 22K</strong></th>
                                                                            <th style=""><strong>Amount</strong></th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <?php 
                                                                        $total_amount = 0;

                                                                        foreach($sale_items as $sale_item) { ?>                                                        
                                                                        <tr>
                                                                            <input type="hidden" name="item_id_ret_sale[]" value="<?php echo $sale_item['id']; ?>">
                                                                            <td>
                                                                                <?php echo $sale_item['item_name']; ?>
                                                                                <input type="hidden" name="item_name_ret_sale[]" value="<?php echo $sale_item['item_name']; ?>">
                                                                            </td>
                                                                            <td>
                                                                                <?php echo $sale_item['description']; ?>
                                                                                <input type="hidden" name="item_description_ret_sale[]" value="<?php echo $sale_item['description']; ?>">
                                                                            </td>
                                                                            <td>
                                                                                <div class="input-group input-small">
                                                                                    <input type="number" maxlength="10" class="form-control selling_percentage_ret_sale_credit input-small" id="selling_percentage_ret_sale_credit_<?php echo $sale_item['id']; ?>" name="selling_percentage_ret_sale[]" item-id="<?php echo $sale_item['id']; ?>"/>
                                                                                    <span class="input-group-addon">
                                                                                        <?php echo $sale_item['selling_percentage'].' %'; ?>
                                                                                    </span>
                                                                                </div>
                                                                            </td>
                                                                            <td>
                                                                                <div class="input-group input-small">
                                                                                    <input type="number" maxlength="10" class="form-control selling_rate_ret_sale_credit input-small" id="selling_rate_ret_sale_credit_<?php echo $sale_item['id']; ?>" name="selling_rate_ret_sale[]" item-id="<?php echo $sale_item['id']; ?>"/>
                                                                                    <span class="input-group-addon">
                                                                                        <?php echo number_format($sale_item['selling_rate'],2,'.',','); ?>
                                                                                    </span>
                                                                                </div>
                                                                            </td>
                                                                            <td>
                                                                                <div class="input-group input-small">
                                                                                    <input type="number" maxlength="10" class="form-control sales_grams_ret_sale_credit input-small" id="sales_grams_ret_sale_credit_<?php echo $sale_item['id']; ?>" name="sales_grams_ret_sale[]" item-id="<?php echo $sale_item['id']; ?>"/>
                                                                                    <span class="input-group-addon">
                                                                                        <?php echo number_format($sale_item['actual_grams'],3,'.',',').' g'; ?>
                                                                                    </span>
                                                                                </div>
                                                                                <input type="hidden" maxlength="10" class="form-control" id="prev_sales_grams_ret_sale_credit_<?php echo $sale_item['id']; ?>" name="actual_grams_ret_sale[]" value="<?php echo $sale_item['actual_grams']; ?>"/>
                                                                            </td>
                                                                            <td id="ret_sale_item_amount_credit_<?php echo $sale_item['id']; ?>">
                                                                                <?php echo 'Rs. '.number_format($sale_item['amount'],2,'.',','); ?>
                                                                            </td>
                                                                            <input type="hidden" maxlength="10" class="form-control" id="txt_ret_sale_item_amount_credit_<?php echo $sale_item['id']; ?>" name="txt_ret_sale_item_amount[]" value=""/>
                                                                        </tr> 
                                                                        <?php }?> 
                                                                    </tbody>
                                                                </table>                                            
                                                            <?php }else if($sale_details->sale_type == 'Gold Sale'){ ?>
                                                                <table class="table table-striped table-bordered table-hover" id="">
                                                                    <thead>
                                                                        <tr>
                                                                            <th style=""><strong>Item Name</strong></th>
                                                                            <th style=""><strong>Description</strong></th>
                                                                            <th style=""><strong>Selling Percentage</strong></th>
                                                                            <th style=""><strong>Sales in Grams (g) - 22K</strong></th>
                                                                            <th style=""><strong>Amount</strong></th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <?php foreach ($sale_items as $sale_item) { ?>                                                        
                                                                        <tr>
                                                                            <input type="hidden" name="item_id_ret_sale[]" value="<?php echo $sale_item['id']; ?>">
                                                                            <td>
                                                                                <?php echo $sale_item['item_name']; ?>
                                                                                <input type="hidden" name="item_name_ret_sale[]" value="<?php echo $sale_item['item_name']; ?>">
                                                                            </td>
                                                                            <td>
                                                                                <?php echo $sale_item['description']; ?>
                                                                                <input type="hidden" name="item_description_ret_sale[]" value="<?php echo $sale_item['description']; ?>">
                                                                            </td>
                                                                            <td>
                                                                                <div class="input-group input-medium">
                                                                                    <input type="number" maxlength="10" class="form-control selling_percentage_ret_sale_gold" id="selling_percentage_ret_sale_gold_<?php echo $sale_item['id']; ?>" name="selling_percentage_ret_sale[]" item-id="<?php echo $sale_item['id']; ?>"/>
                                                                                    <span class="input-group-addon">
                                                                                        <?php echo $sale_item['selling_percentage'].' %'; ?>
                                                                                    </span>
                                                                                </div>
                                                                            </td>
                                                                            <td>
                                                                                <div class="input-group input-medium">
                                                                                    <input type="number" maxlength="10" class="form-control sales_grams_ret_sale_gold" id="sales_grams_ret_sale_gold_<?php echo $sale_item['id']; ?>" name="sales_grams_ret_sale[]" item-id="<?php echo $sale_item['id']; ?>"/>
                                                                                    <span class="input-group-addon">
                                                                                        <?php echo number_format($sale_item['actual_grams'],3,'.',',').' g'; ?>
                                                                                    </span>
                                                                                </div>
                                                                                <input type="hidden" maxlength="10" class="form-control" id="prev_sales_grams_ret_sale_gold_<?php echo $sale_item['id']; ?>" name="actual_grams_ret_sale[]" value="<?php echo $sale_item['actual_grams']; ?>"/>
                                                                            </td>
                                                                            <td id="ret_sale_item_amount_gold_<?php echo $sale_item['id']; ?>">
                                                                                <?php echo number_format($sale_item['amount'],3,'.',','). ' g'; ?>
                                                                            </td>
                                                                            <input type="hidden" maxlength="10" class="form-control" id="txt_ret_sale_item_amount_gold_<?php echo $sale_item['id']; ?>" name="txt_ret_sale_item_amount[]" value=""/>
                                                                        </tr>
                                                                        <?php }?> 
                                                                    </tbody>
                                                                </table>
                                                            <?php } ?>

                                                            <div class="form-actions fluid" id="btn_submit_ret_sale">
                                                                <div class="row">
                                                                    <div class="col-md-12">
                                                                        <div class="col-md-offset-3 col-md-9">
                                                                            <button type="submit" class="btn green">
                                                                                Submit <i class="fa fa-check"></i>
                                                                            </button>
                                                                            <button type="button" class="btn default">Cancel</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>


                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--tab_1_5-->
                            <div class="tab-pane" id="tab_1_5">
                                <div class="row">
                                    <div class="col-md-12">
                                        <script type="text/javascript" language="javascript" >
                                            $(document).ready(function () {
                                                var dataTable = $('#returned_sales').DataTable({
                                                    select: true,
                                                    pageLength: 10,
                                                    processing: true,
                                                    serverSide: true,
                                                    ajax: {
                                                        url: "Json_data/json_data_records?json_type=returned_sales&sale_id=<?php echo $sale_details->id; ?>", // json datasource
                                                        type: "post", // method  , by default get
                                                        error: function () {  // error handling
                                                            $(".employee-grid-error").html("");
                                                            $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                            $("#employee-grid_processing").css("display", "none");

                                                        }
                                                    }, "aoColumns": [
                                                        {"sTitle": "", "sClass": "hidden"},
                                                        {"sTitle": "Invoice No."},
                                                        {"sTitle": "Date"},
                                                        {"sTitle": "Total Amount"},
                                                        {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                                    ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                        $(nRow).attr('id', '' + aData[0]);
                                                        if ( aData[6] >= '7' )
                                                        {
                                                            $('td', nRow).css('background-color', '#FA5858');
                                                        }

                                                    }
                                                });

                                            });
                                        </script>
                                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                        <div class="portlet box grey-cascade">
                                            <div class="portlet-title">
                                                <div class="caption">
                                                    <i class="fa fa-money"></i>Returned Sales
                                                </div>
                                            </div>
                                            <div class="portlet-body">
                                                <table id="returned_sales" class="table table-striped table-bordered table-hover"></table>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                            <!--end tab-pane-->
                        </div>
                    </div>
                    <!--END TABS-->
                </div> 
            </div>
            <!-- END DASHBOARD STATS -->
        </div>
    </div>
    <!-- END CONTENT -->
</div>
<!-- END CONTAINER -->
