
            <div class="row profile">
                <div class="col-md-12">
                    
                    <div id="response_msg"></div>
                    
                    <!--BEGIN TABS-->
                    <div class="tabbable tabbable-custom tabbable-full-width">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab_1_1" data-toggle="tab"> Debtor Overview </a>
                            </li>
                            <?php if($credit_sale_details || $gold_sale_details){ ?>
                            <li>
                                <a href="#tab_1_2" data-toggle="tab"> Receipt </a>
                            </li>
                            <?php } ?>
                            <?php if($gold_sale_details){ ?>
                            <li>
                                <a href="#tab_1_3" data-toggle="tab"> Fixing Receipt </a>
                            </li>
                            <?php } ?>
                        </ul>

                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_1_1">
                                <div class="row">
                                    <div class="col-md-12">
                                        <h4>Sale Details</h4>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-offset-1 col-md-10">
                                                <table class="table table-hover table-bordered table-striped" align="center">
                                                    <tr>
                                                        <td>
                                                            <strong>Customer Name</strong>
                                                        </td>
                                                        <td>
                                                            <a href="<?php echo base_url().'view_customer?customer_id='.$customer_details->id; ?>"><?php echo $customer_details->customer_name; ?></a>
                                                        </td>
                                                        <td>
                                                            <strong>Telephone Number</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $customer_details->tel_number; ?>
                                                        </td>
                                                        <td>
                                                            <strong>Mobile Number</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $customer_details->contact_number; ?>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <!--end col-md-8-->
                                        </div>
                                        <!--end row-->
                                        
                                        <h4>Account Details</h4>
                                        <hr>
                                        
                                        <div class="row">
                                            <div class="col-md-offset-2 col-md-8">
                                                <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                    <tr>
                                                        <td>
                                                            <strong>Total Credit Balance</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount_credit = $customer_details->debt_amount_cash;
                                                            if($balance_amount_credit > 0){
                                                                $col_colour_credit = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour_credit = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour_credit; ?>">
                                                            <strong><?php echo 'Rs. '.number_format($balance_amount_credit,2,'.',','); ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total Gold Balance</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount_gold = $customer_details->debt_amount_gold;
                                                            if($balance_amount_gold > 0){
                                                                $col_colour_gold = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour_gold = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour_gold; ?>">
                                                            <strong><?php echo number_format($balance_amount_gold,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total Over Paid Credit Balance</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo 'Rs. '.number_format($customer_details->over_paid_cash,2,'.',','); ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total Over Paid Gold Balance</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($customer_details->over_paid_gold,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                    </tr>
                                                </table>
                                                <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                    <tr>
                                                        <td>
                                                            <strong>Total BOX Credit Balance</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount_box_credit = $customer_details->box_debt_amount_cash;
                                                            if($balance_amount_box_credit > 0){
                                                                $col_colour_box_credit = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour_box_credit = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour_box_credit; ?>">
                                                            <strong><?php echo 'Rs. '.number_format($balance_amount_box_credit,2,'.',','); ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total BOX Gold Balance</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount_box_gold = $customer_details->box_debt_amount_gold;
                                                            if($balance_amount_box_gold > 0){
                                                                $col_colour_box_gold = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour_box_gold = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour_box_gold; ?>">
                                                            <strong><?php echo number_format($balance_amount_box_gold,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total Over Paid DXB Credit Balance</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo 'Rs. '.number_format($customer_details->box_over_paid_cash,2,'.',','); ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total Over Paid DXB Gold Balance</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($customer_details->box_over_paid_gold,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        
                                        <?php if($credit_sale_details || $gold_sale_details){ ?>
                                            <h4>Outstanding Sale Details</h4>
                                            <hr> 
                                        <?php } ?>
                                        <div class="row">
                                            <?php if($credit_sale_details){ ?>
                                            <div class="col-md-6">
                                                <div class="portlet box blue">
                                                    <div class="portlet-title">
                                                        <div class="caption">
                                                            <i class="fa fa-money"></i>Credit Sales
                                                        </div>
                                                    </div>
                                                    <div class="portlet-body">
                                                        <div class="table-scrollable">
                                                            <table class="table table-striped table-bordered table-hover">
                                                                <thead>
                                                                    <tr>
                                                                        <th style="width: 12%;"><strong>#</strong></th>
                                                                        <th><strong>Sales Date</strong></th>
                                                                        <th><strong>Total Amount</strong></th>
                                                                        <th><strong>Balance Amount</strong></th>
                                                                        <th><strong>Action</strong></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $total_amount_credit = 0;
                                                                    $balance_amount_credit = 0;

                                                                    foreach($credit_sale_details as $credit_sale_detail) { ?>                                                        
                                                                    <tr>
                                                                        <td><?php echo $credit_sale_detail['id']; ?></td>
                                                                        <td><?php echo date("d-m-Y", strtotime($credit_sale_detail['date'])); ?></td>
                                                                        <td><?php $total_amount_credit += $credit_sale_detail['total_amount']; echo 'Rs. '.number_format($credit_sale_detail['total_amount'],2,'.',','); ?></td>
                                                                        <td><?php $balance_amount_credit += $credit_sale_detail['balance_amount']; echo 'Rs. '.number_format($credit_sale_detail['balance_amount'],2,'.',','); ?></td>
                                                                        <td><a data-toggle="tooltip" title="View Box Sale" class="btn default btn-xs blue-stripe" href="<?php echo base_url().'view_box_sale?box_sale_id='.$credit_sale_detail['id'];?>" target="_blank"> View </a></td>
                                                                    </tr> 
                                                                    <?php }?> 
                                                                    <tr>
                                                                        <th colspan="2">Total</th>
                                                                        <th><?php echo 'Rs. '.number_format($total_amount_credit,2,'.',','); ?></th>
                                                                        <th><?php echo 'Rs. '.number_format($balance_amount_credit,2,'.',','); ?></th>
                                                                        <th></th>
                                                                    </tr>  
                                                                </tbody>
                                                            </table> 
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php } ?> 
                                            <?php if($gold_sale_details){ ?>   
                                            <div class="col-md-6">
                                                <div class="portlet box blue">
                                                    <div class="portlet-title">
                                                        <div class="caption">
                                                            <i class="fa fa-money"></i>Gold Sales
                                                        </div>
                                                    </div>
                                                    <div class="portlet-body">
                                                        <div class="table-scrollable">
                                                            <table class="table table-striped table-bordered table-hover" id="">
                                                                <thead>
                                                                    <tr>
                                                                        <th style="width: 12%;"><strong>#</strong></th>
                                                                        <th><strong>Sales Date</strong></th>
                                                                        <th><strong>Total Gold</strong></th>
                                                                        <th><strong>Balance Gold</strong></th>
                                                                        <th><strong>Action</strong></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $total_amount_gold = 0;
                                                                    $balance_amount_gold = 0;

                                                                    foreach ($gold_sale_details as $gold_sale_detail) { ?>                                                        
                                                                    <tr>
                                                                        <td><?php echo $gold_sale_detail['id']; ?></td>
                                                                        <td><?php echo date("d-m-Y", strtotime($gold_sale_detail['date'])); ?></td>
                                                                        <td><?php $total_amount_gold += $gold_sale_detail['total_amount']; echo $gold_sale_detail['total_amount']. ' g'; ?></td>
                                                                        <td><?php $balance_amount_gold += $gold_sale_detail['balance_amount']; echo $gold_sale_detail['balance_amount']. ' g'; ?></td>
                                                                        <td><a data-toggle="tooltip" title="View Box Sale" class="btn default btn-xs blue-stripe" href="<?php echo base_url().'view_box_sale?box_sale_id='.$gold_sale_detail['id'];?>" target="_blank"> View </a></td>
                                                                    </tr>
                                                                    <?php }?> 
                                                                    <tr>
                                                                        <th colspan="2">Total</th>
                                                                        <th><?php echo $total_amount_gold. ' g'; ?></th>
                                                                        <th><?php echo $balance_amount_gold. ' g'; ?></th>
                                                                        <th></th>
                                                                    </tr>
                                                                </tbody>
                                                            </table> 
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php } ?> 
                                        </div>  
                                    </div>
                                </div>
                                <?php if($pending_cheques){ ?>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="portlet box blue">
                                            <div class="portlet-title">
                                                <div class="caption">
                                                    <i class="fa fa-money"></i>Pending Cheques
                                                </div>
                                            </div>
                                            <div class="portlet-body">
                                                <div class="table-scrollable">
                                                    <table class="table table-striped table-bordered table-hover" id="">
                                                        <thead>
                                                            <tr>
                                                                <th style="width: 12%;"><strong>#</strong></th>
                                                                <th><strong>Bank Name</strong></th>
                                                                <th><strong>Cheque Number</strong></th>
                                                                <th><strong>Deposit Date</strong></th>
                                                                <th><strong>Deposit Amount</strong></th>
                                                                <th><strong>Action</strong></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php 
                                                            $total_pending_cheque = 0;

                                                            foreach ($pending_cheques as $pending_cheque) { ?>                                                        
                                                            <tr>
                                                                <td><?php echo $pending_cheque['id']; ?></td>
                                                                <td><?php echo $pending_cheque['bank_name']; ?></td>
                                                                <td><?php echo $pending_cheque['cheque_number']; ?></td>
                                                                <td><?php echo date("d-m-Y", strtotime($pending_cheque['deposit_date'])); ?></td>
                                                                <td><?php $total_pending_cheque += $pending_cheque['cheque_amount']; echo 'Rs. '.number_format($pending_cheque['cheque_amount'],2,'.',','); ?></td>
                                                                <td><a data-toggle="tooltip" title="View Cheque" class="btn default btn-xs blue-stripe" href="<?php echo base_url().'view_cheque?cheque_id='.$pending_cheque['id'];?>" target="_blank"> View </a></td>
                                                            </tr>
                                                            <?php }?> 
                                                            <tr>
                                                                <th colspan="4">Total</th>
                                                                <th><?php echo 'Rs. '.number_format($pending_cheque['cheque_amount'],2,'.',','); ?></th>
                                                                <th></th>
                                                            </tr>
                                                        </tbody>
                                                    </table> 
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                            <!--tab_1_2-->
                            <div class="tab-pane" id="tab_1_2">
                                <div class="row profile-account">
                                    <div class="col-md-12">
                                        <div class="portlet box grey-cascade">
                                            <div class="portlet-title">
                                                <div class="caption">
                                                    <i class="fa fa-money"></i>Make Box Sale Payment
                                                </div>
                                            </div>
                                            <div class="portlet-body form">
                                                <div class="alert alert-info hidden" id="alert_info"></div>
                                                <div class="alert alert-danger hidden" id="alert_error"></div>
                                                <!-- BEGIN FORM-->
                                                <form id="make_normal_debtor_box_payment" class="form-horizontal" method="POST" enctype="multipart/form-data">
                                                    <input type="hidden" name="customer_id" value="<?php echo $customer_details->id ?>"/>
                                                    <input type="hidden" name="debtor_type" value="<?php echo $debtor_type ?>"/>
                                                    <div class="form-body">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">Date</label>
                                                            <div class="col-md-3">
                                                                <input class="form-control form-control-inline input-medium date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="invoice_date" value="<?php echo date('d-m-Y') ?>"/>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">Payment Method</label>
                                                            <div class="col-md-3">
                                                                <select class="form-control" name="payment_method" id="payment_method">
                                                                    <option value="">Select a Payment Method</option>
                                                                    <?php if($gold_sale_details){ ?>
                                                                        <option value="Gold">Gold</option>
                                                                        <option value="Over Paid Gold">Over Paid Gold</option>
                                                                    <?php } ?>
                                                                    <?php if($credit_sale_details){ ?>
                                                                        <option value="Cash">Cash</option>
                                                                        <option value="Over Paid Cash">Over Paid Cash</option>
                                                                        <option value="Cheque">Cheque</option>
                                                                        <option value="Bank Deposit">Bank Deposit</option>
                                                                    <?php } ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div id="div_over_paid_gold_details" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Over Paid Gold</label>
                                                                <div class="col-md-3">
                                                                    <div class="control-label pull-left"><?php echo number_format($customer_details->over_paid_gold,3,'.',',').' g'; ?></div>
                                                                    <input type="hidden" id="over_paid_gold" value="<?php echo $customer_details->over_paid_gold; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="div_over_paid_cash_details" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Over Paid Cash</label>
                                                                <div class="col-md-3">
                                                                    <div class="control-label pull-left"><?php echo 'Rs. '.number_format($customer_details->over_paid_cash,2,'.',','); ?></div>
                                                                    <input type="hidden" id="over_paid_cash" value="<?php echo $customer_details->over_paid_cash; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group hidden" id="div_payment_amount_gold">
                                                            <label class="control-label col-md-3">Payment Amount (g)</label>
                                                            <div class="col-md-3">
                                                                <div class="input-group input-small">
                                                                    <input type="number" class="form-control input-small" name="payment_amount_gold" id="payment_amount_gold"/>
                                                                    <span class="input-group-addon">
                                                                        g
                                                                    </span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group hidden" id="div_payment_amount_credit">
                                                            <label class="control-label col-md-3">Payment Amount Rs.</label>
                                                            <div class="col-md-3">
                                                                <div class="input-group input-small">
                                                                    <span class="input-group-addon">
                                                                        Rs.
                                                                    </span>
                                                                    <input type="number" class="form-control input-small" name="payment_amount_credit" id="payment_amount_credit"/>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="div_cheque_details" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Bank Name</label>
                                                                <div class="col-md-3">
                                                                    <select class="form-control input-medium select2me" name="cheq_bank" id="cheq_bank">
                                                                    <?php
                                                                        $banks = $this->admin_db->get_banks_for_receipts();
                                                                        foreach ($banks as $bank) {
                                                                            $sel = '';
                                                                    ?>

                                                                    <option value="<?php echo $bank['id']; ?>" <?php echo $sel; ?>><?php echo $bank['bank_name']; ?></option>

                                                                    <?php } ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Cheque Number</label>
                                                                <div class="col-md-3">
                                                                    <input class="form-control" type="number" name="cheq_cheque_number" id="cheq_cheque_number"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Deposit Date</label>
                                                                <div class="col-md-3">
                                                                    <input class="form-control form-control-inline input-medium date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="cheq_deposit_date" value="<?php echo date('d-m-Y') ?>"/>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="div_deposit_details" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Bank Account</label>
                                                                <div class="col-md-3">
                                                                    <select class="form-control input-medium select2me" name="deposit_bank_account" id="deposit_bank_account">
                                                                    <?php
                                                                        $accounts = $this->admin_db->get_box_bank_accounts_for_receipts();
                                                                        foreach ($accounts as $account) {
                                                                            $sel = '';
                                                                    ?>

                                                                    <option value="<?php echo $account['id']; ?>" <?php echo $sel; ?>><?php echo $account['account_name'].' - '.$account['account_number'].' - '.$account['bank_name']; ?></option>

                                                                    <?php } ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <?php if($credit_sale_details){ ?>
                                                        <div id="div_credit_sale_details" class="hidden">
                                                            <h4>Credit Sale Details</h4>
                                                            <hr>
                                                            <table class="table table-striped table-bordered table-hover">
                                                                <thead>
                                                                    <tr>
                                                                        <th><strong>#</strong></th>
                                                                        <th><strong>Sales Date</strong></th>
                                                                        <th><strong>24K Rate</strong></th>
                                                                        <th><strong>Payment Status</strong></th>
                                                                        <th><strong>Total Amount</strong></th>
                                                                        <th><strong>Amount to be Paid</strong></th>
                                                                        <th><strong>Payment Amount</strong></th>
                                                                        <th><strong>Balance Amount</strong></th>
                                                                        <th><strong>Action</strong></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $total_amount = 0;
                                                                    $balance_amount = 0;
                                                                    $x = 0;
                                                                    foreach($credit_sale_details as $credit_sale_detail) { ?>                                                        
                                                                    <tr>
                                                                        <td><?php echo $credit_sale_detail['id']; ?></td>
                                                                        <td><?php echo date("d-m-Y", strtotime($credit_sale_detail['date'])); ?></td>
                                                                        <td><?php echo 'Rs. '.number_format($credit_sale_detail['24k_rate'],2,'.',','); ?></td>
                                                                        <td><?php 
                                                                            if($credit_sale_detail['status'] == 2){
                                                                                echo '<span class="label label-warning">Payment Incomplete</span>';
                                                                            }else if($credit_sale_detail['status'] == 3){
                                                                                echo '<span class="label label-danger">Payment Pending</span>';
                                                                            }
                                                                            ?>
                                                                        </td>
                                                                        <td><?php $total_amount += $credit_sale_detail['total_amount']; echo 'Rs. '.number_format($credit_sale_detail['total_amount'],2,'.',','); ?></td>
                                                                        <td><?php $balance_amount += $credit_sale_detail['balance_amount']; echo 'Rs. '.number_format($credit_sale_detail['balance_amount'],2,'.',','); ?></td>
                                                                        <td>
                                                                            <div class="input-group input-small">
                                                                                <span class="input-group-addon">
                                                                                    Rs.
                                                                                </span>
                                                                                <input type="number" class="form-control input-small debtor_payment_amount" id="debtor_payment_amount<?php echo $credit_sale_detail['id']; ?>" item-id="<?php echo $credit_sale_detail['id']; ?>" bal-amount="<?php echo $credit_sale_detail['balance_amount']; ?>" name="debtor_payment_amount[<?php echo $x; ?>]">
                                                                            </div>
                                                                        </td>
                                                                        <td id="div_debtor_bal_amount<?php echo $credit_sale_detail['id']; ?>" style="color: #2d823a"><?php echo 'Rs. '.number_format($credit_sale_detail['balance_amount'],2,'.',','); ?></td>
                                                                        <td class="hidden">
                                                                            <input type="number" class="form-control input-small debtor_balance_amount" id="debtor_balance_amount<?php echo $credit_sale_detail['id']; ?>" name="debtor_balance_amount[<?php echo $x; ?>]" value="<?php echo $credit_sale_detail['balance_amount']; ?>">
                                                                            <input type="number" class="form-control input-small" value="<?php echo $credit_sale_detail['id']; ?>" name="sale_ids[<?php echo $x; ?>]">
                                                                        </td>
                                                                        <td><a data-toggle="tooltip" title="View Sale" class="btn default btn-xs blue-stripe" href="<?php echo base_url().'view_sale?sale_id='.$credit_sale_detail['id'];?>" target="_blank"> View</a></td>
                                                                    </tr> 
                                                                    <?php $x++; }?> 
                                                                    <tr>
                                                                        <th colspan="4">Total</th>
                                                                        <th><?php echo 'Rs. '.number_format($total_amount,2,'.',','); ?></th>
                                                                        <th>
                                                                            <input type="hidden" class="form-control input-small" id="tot_amount_to_be_paid" value="<?php echo $balance_amount; ?>" name="tot_amount_to_be_paid">
                                                                            <?php echo 'Rs. '.number_format($balance_amount,2,'.',','); ?>
                                                                        </th>
                                                                        <th id="debtor_total_paid">Rs. 0.00</th>
                                                                        <input type="hidden" class="form-control input-small" id="tot_payment_amount" value="0.00" name="tot_payment_amount">
                                                                        <th id="debtor_total_balance_amount">Rs. 0.00</th>
                                                                        <th></th>
                                                                    </tr>  
                                                                </tbody>
                                                            </table> 
                                                        </div>   
                                                        <?php } ?>
                                                        
                                                        <?php if($gold_sale_details){ ?>
                                                        <div id="div_gold_sale_details" class="hidden">
                                                            <h4>Gold Sale Details</h4>
                                                            <hr>
                                                            <table class="table table-striped table-bordered table-hover" id="">
                                                                <thead>
                                                                    <tr>
                                                                        <th><strong>#</strong></th>
                                                                        <th><strong>Sales Date</strong></th>
                                                                        <th><strong>Payment Status</strong></th>
                                                                        <th><strong>Total Gold</strong></th>
                                                                        <th><strong>Gold to be Paid</strong></th>
                                                                        <th><strong>Payment Gold</strong></th>
                                                                        <th><strong>Balance Gold</strong></th>
                                                                        <th><strong>Action</strong></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php 
                                                                    $total_amount = 0;
                                                                    $balance_amount = 0;
                                                                    $x = 0;
                                                                    foreach($gold_sale_details as $gold_sale_detail) { ?>                                                        
                                                                    <tr>
                                                                        <td><?php echo $gold_sale_detail['id']; ?></td>
                                                                        <td><?php echo date("d-m-Y", strtotime($gold_sale_detail['date'])); ?></td>
                                                                        <td><?php 
                                                                            if($gold_sale_detail['status'] == 2){
                                                                                echo '<span class="label label-warning">Payment Incomplete</span>';
                                                                            }else if($gold_sale_detail['status'] == 3){
                                                                                echo '<span class="label label-danger">Payment Pending</span>';
                                                                            }
                                                                            ?>
                                                                        </td>
                                                                        <td><?php $total_amount += $gold_sale_detail['total_amount']; echo $gold_sale_detail['total_amount'].' g'; ?></td>
                                                                        <td><?php $balance_amount += $gold_sale_detail['balance_amount']; echo $gold_sale_detail['balance_amount'].' g'; ?></td>
                                                                        <td>
                                                                            <div class="input-group input-small">
                                                                                <input type="number" class="form-control input-small debtor_payment_amount_gold" id="debtor_payment_amount_gold<?php echo $gold_sale_detail['id']; ?>" item-id="<?php echo $gold_sale_detail['id']; ?>" bal-amount="<?php echo $gold_sale_detail['balance_amount']; ?>" name="debtor_payment_amount_gold[<?php echo $x; ?>]">
                                                                                <span class="input-group-addon">
                                                                                    g
                                                                                </span>
                                                                            </div>
                                                                        </td>
                                                                        <td id="div_debtor_bal_amount_gold<?php echo $gold_sale_detail['id']; ?>" style="color: #2d823a"><?php echo $gold_sale_detail['balance_amount'].' g'; ?></td>
                                                                        <td class="hidden">
                                                                            <input type="number" class="form-control input-small debtor_balance_amount_gold" id="debtor_balance_amount_gold<?php echo $gold_sale_detail['id']; ?>" name="debtor_balance_amount_gold[<?php echo $x; ?>]" value="<?php echo $gold_sale_detail['balance_amount']; ?>">
                                                                            <input type="number" class="form-control input-small" value="<?php echo $gold_sale_detail['id']; ?>" name="sale_ids_gold[<?php echo $x; ?>]">
                                                                        </td>
                                                                        <td><a data-toggle="tooltip" title="View Sale" class="btn default btn-xs blue-stripe" href="<?php echo base_url().'view_sale?sale_id='.$gold_sale_detail['id'];?>" target="_blank"> View</a></td>
                                                                    </tr> 
                                                                    <?php $x++; }?> 
                                                                    <tr>
                                                                        <th colspan="3">Total</th>
                                                                        <th><?php echo $total_amount.' g'; ?></th>
                                                                        <th>
                                                                            <input type="hidden" class="form-control input-small" id="tot_amount_to_be_paid_gold" value="<?php echo $balance_amount; ?>" name="tot_amount_to_be_paid">
                                                                            <?php echo $balance_amount.' g'; ?>
                                                                        </th>
                                                                        <th id="debtor_total_paid_gold">0 g</th>
                                                                        <input type="hidden" class="form-control input-small" id="tot_payment_amount_gold" value="0" name="tot_payment_amount_gold">
                                                                        <th id="debtor_total_balance_amount_gold">0 g</th>
                                                                        <th></th>
                                                                    </tr>  
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                        <?php } ?>

                                                        <div class="invoice">
                                                            <div class="row">
                                                                <div class="col-xs-4"> </div>
                                                                <div class="col-xs-8 invoice-block" align="right">
                                                                    <button type="submit" class="btn btn-lg green hidden-print margin-bottom-5 hidden" id="div_submit_button">
                                                                    Submit Payment <i class="fa fa-check"></i>
                                                                    </button>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--tab_1_3-->
                            <div class="tab-pane" id="tab_1_3">
                                <div class="row profile-account">
                                    <div class="col-md-12">
                                        <div class="portlet box grey-cascade">
                                            <div class="portlet-title">
                                                <div class="caption">
                                                    <i class="fa fa-money"></i>Make Fixing Box Sale Payment
                                                </div>
                                            </div>
                                            <div class="portlet-body form">
                                                <!-- BEGIN FORM-->
                                                <form id="make_fixing_debtor_box_payment" class="form-horizontal" method="POST" enctype="multipart/form-data">
                                                    <input type="hidden" name="customer_id" value="<?php echo $customer_details->id ?>"/>
                                                    <input type="hidden" name="debtor_type" value="<?php echo $debtor_type ?>"/>
                                                    <div class="form-body">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">Date</label>
                                                            <div class="col-md-3">
                                                                <input class="form-control form-control-inline input-medium date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="invoice_date" value="<?php echo date('d-m-Y') ?>"/>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">24K Rate</label>
                                                            <div class="col-md-3">
                                                                <div class="input-group input-small">
                                                                    <span class="input-group-addon">
                                                                        Rs.
                                                                    </span>
                                                                    <input class="form-control input-small" type="number" id="24k_rate_debtor_fixing" name="k_rate_debtor_fixing"/>
                                                                </div>    
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">Payment Method</label>
                                                            <div class="col-md-3">
                                                                <select class="form-control" name="payment_method_debtor_fixing" id="payment_method_debtor_fixing">
                                                                    <option value="Cash">Cash</option>
                                                                    <option value="Cheque">Cheque</option>
                                                                    <option value="Bank Deposit">Bank Deposit</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div id="div_cheque_details_debtor_fixing" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Bank Name</label>
                                                                <div class="col-md-3">
                                                                    <select class="form-control input-medium select2me" name="cheq_bank" id="cheq_bank">
                                                                    <?php
                                                                        $banks = $this->admin_db->get_banks_for_receipts();
                                                                        foreach ($banks as $bank) {
                                                                            $sel = '';
                                                                    ?>

                                                                    <option value="<?php echo $bank['id']; ?>" <?php echo $sel; ?>><?php echo $bank['bank_name']; ?></option>

                                                                    <?php } ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Cheque Number</label>
                                                                <div class="col-md-3">
                                                                    <input class="form-control" type="number" name="cheq_cheque_number" id="cheq_cheque_number"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Deposit Date</label>
                                                                <div class="col-md-3">
                                                                    <input class="form-control form-control-inline input-medium date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="cheq_deposit_date" value="<?php echo date('d-m-Y') ?>"/>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="div_deposit_details_debtor_fixing" class="hidden">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Bank Account</label>
                                                                <div class="col-md-3">
                                                                    <select class="form-control input-medium select2me" name="deposit_bank_account" id="deposit_bank_account">
                                                                    <?php
                                                                        $accounts = $this->admin_db->get_box_bank_accounts_for_receipts();
                                                                        foreach ($accounts as $account) {
                                                                            $sel = '';
                                                                    ?>

                                                                    <option value="<?php echo $account['id']; ?>" <?php echo $sel; ?>><?php echo $account['account_name'].' - '.$account['account_number'].' - '.$account['bank_name']; ?></option>

                                                                    <?php } ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <h4>Gold Sale Details</h4>
                                                        <hr>
                                                        <table class="table table-striped table-bordered table-hover" id="">
                                                            <thead>
                                                                <tr>
                                                                    <th><strong>#</strong></th>
                                                                    <th><strong>Sales Date</strong></th>
                                                                    <th><strong>Payment Status</strong></th>
                                                                    <th><strong>Total Gold</strong></th>
                                                                    <th><strong>Gold to be Paid</strong></th>
                                                                    <th><strong>Cash to be Paid</strong></th>
                                                                    <th><strong>Payment in Cash</strong></th>
                                                                    <th><strong>Balance</strong></th>
                                                                    <th><strong>Action</strong></th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php 
                                                                $total_amount = 0;
                                                                $balance_amount = 0;
                                                                $total_gold_sale = 0;
                                                                $x = 0;
                                                                foreach($gold_sale_details as $gold_sale_detail) { ?>                                                        
                                                                <tr>
                                                                    <td><?php echo $gold_sale_detail['id']; ?></td>
                                                                    <td><?php echo date("d-m-Y", strtotime($gold_sale_detail['date'])); ?></td>
                                                                    <td><?php 
                                                                        if($gold_sale_detail['status'] == 2){
                                                                            echo '<span class="label label-warning">Payment Incomplete</span>';
                                                                        }else if($gold_sale_detail['status'] == 3){
                                                                            echo '<span class="label label-danger">Payment Pending</span>';
                                                                        }
                                                                        ?>
                                                                    </td>
                                                                    <td><?php $total_amount += $gold_sale_detail['total_amount']; echo $gold_sale_detail['total_amount'].' g'; ?></td>
                                                                    <td>
                                                                        <?php $balance_amount += $gold_sale_detail['balance_amount']; echo $gold_sale_detail['balance_amount'].' g'; ?>
                                                                            <input type="hidden" value="<?php echo $gold_sale_detail['balance_amount']; ?>" name="debtor_fixing_total_balance_amount_gold[<?php echo $x; ?>]">
                                                                    </td>
                                                                    <td>
                                                                        <div id="div_debtor_fixing_bal_amount_cash_<?php echo $x; ?>" class="pull-right div_debtor_fixing_bal_amount_cash">Rs. 0.00</div>
                                                                        <input type="hidden" id="debtor_fixing_item_total_<?php echo $x; ?>" class="debtor_fixing_item_total" value="0.00">
                                                                    </td>
                                                                    <td>
                                                                        <div class="input-group input-small">
                                                                            <span class="input-group-addon">
                                                                                Rs.
                                                                            </span>
                                                                            <input type="number" class="form-control input-small debtor_fixing_payment_amount_cash" id="debtor_fixing_payment_amount_cash_<?php echo $x; ?>" item-key="<?php echo $x; ?>" item-id="<?php echo $gold_sale_detail['id']; ?>" bal-amount="<?php echo $gold_sale_detail['balance_amount']; ?>" name="debtor_fixing_payment_amount[<?php echo $x; ?>]"></td>
                                                                        </div>
                                                                    <td id="div_debtor_fixing_bal_amount<?php echo $x; ?>" style="color: #2d823a">
                                                                        <?php $total_gold_sale +=  $gold_sale_detail['balance_amount']; echo $gold_sale_detail['balance_amount'].' g - Rs. 0.00'; ?>
                                                                    </td>
                                                                    <td class="hidden">
                                                                        <input type="number" class="form-control input-small debtor_fixing_balance_amount_gold" id="debtor_fixing_balance_amount_gold<?php echo $x; ?>" name="debtor_fixing_balance_amount_gold[<?php echo $x; ?>]">
                                                                        <input type="number" class="form-control input-small debtor_fixing_balance_amount_cash" id="debtor_fixing_balance_amount_cash<?php echo $x; ?>" name="debtor_fixing_balance_amount_cash[<?php echo $x; ?>]">
                                                                        <input type="number" class="form-control input-small" value="<?php echo $gold_sale_detail['id']; ?>" name="debtor_fixing_sale_ids[<?php echo $x; ?>]">
                                                                    </td>
                                                                    <td><a data-toggle="tooltip" title="View Sale" class="btn default btn-xs blue-stripe" href="<?php echo base_url().'view_sale?sale_id='.$gold_sale_detail['id'];?>" target="_blank"> View</a></td>
                                                                </tr> 
                                                                <?php $x++; }?> 
                                                                <input type="hidden" id="no_of_sales_debtor_fixing" value="<?php echo $x; ?>">
                                                                <tr>
                                                                    <th colspan="3">Total</th>
                                                                    <th><?php echo $total_amount.' g'; ?></th>
                                                                    <th>
                                                                        <input type="hidden" class="form-control input-small" id="tot_amount_debtor_fixing_to_be_paid_gold" value="<?php echo $balance_amount; ?>" name="tot_amount_debtor_fixing_to_be_paid_gold">
                                                                        <?php echo $balance_amount.' g'; ?>
                                                                    </th>
                                                                    <th>
                                                                        <div class="pull-right">
                                                                            <div id="div_debtor_fixing_total_amount">Rs. 0.00</div>
                                                                            <input type="hidden" id="debtor_fixing_total_amount" value="0.00">
                                                                        </div>
                                                                    </th>
                                                                    <th id="debtor_fixing_total_paid_cash">Rs. 0.00</th>
                                                                    <input type="hidden" class="form-control input-small" id="tot_debtor_fixing_payment_amount_gold" value="0" name="tot_debtor_fixing_payment_amount_gold">
                                                                    <input type="hidden" class="form-control input-small" id="tot_debtor_fixing_payment_amount_cash" value="0" name="tot_debtor_fixing_payment_amount_cash">
                                                                    <th id="debtor_fixing_total_balance_amount"><?php echo $total_gold_sale; ?> g - Rs.0.00</th>
                                                                    <th></th>
                                                                </tr>  
                                                            </tbody>
                                                        </table>                                                     
                                                        
                                                        <div class="invoice">
                                                            <div class="row">
                                                                <div class="col-xs-4"> </div>
                                                                <div class="col-xs-8 invoice-block" align="right">
                                                                    <button type="submit" class="btn btn-lg green hidden-print margin-bottom-5" id="div_fixing_submit_button">
                                                                    Submit Payment <i class="fa fa-check"></i>
                                                                    </button>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--end tab-pane-->
                        </div>
                    </div>
                    <!--END TABS-->
                </div> 
            </div>
            <!-- END DASHBOARD STATS -->
        </div>
    </div>
    <!-- END CONTENT -->
</div>
<!-- END CONTAINER -->
