            <div class="row profile">
                <div class="col-md-12">
                    <!--BEGIN TABS-->
                    <div class="tabbable tabbable-custom tabbable-full-width">
                        
                        <div id="add_previous_debts" class="modal fade" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                        <h4 class="modal-title">Add Previous Debts for <?php echo $customer_details->customer_name; ?></h4>
                                    </div>
                                    <form id="save_add_previous_debts" class="form-horizontal" method="post">
                                        <input type="hidden" id="customer_id" name="customer_id" value="<?php echo $customer_details->id; ?>">
                                        <div class="modal-body">
                                            <div id="response_msg_modal"></div>
                                            <div class="scroller" style="height:300px" data-always-visible="1" data-rail-visible1="1">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-body">
                                                            <div class="row form-group">
                                                                <label class="col-md-3 control-label pull-left">Date</label>
                                                                <div class="col-md-6">
                                                                    <input class="form-control form-control-inline input-medium date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="bill_date" value="<?php echo date('d-m-Y') ?>"/>
                                                                </div>
                                                            </div>
                                                            <div class="row form-group">
                                                                <label class="col-md-3 control-label pull-left">Sale Category</label>
                                                                <div class="col-md-6">
                                                                    <select class="form-control" name="sale_category">
                                                                        <option value="Dxb">Dxb Sale</option>
                                                                        <option value="Box">Box Sale</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="row form-group">
                                                                <label class="col-md-3 control-label pull-left">Sale Type</label>
                                                                <div class="col-md-6">
                                                                    <select class="form-control" name="sale_type" id="add_previous_debts_sale_type">
                                                                        <option value="Credit Sale">Credit Sale</option>
                                                                        <option value="Gold Sale">Gold Sale</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="row form-group">
                                                                <label class="col-md-3 control-label pull-left">Total Amount</label>
                                                                <div class="col-md-6">
                                                                    <div class="input-group input-small">
                                                                        <span class="input-group-addon" id="add_prev_debts_credit_symbol">
                                                                            Rs.
                                                                        </span>
                                                                        <input type="number" maxlength="15" class="form-control input-small" id="total_amount" name="total_amount"/>
                                                                        <span class="input-group-addon hidden" id="add_prev_debts_gold_symbol">
                                                                            g
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row form-group">
                                                                <label class="control-label col-md-3">Description</label>
                                                                <div class="col-md-6">
                                                                    <textarea name="description" class="form-control input-large"></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" data-dismiss="modal" class="btn default">Close</button>
                                            <button type="submit" class="btn green">Save changes</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="modal fade" id="customer_success_modal" tabindex="-1" role="basic" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                        <h4 class="modal-title">Success!</h4>
                                    </div>
                                    <div class="modal-body">
                                        Customer Details Edited Successfully
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn green" data-dismiss="modal" onclick="window.location.reload()">Ok</button>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>

                        <div class="modal fade" id="previous_debts_success_modal" tabindex="-1" role="basic" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                        <h4 class="modal-title">Success!</h4>
                                    </div>
                                    <div class="modal-body">
                                        Previous Debt Added Successfully
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn green" data-dismiss="modal" onclick="window.location.reload()">Ok</button>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        
                        <div class="pull-right">
                            <a class="btn default green-stripe"  data-toggle="modal" href="#add_previous_debts"> Add Previous Debts</a>
                        </div>
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab_1_1" data-toggle="tab"> Overview </a>
                            </li>
                            <li>
                                <a href="#tab_1_2" data-toggle="tab"> Overall DXB Sales </a>
                            </li>
                            <li>
                                <a href="#tab_1_3" data-toggle="tab"> Overall Box Sales </a>
                            </li>
                            <li>
                                <a href="#tab_1_4" data-toggle="tab"> Overall Payments </a>
                            </li>
                            <li>
                                <a href="#tab_1_5" data-toggle="tab"> Overall DXB Returns </a>
                            </li>
                            <li>
                                <a href="#tab_1_6" data-toggle="tab"> Account </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_1_1">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-offset-1 col-md-10">
                                                <table class="table table-hover table-bordered table-striped">
                                                    <tr>
                                                        <td>
                                                            <strong>Customer ID</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $customer_details->id; ?>
                                                        </td>
                                                        <td>
                                                            <strong>Customer Name</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $customer_details->customer_name; ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Mobile Number</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $customer_details->contact_number; ?>
                                                        </td>
                                                        <td>
                                                            <strong>Telephone Number</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $customer_details->tel_number; ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Customer Status</strong>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            if($customer_details->status == 1){
                                                                echo '<span class="label label-success">Active</span>';
                                                            }else if($customer_details->status == 2){
                                                                echo '<span class="label label-warning">Inactive</span>';
                                                            }else if($customer_details->status == 3){
                                                                echo '<span class="label label-danger">Deleted</span>';
                                                            }else if($customer_details->status == 4){
                                                                echo '<span class="label label-info">Hold-On</span>';
                                                            }
                                                            ?>
                                                        </td>
                                                        <td>
                                                            <strong>Customer Type</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $customer_details->customer_type; ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Created On</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $customer_details->added_on; ?>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <!--end col-md-10-->
                                        </div>
                                        <!--end row-->  
                                        
                                        <h4>Account Details</h4>
                                        <hr>
                                        
                                        <div class="row">
                                            <div class="col-md-offset-2 col-md-8">
                                                <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                    <tr>
                                                        <td>
                                                            <strong>Total DXB Credit Balance</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount_credit = $customer_details->debt_amount_cash;
                                                            if($balance_amount_credit > 0){
                                                                $col_colour_credit = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour_credit = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour_credit; ?>">
                                                            <strong><?php echo 'Rs. '.number_format($balance_amount_credit,2,'.',','); ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total DXB Gold Balance</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount_gold = $customer_details->debt_amount_gold;
                                                            if($balance_amount_gold > 0){
                                                                $col_colour_gold = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour_gold = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour_gold; ?>">
                                                            <strong><?php echo number_format($balance_amount_gold,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total Over Paid DXB Credit Balance</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo 'Rs. '.number_format($customer_details->over_paid_cash,2,'.',','); ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total Over Paid DXB Gold Balance</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($customer_details->over_paid_gold,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                    </tr>
                                                </table>
                                                <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                    <tr>
                                                        <td>
                                                            <strong>Total BOX Credit Balance</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount_box_credit = $customer_details->box_debt_amount_cash;
                                                            if($balance_amount_box_credit > 0){
                                                                $col_colour_box_credit = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour_box_credit = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour_box_credit; ?>">
                                                            <strong><?php echo 'Rs. '.number_format($balance_amount_box_credit,2,'.',','); ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total BOX Gold Balance</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount_box_gold = $customer_details->box_debt_amount_gold;
                                                            if($balance_amount_box_gold > 0){
                                                                $col_colour_box_gold = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour_box_gold = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour_box_gold; ?>">
                                                            <strong><?php echo number_format($balance_amount_box_gold,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total Over Paid BOX Credit Balance</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo 'Rs. '.number_format($customer_details->box_over_paid_cash,2,'.',','); ?></strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Total Over Paid BOX Gold Balance</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($customer_details->box_over_paid_gold,3,'.',',').' g'; ?></strong>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab_1_2">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#customer_dxb_sales').DataTable({
                                            order: [[ 0, "desc" ]],
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=customer_dxb_sales&customer_id=<?php echo $customer_details->id; ?>", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "Invoice No."},
                                                {"sTitle": "Date"},
                                                {"sTitle": "Sale Type"},
                                                {"sTitle": "Sale Status"},
                                                {"sTitle": "Total Amount"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-money"></i> Overall DXB Sales
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        
                                        <?php if($tot_credit_sale_details){ 
                                            $total_paid_amount_credit = 0;
                                            $total_ret_amount_credit = 0;
                                            if($tot_credit_ret_sale_details){
                                                $total_ret_amount_credit = $tot_credit_ret_sale_details->total_amount;
                                            }
                                            $total_paid_amount_credit = $tot_credit_sale_details->total_amount - ($tot_credit_sale_details->balance_amount + $total_ret_amount_credit);
                                        ?>  
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                        <tr>
                                                            <td>
                                                                <strong>Tot Cr. Amt.</strong>
                                                            </td>
                                                            <td>
                                                                <strong><?php echo 'Rs. '.number_format($tot_credit_sale_details->total_amount,2,'.',','); ?></strong>
                                                            </td>
                                                            <td>
                                                                <strong>Tot Cr. Paid Amt.</strong>
                                                            </td>
                                                            <td>
                                                                <strong><?php echo 'Rs. '.number_format($total_paid_amount_credit,2,'.',','); ?></strong>
                                                            </td>
                                                            <?php if($tot_credit_ret_sale_details){ ?>
                                                                <td>
                                                                    <strong>Tot Cr. Ret. Amt.</strong>
                                                                </td>
                                                                <td>
                                                                    <strong><?php echo 'Rs. '.number_format($total_ret_amount_credit,2,'.',','); ?></strong>
                                                                </td>
                                                            <?php } ?>
                                                            <td>
                                                                <strong>Tot Cr. Bal.</strong>
                                                            </td>
                                                            <?php 
                                                                $balance_amount_credit = $tot_credit_sale_details->total_amount - ($total_paid_amount_credit + $total_ret_amount_credit);
                                                                if($balance_amount_credit > 0){
                                                                    $col_colour_credit = 'background-color: #ff000085;';
                                                                }else{
                                                                    $col_colour_credit = 'background-color: #03ff007d;';
                                                                }
                                                            ?>
                                                            <td style="<?php echo $col_colour_credit; ?>">
                                                                <strong><?php echo 'Rs. '.number_format($balance_amount_credit,2,'.',','); ?></strong>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>                                    
                                        <?php 
                                        }
                                        $total_paid_amount_gold = 0;
                                        $total_ret_amount_gold = 0;
                                        if($tot_gold_sale_details){
                                            if($tot_gold_ret_sale_details){
                                                $total_ret_amount_gold = $tot_gold_ret_sale_details->total_amount;
                                            }
                                            $total_paid_amount_gold = $tot_gold_sale_details->total_amount - ($tot_gold_sale_details->balance_amount + $total_ret_amount_gold);
                                        ?>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                    <tr>
                                                        <td>
                                                            <strong>Tot. Gd. Amt.</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($tot_gold_sale_details->total_amount,2,'.',',').' g'; ?></strong>
                                                        </td>
                                                        <td>
                                                            <strong>Tot. Gd. Paid Amt.</strong>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo number_format($total_paid_amount_gold,2,'.',',').' g'; ?></strong>
                                                        </td>
                                                        <?php if($tot_gold_ret_sale_details){ ?>
                                                            <td>
                                                                <strong>Tot Gd. Ret. Amt.</strong>
                                                            </td>
                                                            <td>
                                                                <strong><?php echo number_format($total_ret_amount_gold,3,'.',',').' g'; ?></strong>
                                                            </td>
                                                        <?php } ?>
                                                        <td>
                                                            <strong>Tot Gd. Bal.</strong>
                                                        </td>
                                                        <?php 
                                                            $balance_amount_gold = $tot_gold_sale_details->total_amount - ($total_paid_amount_gold + $total_ret_amount_gold);
                                                            if($balance_amount_gold > 0){
                                                                $col_colour_gold = 'background-color: #ff000085;';
                                                            }else{
                                                                $col_colour_gold = 'background-color: #03ff007d;';
                                                            }
                                                        ?>
                                                        <td style="<?php echo $col_colour_gold; ?>">
                                                            <strong><?php echo number_format($balance_amount_gold,2,'.',',').' g'; ?></strong>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        <?php } ?>
                                        <!--end row-->
                                        
                                        <table id="customer_dxb_sales" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab_1_3">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#customer_box_sales').DataTable({
                                            order: [[ 0, "desc" ]],
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=customer_box_sales&customer_id=<?php echo $customer_details->id; ?>", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "ID"},
                                                {"sTitle": "Date"},
                                                {"sTitle": "Sale Type"},
                                                {"sTitle": "Sale Status"},
                                                {"sTitle": "Total Amount"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-money"></i> Overall Box Sales
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table id="customer_box_sales" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab_1_4">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#customer_payments').DataTable({
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=customer_payments&customer_id=<?php echo $customer_details->id; ?>", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "ID"},
                                                {"sTitle": "Date"},
                                                {"sTitle": "Payment Method"},
                                                {"sTitle": "Total Amount"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-money"></i> Overall Payments
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table id="customer_payments" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab_1_5">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#customer_dxb_returns').DataTable({
                                            order: [[ 0, "desc" ]],
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=customer_dxb_returns&customer_id=<?php echo $customer_details->id; ?>", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "Invoice No."},
                                                {"sTitle": "Date"},
                                                {"sTitle": "Sale Type"},
                                                {"sTitle": "Sale Status"},
                                                {"sTitle": "Total Amount"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-money"></i> Overall DXB Returns
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table id="customer_dxb_returns" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab_1_6">
                                <div class="row profile-account">
                                    <div class="col-md-3">
                                        <ul class="ver-inline-menu tabbable margin-bottom-10">
                                            <li class="active">
                                                <a data-toggle="tab" href="#tab_1-1">
                                                <i class="fa fa-cog"></i> Customer info </a>
                                                <span class="after">
                                                </span>
                                            </li>
                                        </ul>
                                    </div>
                                        <div class="col-md-9">
                                            <div class="tab-content">
                                                <div id="tab_1-1" class="tab-pane active">
                                                    <form id="edit_customer" class="form-horizontal" method="post" enctype="multipart/form-data"  novalidate="novalidate">
                                                        <input type="hidden" name="customer_id" id="customer_id" class="form-control" value="<?php echo $customer_details->id; ?>"/>
                                                        <div class="form-body">
                                                            <div class="form-group">
                                                                <label class="col-md-3 control-label pull-left">Customer Name</label>
                                                                <div class="col-md-6">
                                                                    <input type="text" name="customer_name" id="customer_name" placeholder="Shaf & Co." class="form-control" value="<?php echo $customer_details->customer_name; ?>"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="col-md-3 control-label pull-left">Mobile Number</label>
                                                                <div class="col-md-6">
                                                                    <input type="number" name="contact_num" id="contact_num" placeholder="0771234567" class="form-control" value="<?php echo $customer_details->contact_number; ?>"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="col-md-3 control-label pull-left">Telephone Number</label>
                                                                <div class="col-md-6">
                                                                    <input type="number" name="tel_number" id="tel_number" placeholder="0112123456" class="form-control" value="<?php echo $customer_details->tel_number; ?>"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="col-md-3 control-label pull-left">Customer Type</label>
                                                                <div class="col-md-6">
                                                                    <select class="form-control" name="customer_type" id="customer_type">
                                                                        <option value="" disabled="">Select Customer Type</option>
                                                                        <option value="Priority" <?php echo ($customer_details->customer_type=='Priority')?'selected':'';?>>Priority</option>
                                                                        <option value="Walk-In" <?php echo ($customer_details->customer_type=='Walk-In')?'selected':'';?>>Walk-In</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="col-md-3 control-label pull-left">DXB Over Paid Gold</label>
                                                                <div class="col-md-6">
                                                                    <div class="input-group input-small">
                                                                        <input type="number" maxlength="10" class="form-control input-small" name="over_paid_gold" value="<?php echo $customer_details->over_paid_gold; ?>"/>
                                                                        <span class="input-group-addon">
                                                                            g
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="col-md-3 control-label pull-left">DXB Over Paid Cash</label>
                                                                <div class="col-md-6">
                                                                    <div class="input-group input-small">
                                                                        <span class="input-group-addon">
                                                                            Rs.
                                                                        </span>
                                                                        <input type="number" maxlength="15" class="form-control input-small" name="over_paid_cash" value="<?php echo $customer_details->over_paid_cash; ?>"/>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row form-group">
                                                                <label class="col-md-3 control-label pull-left">Box Over Paid Cash</label>
                                                                <div class="col-md-6">
                                                                    <div class="input-group input-small">
                                                                        <span class="input-group-addon">
                                                                            Rs.
                                                                        </span>
                                                                        <input type="number" maxlength="15" class="form-control input-small" name="box_over_paid_cash" value="<?php echo $customer_details->box_over_paid_cash; ?>"/>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row form-group">
                                                                <label class="col-md-3 control-label pull-left">Box Over Paid Gold</label>
                                                                <div class="col-md-6">
                                                                    <div class="input-group input-small">
                                                                        <input type="number" maxlength="10" class="form-control input-small" name="box_over_paid_gold" value="<?php echo $customer_details->box_over_paid_gold; ?>"/>
                                                                        <span class="input-group-addon">
                                                                            g
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-actions fluid">
                                                            <div class="col-md-3"></div>
                                                            <div class="col-md-6">
                                                                <button type="submit" class="btn green" id="save_edit_user_details"> Submit </button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--end col-md-9-->
                                </div>
                            </div>
                            <!--end tab-pane-->
                        </div>
                    </div>
                    <!--END TABS-->
                </div>
            </div>
            <!-- END PAGE CONTENT-->
        </div>
    </div>
    <!-- END CONTENT -->
<!-- END QUICK SIDEBAR -->
</div>