            <div class="row profile">
                <div class="col-md-12">
                    <!--BEGIN TABS-->
                    <div class="tabbable tabbable-custom tabbable-full-width">
                        <div id="response_msg"></div>
                        
                        <div id="add_previous_credits" class="modal fade" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                        <h4 class="modal-title">Add Previous Credits for <?php echo $creditor_details->creditor_name; ?></h4>
                                    </div>
                                    <form id="save_add_previous_credits" class="form-horizontal" method="post">
                                        <input type="hidden" id="creditor_id" name="creditor_id" value="<?php echo $creditor_details->id; ?>">
                                        <div class="modal-body">
                                            <div id="response_msg_modal"></div>
                                            <div class="scroller" style="height:300px" data-always-visible="1" data-rail-visible1="1">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-body">
                                                            <div class="row form-group">
                                                                <label class="col-md-3 control-label pull-left">Date</label>
                                                                <div class="col-md-6">
                                                                    <input class="form-control form-control-inline input-medium date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="bill_date" value="<?php echo date('d-m-Y') ?>"/>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="row form-group">
                                                                <label class="col-md-3 control-label pull-left">Credit Type</label>
                                                                <div class="col-md-6">
                                                                    <select class="form-control input-medium" data-placeholder="Select..." name="credit_type" id="previous_credit_type">
                                                                        <?php if($creditor_details->creditor_type == 'UNA & Normal Creditor'){ ?>
                                                                            <option value="Normal Credit">Normal / UNA Settlement Credit</option>
                                                                            <option value="UNA Credit">UNA Credit</option>
                                                                            
                                                                        <?php } elseif($creditor_details->creditor_type == 'UNA Creditor'){ ?>
                                                                            <option value="UNA Credit">UNA Credit</option>
                                                                            
                                                                        <?php } elseif($creditor_details->creditor_type == 'Normal Creditor'){ ?>
                                                                            <option value="Normal Credit">Normal / UNA Settlement Credit</option>
                                                                            
                                                                        <?php } ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            
                                                            <?php if($creditor_details->creditor_type == 'UNA Creditor'){ 
                                                                $div_prev_credit_class = 'hidden';
                                                                $div_prev_una_credit_class = '';
                                                            }else{
                                                                $div_prev_una_credit_class = 'hidden';
                                                                $div_prev_credit_class = '';
                                                            } ?>
                                                            
                                                            <div id="div_prev_una_credit" class="<?php echo $div_prev_una_credit_class ?>">
                                                                <div class="form-group">
                                                                    <label class="control-label col-md-3">UNA Amount</label>
                                                                    <div class="col-md-6">
                                                                        <div class="input-group input-small">
                                                                            <span class="input-group-addon">
                                                                                AED 
                                                                            </span>
                                                                            <input class="form-control input-small" type="number" id="una_amount" placeholder="0.00" name="una_amount"/>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="control-label col-md-3">UNA Rate</label>
                                                                    <div class="col-md-6">
                                                                        <div class="input-group input-small">
                                                                            <span class="input-group-addon">
                                                                                Rs. 
                                                                            </span>
                                                                            <input class="form-control input-small" type="number" id="una_rate" name="una_rate" placeholder="0.00"/>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="control-label col-md-3">LKR Amount</label>
                                                                    <div class="col-md-6">
                                                                        <div class="control-label pull-left" id="div_lkr_amount">Rs. 0.00</div>
                                                                        <input type="hidden" name="lkr_amount" id="lkr_amount" placeholder="0.00" class="form-control"/>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="control-label col-md-3">Recipient</label>
                                                                    <div class="col-md-3">
                                                                        <input type="text" name="recipient" id="recipient" placeholder="" class="form-control"/>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row form-group <?php echo $div_prev_credit_class ?>" id="div_prev_credit">
                                                                <label class="col-md-3 control-label pull-left">Total Amount</label>
                                                                <div class="col-md-6">
                                                                    <div class="input-group input-small">
                                                                        <span class="input-group-addon">
                                                                            Rs. 
                                                                        </span>
                                                                        <input class="form-control input-small" type="number" id="total_amount" name="total_amount" placeholder="0.00"/>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row form-group">
                                                                <label class="col-md-3 control-label pull-left">Description</label>
                                                                <div class="col-md-6">
                                                                    <textarea name="description" id="description" class="form-control input-large"></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" data-dismiss="modal" class="btn default">Close</button>
                                            <button type="submit" class="btn green">Save changes</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="modal fade" id="success_modal" tabindex="-1" role="basic" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                        <h4 class="modal-title">Success!</h4>
                                    </div>
                                    <div class="modal-body">
                                        Creditor Details Edited Successfully
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn green" data-dismiss="modal" onclick="window.location.reload()">Ok</button>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>

                        <div class="modal fade" id="previous_credits_success_modal" tabindex="-1" role="basic" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                        <h4 class="modal-title">Success!</h4>
                                    </div>
                                    <div class="modal-body">
                                        Previous Credit Added Successfully
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn green" data-dismiss="modal" onclick="window.location.reload()">Ok</button>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        
                        <div id="open_creditor_accounts" class="modal fade" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                        <h4 class="modal-title">View Credit Details</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="view_credit_account"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div id="open_creditor_payments" class="modal fade" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                        <h4 class="modal-title">View Payment Details</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="view_payment_account"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="pull-right">
                            <a class="btn default green-stripe" data-toggle="modal" href="#add_previous_credits"> Add Previous Credits</a>
                        </div>
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab_1_1" data-toggle="tab"> Overview </a>
                            </li>
                            <li>
                                <a href="#tab_1_2" data-toggle="tab"> Overall Credits </a>
                            </li>
                            <li>
                                <a href="#tab_1_3" data-toggle="tab"> Overall Payments </a>
                            </li>
                            <li>
                                <a href="#tab_1_4" data-toggle="tab"> Account </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_1_1">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-offset-1 col-md-10">
                                                <table class="table table-hover table-bordered table-striped">
                                                    <tr>
                                                        <td>
                                                            <strong>Creditor ID</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $creditor_details->id; ?>
                                                        </td>
                                                        <td>
                                                            <strong>Creditor Name</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $creditor_details->creditor_name; ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Contact Number</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $creditor_details->contact_number; ?>
                                                        </td>
                                                        <td>
                                                            <strong>Creditor Type</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $creditor_details->creditor_type; ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Creditor Status</strong>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            if($creditor_details->status == 1){
                                                                echo '<span class="label label-success">Active</span>';
                                                            }else if($creditor_details->status == 2){
                                                                echo '<span class="label label-warning">Inactive</span>';
                                                            }else if($creditor_details->status == 3){
                                                                echo '<span class="label label-danger">Deleted</span>';
                                                            }
                                                            ?>
                                                        </td>
                                                        <td>
                                                            <strong>Created On</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $creditor_details->added_on; ?>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <!--end col-md-10-->
                                        </div>
                                        <!--end row-->  
                                        
                                        <?php if($creditor_details->amount > 0){?>
                                            <h4>Account Details</h4>
                                            <hr> 

                                            <div class="row">
                                                <div class="col-md-12">
                                                    <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                        <tr>
                                                            <td>
                                                                <strong>Total Credit Amount</strong>
                                                            </td>
                                                            <td>
                                                                <strong><?php echo 'Rs. '.number_format($creditor_details->amount,2,'.',','); ?></strong>
                                                            </td>
                                                            <td>
                                                                <strong>Total Credit Paid Amount</strong>
                                                            </td>
                                                            <td>
                                                                <strong><?php echo 'Rs. '.number_format($creditor_details->paid_amount,2,'.',','); ?></strong>
                                                            </td>
                                                            <td>
                                                                <strong>Total Credit Balance</strong>
                                                            </td>
                                                            <?php 
                                                                $balance_amount_credit = $creditor_details->bal_amount;
                                                                if($balance_amount_credit > 0){
                                                                    $col_colour_credit = 'background-color: #ff000085;';
                                                                }else{
                                                                    $col_colour_credit = 'background-color: #03ff007d;';
                                                                }
                                                            ?>
                                                            <td style="<?php echo $col_colour_credit; ?>">
                                                                <strong><?php echo 'Rs. '.number_format($balance_amount_credit,2,'.',','); ?></strong>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        <?php } ?>
                                        
                                        <?php if($creditor_details->una_amount > 0){?>
                                            <h4>UNA Account Details</h4>
                                            <hr> 

                                            <div class="row">
                                                <div class="col-md-12">
                                                    <table class="table table-hover table-bordered table-striped" style="font-size: initial;">
                                                        <tr>
                                                            <td>
                                                                <strong>Total Credit Amount</strong>
                                                            </td>
                                                            <td>
                                                                <strong><?php echo 'Rs. '.number_format($creditor_details->una_amount,2,'.',','); ?></strong>
                                                            </td>
                                                            <td>
                                                                <strong>Total Credit Paid Amount</strong>
                                                            </td>
                                                            <td>
                                                                <strong><?php echo 'Rs. '.number_format($creditor_details->una_paid_amount,2,'.',','); ?></strong>
                                                            </td>
                                                            <td>
                                                                <strong>Total Credit Balance</strong>
                                                            </td>
                                                            <?php 
                                                                $balance_una_amount_credit = $creditor_details->una_bal_amount;
                                                                if($balance_una_amount_credit > 0){
                                                                    $col_una_colour_credit = 'background-color: #ff000085;';
                                                                }else{
                                                                    $col_una_colour_credit = 'background-color: #03ff007d;';
                                                                }
                                                            ?>
                                                            <td style="<?php echo $col_una_colour_credit; ?>">
                                                                <strong><?php echo 'Rs. '.number_format($balance_una_amount_credit,2,'.',','); ?></strong>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        <?php } ?>
                                        
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab_1_2">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#creditor_accounts').DataTable({
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=creditor_accounts&creditor_id=<?php echo $creditor_details->id; ?>", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "ID"},
                                                {"sTitle": "Date"},
                                                {"sTitle": "Credit Type"},
                                                {"sTitle": "Amount"},
                                                {"sTitle": "Note"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-money"></i> Overall Credits
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table id="creditor_accounts" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab_1_3">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#creditor_payments').DataTable({
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=creditor_payments&creditor_id=<?php echo $creditor_details->id; ?>", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "ID"},
                                                {"sTitle": "Date"},
                                                {"sTitle": "Payment Method"},
                                                {"sTitle": "Amount"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-money"></i> Overall Payments
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table id="creditor_payments" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab_1_4">
                                <div class="row profile-account">
                                    <div class="col-md-3">
                                        <ul class="ver-inline-menu tabbable margin-bottom-10">
                                            <li class="active">
                                                <a data-toggle="tab" href="#tab_1-1">
                                                <i class="fa fa-cog"></i> Creditor info </a>
                                                <span class="after">
                                                </span>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-md-9">
                                        <div class="tab-content">
                                            <div id="tab_1-1" class="tab-pane active">
                                                <form id="edit_creditor" class="form-horizontal" method="post" enctype="multipart/form-data"  novalidate="novalidate">
                                                    <input type="hidden" name="creditor_id" id="creditor_id" class="form-control" value="<?php echo $creditor_details->id; ?>"/>
                                                    <div class="form-body">
                                                        <div class="form-group">
                                                            <label class="col-md-3 control-label pull-left">Creditor Name</label>
                                                            <div class="col-md-6">
                                                                <input type="text" name="creditor_name" id="creditor_name" placeholder="Shaf & Co." class="form-control" value="<?php echo $creditor_details->creditor_name; ?>"/>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="col-md-3 control-label pull-left">Contact Number</label>
                                                            <div class="col-md-6">
                                                                <input type="number" name="contact_num" id="contact_num" placeholder="0112123456" class="form-control" value="<?php echo $creditor_details->contact_number; ?>"/>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="col-md-3 control-label pull-left">Creditor Type</label>
                                                            <div class="col-md-6">
                                                                <select class="form-control" name="creditor_type" id="creditor_type">
                                                                    <option value="" disabled="">Select Creditor Type</option>
                                                                    <option value="Normal Creditor" <?php echo ($creditor_details->creditor_type=='Normal Creditor')?'selected':'';?>>Normal Creditor</option>
                                                                    <option value="UNA Creditor" <?php echo ($creditor_details->creditor_type=='UNA Creditor')?'selected':'';?>>UNA Creditor</option>
                                                                    <option value="UNA & Normal Creditor" <?php echo ($creditor_details->creditor_type=='UNA & Normal Creditor')?'selected':'';?>>UNA & Normal Creditor</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-actions fluid">
                                                        <div class="col-md-3"></div>
                                                        <div class="col-md-6">
                                                            <button type="submit" class="btn green" id="save_edit_user_details"> Submit </button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-md-9-->
                                </div>
                            </div>
                            <!--end tab-pane-->
                        </div>
                    </div>
                    <!--END TABS-->
                </div>
            </div>
            <!-- END PAGE CONTENT-->
        </div>
    </div>
    <!-- END CONTENT -->
<!-- END QUICK SIDEBAR -->
</div>