
            <div class="row">
                <div class="col-md-12">
                    <?php if(isset($success_msg) && $success_msg!=NULL){ ?>
                    <div class="alert alert-success"><?php echo $success_msg; ?></div>
                    <?php } ?>
                    <div id="response_msg"></div>
                
                    <div class="tabbable tabbable-custom boxless">
                        <ul class="nav nav-tabs">
                            <li class="<?php echo $active; ?>">
                                <a href="#tab_1" data-toggle="tab"> Active Bank Accounts </a>
                            </li>
                            <li class="<?php echo $inactive; ?>">
                                <a href="#tab_2" data-toggle="tab"> Inactive Bank Accounts </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane <?php echo $active; ?>" id="tab_1">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#active_bank_accounts').DataTable({
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=bank_accounts&status=1", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "ID"},
                                                {"sTitle": "Account Type"},
                                                {"sTitle": "Account Name"},
                                                {"sTitle": "Bank Name"},
                                                {"sTitle": "Account Number"},
                                                {"sTitle": "Bank Balance"},
                                                {"sTitle": "Created On"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>
                                
                                <div id="add_new_bank_ammount" class="modal fade" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                <h4 class="modal-title">Add New Bank Account</h4>
                                            </div>
                                            <form id="add_bank_account" class="form-horizontal" method="post">
                                                <div class="modal-body">
                                                    <div id="response_msg_modal"></div>
                                                    <div class="scroller" style="height:300px" data-always-visible="1" data-rail-visible1="1">
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <div class="form-body">
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Account Type</label>
                                                                        <div class="col-md-6">
                                                                            <select class="form-control" name="account_type">
                                                                                <option value="Dxb">Dxb</option>
                                                                                <option value="Box">Box</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Account Name</label>
                                                                        <div class="col-md-6">
                                                                            <input type="text" name="account_name" id="account_name" class="form-control"/>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Bank Name</label>
                                                                        <div class="col-md-6">
                                                                            <select class="form-control select2me" name="bank_name" id="bank_name">
                                                                                <option value="">Please Select a Bank</option>
                                                                                <?php
                                                                                    $banks = $this->admin_db->get_all_banks();
                                                                                    foreach ($banks as $bank) {
                                                                                        $sel = '';
                                                                                ?>

                                                                                <option value="<?php echo $bank['id']; ?>" <?php echo $sel; ?>><?php echo $bank['bank_name']; ?></option>

                                                                            <?php } ?>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Account Number</label>
                                                                        <div class="col-md-6">
                                                                            <input type="number" name="account_number" id="account_number" class="form-control"/>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" data-dismiss="modal" class="btn default">Close</button>
                                                    <button type="submit" class="btn green">Save changes</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="modal fade" id="success_modal" tabindex="-1" role="basic" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                <h4 class="modal-title">Success!</h4>
                                            </div>
                                            <div class="modal-body">
                                                Bank Account Added Successfully
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn green" data-dismiss="modal" onclick="window.location.reload()">Ok</button>
                                            </div>
                                        </div>
                                        <!-- /.modal-content -->
                                    </div>
                                    <!-- /.modal-dialog -->
                                </div>
                                <!-- /.modal -->

                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-money"></i>Bank Accounts
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <div class="table-toolbar">
                                            <div class="btn-group">
                                                <a class="btn green" data-toggle="modal" href="#add_new_bank_ammount">
                                                    Add New <i class="fa fa-plus"></i>
                                                </a>
                                            </div>
                                        </div>
                                        <table id="active_bank_accounts" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane <?php echo $inactive; ?>" id="tab_2">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#inactive_bank_accounts').DataTable({
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=bank_accounts&status=2", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "ID"},
                                                {"sTitle": "Account Type"},
                                                {"sTitle": "Account Name"},
                                                {"sTitle": "Bank Name"},
                                                {"sTitle": "Account Number"},
                                                {"sTitle": "Bank Balance"},
                                                {"sTitle": "Created On"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>

                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-user"></i>Inactive Bank Accounts
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table id="inactive_bank_accounts" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> 
            </div>
            <!-- END DASHBOARD STATS -->
        </div>
    </div>
    <!-- END CONTENT -->
</div>
<!-- END CONTAINER -->