            
                    
            <div id="withdraw_cash_modal" class="modal fade" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                            <h4 class="modal-title">Withdraw Cash From this Account</h4>
                        </div>
                        <form id="withdraw_cash" class="form-horizontal" method="post">
                            <div class="modal-body">
                                <div class="alert alert-danger hidden" id="withdrawal_alert_error"></div>
                                <div class="scroller" style="height:190px" data-always-visible="1" data-rail-visible1="1">
                                    <input type="hidden" name="account_id" value="<?php echo $account_details->id ?>"/>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-body">
                                                <div class="form-group">
                                                    <label class="control-label col-md-4">Date</label>
                                                    <div class="col-md-3">
                                                        <input class="form-control form-control-inline input-medium date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="withdraw_date" value="<?php echo date('d-m-Y') ?>"/>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-md-4">Balance Amount</label>
                                                    <div class="col-md-3">
                                                        <div class="control-label pull-left"><?php echo 'Rs. '.number_format($account_details->bank_balance,3,'.',','); ?></div>
                                                        <input type="hidden" id="bank_balance_amount" value="<?php echo $account_details->bank_balance; ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-md-4">Withdrawal Amount</label>
                                                    <div class="col-md-3">
                                                        <div class="input-group input-small">
                                                            <span class="input-group-addon">
                                                                Rs. 
                                                            </span>
                                                            <input class="form-control input-small" type="number" id="withdrawal_amount" name="withdrawal_amount"/>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-md-4">Actual Account Balance</label>
                                                    <div class="col-md-3">
                                                        <div class="control-label pull-left" id="div_actual_acc_bal" style="color: #2d823a"><?php echo 'Rs. '.number_format($account_details->bank_balance,2,'.',','); ?></div>
                                                        <input type="hidden" id="txt_actual_acc_bal" name="txt_actual_acc_bal">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" data-dismiss="modal" class="btn default">Close</button>
                                <button type="submit" class="btn green" id="div_withdrawal_submit_button">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="row profile">
                <div class="col-md-12">
                    <!--BEGIN TABS-->
                    <div class="tabbable tabbable-custom tabbable-full-width">
                        <div id="response_msg"></div>
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab_1_1" data-toggle="tab"> Overview </a>
                            </li>
                            <li>
                                <a href="#tab_1_3" data-toggle="tab"> Account </a>
                            </li>
                            <?php if($account_details->bank_balance > 0){ ?>
                            <div class="pull-right">
                                <a class="btn default green-stripe"  data-toggle="modal" href="#withdraw_cash_modal"> Withdraw Cash</a>
                            </div>
                            <?php } ?>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_1_1">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-offset-1 col-md-10">
                                                <table class="table table-hover table-bordered table-striped">
                                                    <tr>
                                                        <td>
                                                            <strong>Account Type</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $account_details->account_type; ?>
                                                        </td>
                                                        <td>
                                                            <strong>Account Name</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $account_details->account_name; ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Bank Name</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $account_details->bank_name; ?>
                                                        </td>
                                                        <td>
                                                            <strong>Account Number</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $account_details->account_number; ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <strong>Bank Account Status</strong>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            if($account_details->status == 1){
                                                                echo '<span class="label label-success">Active</span>';
                                                            }else if($account_details->status == 2){
                                                                echo '<span class="label label-warning">Inactive</span>';
                                                            }
                                                            ?>
                                                        </td>
                                                        <td>
                                                            <strong>Account Created On</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo $account_details->created_on; ?>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <!--end col-md-10-->
                                        </div>
                                        <!--end row-->
                                        <div class="row">
                                            <div class="col-md-offset-1 col-md-10">
                                                <table class="table table-hover table-bordered table-striped" style="font-size: x-large;">
                                                    <tr>
                                                        <td>
                                                            <strong>Account Balance</strong>
                                                        </td>
                                                        <td>
                                                            <?php echo 'Rs. '.number_format($account_details->bank_balance,2,'.',','); ?>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        <!--end row-->
                                        <div class="row">
                                            <div class="col-md-12">                                        
                                                <h4>Recent Transactions</h4>
                                                <hr>
                                                
                                                <script type="text/javascript" language="javascript" >
                                                    $(document).ready(function () {
                                                        var dataTable = $('#bank_account_logs').DataTable({
                                                            order: [[ 0, "desc" ]],
                                                            select: true,
                                                            pageLength: 10,
                                                            processing: true,
                                                            serverSide: true,
                                                            ajax: {
                                                                url: "Json_data/json_data_records?json_type=bank_account_logs&account_id=<?php echo $account_details->id; ?>&account_type=<?php echo $account_details->account_type; ?>", // json datasource
                                                                type: "post", // method  , by default get
                                                                error: function () {  // error handling
                                                                    $(".employee-grid-error").html("");
                                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                                    $("#employee-grid_processing").css("display", "none");

                                                                }
                                                            }, "aoColumns": [
                                                                {"sTitle": "", "sClass": "hidden"},
                                                                {"sTitle": "#"},
                                                                {"sTitle": "Date"},
                                                                {"sTitle": "Description"},
                                                                {"sTitle": "Amount"},
                                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                                $(nRow).attr('id', '' + aData[0]);

                                                            }
                                                        });

                                                    });
                                                </script>
                                                
                                                <table id="bank_account_logs" class="table table-striped table-bordered table-hover"></table>
                                                
                                            </div>
                                        </div>
                                        <!--end row-->
                                    </div>
                                </div>
                            </div>
                            <!--tab_1_2-->
                            <div class="tab-pane" id="tab_1_3">
                                <div class="row profile-account">
                                    <div class="col-md-3">
                                        <ul class="ver-inline-menu tabbable margin-bottom-10">
                                            <li class="active">
                                                <a data-toggle="tab" href="#tab_1-1">
                                                <i class="fa fa-cog"></i> Bank Account Info </a>
                                                <span class="after">
                                                </span>
                                            </li>
                                        </ul>
                                    </div>
                                        <div class="col-md-9">
                                            <div class="tab-content">
                                                <div id="tab_1-1" class="tab-pane active">
                                                    <form id="edit_bank_account" class="form-horizontal" method="post" enctype="multipart/form-data"  novalidate="novalidate">
                                                    <input type="hidden" name="account_id" value="<?php echo $account_details->id; ?>">
                                                        <div class="form-body">
                                                            <div class="row form-group">
                                                                <label class="col-md-3 control-label pull-left">Account Type</label>
                                                                <div class="col-md-6">
                                                                    <select class="form-control" name="account_type">
                                                                        <option value="Dxb" <?php echo ($account_details->account_type=='Dxb')?'selected':'';?>>Dxb</option>
                                                                        <option value="Box" <?php echo ($account_details->account_type=='Box')?'selected':'';?>>Box</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="col-md-3 control-label pull-left">Account Name</label>
                                                                <div class="col-md-6">
                                                                    <input type="text" name="account_name" id="account_name" class="form-control" value="<?php echo $account_details->account_name; ?>"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="col-md-3 control-label pull-left">Bank Name</label>
                                                                <div class="col-md-6">
                                                                    <select class="form-control select2me" name="bank_name" id="bank_name">
                                                                        <option value="" disabled="disabled">Please Select a Bank</option>
                                                                        <?php
                                                                            $banks = $this->admin_db->get_all_banks();
                                                                            foreach ($banks as $bank) {
                                                                                if($bank['id'] == $account_details->bank_id){
                                                                                    $sel = 'selected';
                                                                                }else{
                                                                                    $sel = '';
                                                                                }
                                                                        ?>

                                                                        <option value="<?php echo $bank['id']; ?>" <?php echo $sel; ?>><?php echo $bank['bank_name']; ?></option>

                                                                    <?php } ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="col-md-3 control-label pull-left">Account Number</label>
                                                                <div class="col-md-6">
                                                                    <input type="number" name="account_number" id="account_number" class="form-control" value="<?php echo $account_details->account_number; ?>"/>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="col-md-3 control-label pull-left">Bank Balance</label>
                                                                <div class="col-md-6">
                                                                    <input type="number" name="bank_balance" id="bank_balance" class="form-control" value="<?php echo $account_details->bank_balance; ?>"/>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-actions fluid">
                                                            <div class="col-md-3"></div>
                                                            <div class="col-md-6">
                                                                <button type="submit" class="btn green"> Submit </button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--end col-md-9-->
                                </div>
                            </div>
                            <!--end tab-pane-->
                        </div>
                    </div>
                    <!--END TABS-->
                </div>
            </div>
            <!-- END PAGE CONTENT-->
        </div>
    </div>
    <!-- END CONTENT -->
<!-- END QUICK SIDEBAR -->
</div>