
            <div class="row">
                <div class="col-md-12">
                    <?php if(isset($success_msg) && $success_msg!=NULL){ ?>
                    <div class="alert alert-success"><?php echo $success_msg; ?></div>
                    <?php } ?>
                    <div id="response_msg"></div>
                
                    <div class="tabbable tabbable-custom boxless">
                        <ul class="nav nav-tabs">
                            <li class="<?php echo $active; ?>">
                                <a href="#tab_1" data-toggle="tab"> Active Stock Items </a>
                            </li>
                            <li class="<?php echo $inactive; ?>">
                                <a href="#tab_2" data-toggle="tab"> Inactive Stock Items </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane <?php echo $active; ?>" id="tab_1">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#active_items').DataTable({
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=stock_items&status=1", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "ID"},
                                                {"sTitle": "Item Type"},
                                                {"sTitle": "Item Category"},
                                                {"sTitle": "Item Code"},
                                                {"sTitle": "Item Name"},
                                                {"sTitle": "Description"},
                                                {"sTitle": "Status"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>
                                
                                <div id="add_new_stock_item" class="modal fade" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                <h4 class="modal-title">Add New Stock Item</h4>
                                            </div>
                                            <form id="add_stock_item" class="form-horizontal" method="post">
                                                <div class="modal-body">
                                                    <div id="response_msg_modal"></div>
                                                    <div class="scroller" style="height:300px" data-always-visible="1" data-rail-visible1="1">
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <div class="form-body">
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Item Type</label>
                                                                        <div class="col-md-6">
                                                                            <select class="form-control" name="item_type">
                                                                                <option value="Dxb">Dxb</option>
                                                                                <option value="Box">Box</option>
                                                                                <option value="24K Sale">24K Sale</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Item Category</label>
                                                                        <div class="col-md-6">
                                                                            <select class="form-control select2me" name="stock_item_category" id="stock_item_category">
                                                                                <option value="">Please select a category</option>
                                                                                <option value="Add New Category">Add New Category</option>
                                                                                <?php
                                                                                $categories = $this->admin_db->get_stock_item_categories();
                                                                                foreach ($categories as $category) {
                                                                                    $sel = '';
                                                                                ?>

                                                                                <option value="<?php echo $category['id']; ?>" <?php echo $sel; ?>><?php echo $category['category_name']; ?></option>

                                                                                <?php } ?>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div id="add_new_category" class="hidden">
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-3">Category Name</label>
                                                                            <div class="col-md-6">
                                                                                <input type="text" name="category_name" id="customer_name" placeholder="Type Here.." class="form-control"/>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-3">Category Description</label>
                                                                            <div class="col-md-6">
                                                                                <textarea name="description" id="description" class="form-control"></textarea>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Item Code</label>
                                                                        <div class="col-md-6">
                                                                            <input type="text" name="item_code" id="item_code" placeholder="Type here.." class="form-control"/>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Item Name</label>
                                                                        <div class="col-md-6">
                                                                            <input type="text" name="item_name" id="item_name" placeholder="Type here.." class="form-control"/>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Item Description</label>
                                                                        <div class="col-md-6">
                                                                            <textarea name="item_description" id="item_description" class="form-control"></textarea>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" data-dismiss="modal" class="btn default">Close</button>
                                                    <button type="submit" class="btn green">Save changes</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="modal fade" id="success_modal" tabindex="-1" role="basic" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                <h4 class="modal-title">Success!</h4>
                                            </div>
                                            <div class="modal-body">
                                                Stock Item Added Successfully
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn green" data-dismiss="modal" onclick="window.location.reload()">Ok</button>
                                            </div>
                                        </div>
                                        <!-- /.modal-content -->
                                    </div>
                                    <!-- /.modal-dialog -->
                                </div>
                                <!-- /.modal -->

                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-money"></i>Active Stock Items
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <div class="table-toolbar">
                                            <div class="btn-group">
                                                <a class="btn green" data-toggle="modal" href="#add_new_stock_item">
                                                    Add New <i class="fa fa-plus"></i>
                                                </a>
                                            </div>
                                        </div>
                                        <table id="active_items" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane <?php echo $inactive; ?>" id="tab_2">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#inactive_items').DataTable({
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=stock_items&status=2", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "ID"},
                                                {"sTitle": "Item Type"},
                                                {"sTitle": "Item Category"},
                                                {"sTitle": "Item Code"},
                                                {"sTitle": "Item Name"},
                                                {"sTitle": "Description"},
                                                {"sTitle": "Status"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>

                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-user"></i>Inactive Stock Items
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table id="inactive_items" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> 
            </div>
            <!-- END DASHBOARD STATS -->
        </div>
    </div>
    <!-- END CONTENT -->
</div>
<!-- END CONTAINER -->