
            <div class="row">
                <div class="col-md-12">
                    <?php if(isset($success_msg) && $success_msg!=NULL){ ?>
                    <div class="alert alert-success"><?php echo $success_msg; ?></div>
                    <?php } ?>
                    <div id="response_msg"></div>
                
                    <div class="">
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_1">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#expenses').DataTable({
                                            order: [[ 0, "desc" ]],
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=expenses", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "ID"},
                                                {"sTitle": "Date"},
                                                {"sTitle": "Expense Type"},
                                                {"sTitle": "Expense Category"},
                                                {"sTitle": "Payment Method"},
                                                {"sTitle": "Amount"},
                                                {"sTitle": "Status"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>
                                
                                <div id="add_new_expense" class="modal fade" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                <h4 class="modal-title">Add New Expense</h4>
                                            </div>
                                            <form id="add_expense" class="form-horizontal" method="post">
                                                <div class="modal-body">
                                                    <div id="response_msg_modal"></div>
                                                    <div class="scroller" style="height:400px" data-always-visible="1" data-rail-visible1="1">
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <div class="form-body">
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-4">Date</label>
                                                                        <div class="col-md-3">
                                                                            <input class="form-control form-control-inline input-medium date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="expense_date" value="<?php echo date('d-m-Y') ?>"/>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-4">Expense Type</label>
                                                                        <div class="col-md-3">
                                                                            <select class="form-control input-large select2me" name="expense_type" id="expense_type">
                                                                                <option value="">Please select an expense type</option>
                                                                                <option value="Dxb">DXB Expense</option>
                                                                                <option value="Box">BOX Expense</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-4">Expense Category</label>
                                                                        <div class="col-md-3">
                                                                            <select class="form-control input-large select2me" name="expense_category" id="expense_category">
                                                                                <option value="">Please select a category</option>
                                                                                <option value="Add New Category">Add New Category</option>
                                                                                <?php
                                                                                $categories = $this->admin_db->get_expense_categories();
                                                                                foreach ($categories as $category) {
                                                                                    $sel = '';
                                                                                ?>

                                                                                <option value="<?php echo $category['id']; ?>" <?php echo $sel; ?>><?php echo $category['category_name']; ?></option>

                                                                                <?php } ?>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div id="add_new_category" class="hidden">
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-4">Category Name</label>
                                                                            <div class="col-md-3">
                                                                                <input type="text" name="category_name" id="customer_name" placeholder="Type Here.." class="form-control input-large"/>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-4">Category Description</label>
                                                                            <div class="col-md-3">
                                                                                <textarea name="description" id="description" class="form-control input-large"></textarea>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-4">Payment Amount</label>
                                                                        <div class="col-md-3">
                                                                            <div class="input-group input-small">
                                                                                <span class="input-group-addon">
                                                                                    Rs. 
                                                                                </span>
                                                                                <input class="form-control input-small" type="number" id="payment_amount" name="payment_amount"/>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-4">Payment Method</label> 
                                                                        <div class="col-md-3">
                                                                            <select class="form-control input-large" name="payment_method" id="payment_method_expense">
                                                                                <option value="Cash">Cash</option>
                                                                                <option value="Cheque">Cheque</option>
                                                                                <option value="Bank Transfer">Bank Transfer</option>
                                                                                <option value="Bank Deposit">Bank Deposit</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div id="div_cheque_details_expense" class="hidden">
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-4">From Bank Account</label>
                                                                            <div class="col-md-3">
                                                                                <select class="form-control input-large select2me" name="cheq_bank_account" id="cheq_bank_account">
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-4">Cheque Number</label>
                                                                            <div class="col-md-3">
                                                                                <input class="form-control input-large" type="number" name="cheq_cheque_number" id="cheq_cheque_number"/>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-4">Deposit Date</label>
                                                                            <div class="col-md-3">
                                                                                <input class="form-control form-control-inline input-large date-picker" size="16" type="text" data-date-format=dd-mm-yyyy name="cheq_deposit_date" value="<?php echo date('d-m-Y') ?>"/>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div id="div_bank_details_expense" class="hidden">
                                                                        <div id="div_bank_tranfer_expense" class="hidden">
                                                                            <div class="form-group">
                                                                                <label class="control-label col-md-4">From Account Number</label>
                                                                                <div class="col-md-3">
                                                                                    <select class="form-control input-large select2me" name="transfer_bank_account" id="transfer_bank_account">
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-4">To Bank Name</label>
                                                                            <div class="col-md-3">
                                                                                <select class="form-control input-large select2me" name="bank_bank_name" id="bank_bank_name">
                                                                                <?php
                                                                                    $banks = $this->admin_db->get_banks_for_receipts();
                                                                                    foreach ($banks as $bank) {
                                                                                        $sel = '';
                                                                                ?>

                                                                                <option value="<?php echo $bank['id']; ?>" <?php echo $sel; ?>><?php echo $bank['bank_name']; ?></option>

                                                                                <?php } ?>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-4">To Bank Account Number</label>
                                                                            <div class="col-md-3">
                                                                                <input class="form-control input-large" type="number" name="bank_account_number" id="bank_account_number"/>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-4">Description</label>
                                                                        <div class="col-md-3">
                                                                            <textarea name="description" id="description" class="form-control input-large"></textarea>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" data-dismiss="modal" class="btn default">Close</button>
                                                    <button type="submit" class="btn green">Save changes</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="modal fade" id="success_modal" tabindex="-1" role="basic" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                <h4 class="modal-title">Success!</h4>
                                            </div>
                                            <div class="modal-body">
                                                Expense Added Successfully
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn green" data-dismiss="modal" onclick="window.location.reload()">Ok</button>
                                            </div>
                                        </div>
                                        <!-- /.modal-content -->
                                    </div>
                                    <!-- /.modal-dialog -->
                                </div>
                                <!-- /.modal -->
                                
                                <div class="modal fade" id="success_modal_request" tabindex="-1" role="basic" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                <h4 class="modal-title">Success!</h4>
                                            </div>
                                            <div class="modal-body">
                                                Expense Request Sent Successfully
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn green" data-dismiss="modal" onclick="window.location.reload()">Ok</button>
                                            </div>
                                        </div>
                                        <!-- /.modal-content -->
                                    </div>
                                    <!-- /.modal-dialog -->
                                </div>
                                <!-- /.modal -->

                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-money"></i>Expenses
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <div class="table-toolbar">
                                            <div class="btn-group">
                                                <a class="btn green" data-toggle="modal" href="#add_new_expense">
                                                    Add New <i class="fa fa-plus"></i>
                                                </a>
                                            </div>
                                        </div>
                                        <table id="expenses" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> 
            </div>
            <!-- END DASHBOARD STATS -->
        </div>
    </div>
    <!-- END CONTENT -->
</div>
<!-- END CONTAINER -->