
            <div class="row">
                <div class="col-md-12">
                    <?php if(isset($success_msg) && $success_msg!=NULL){ ?>
                    <div class="alert alert-success"><?php echo $success_msg; ?></div>
                    <?php } ?>
                    <div id="response_msg"></div>
                
                    <div class="tabbable tabbable-custom boxless">
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_1">
                                <script type="text/javascript" language="javascript" >
                                    $(document).ready(function () {
                                        var dataTable = $('#expense_categories').DataTable({
                                            select: true,
                                            pageLength: 10,
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "Json_data/json_data_records?json_type=expense_categories", // json datasource
                                                type: "post", // method  , by default get
                                                error: function () {  // error handling
                                                    $(".employee-grid-error").html("");
                                                    $("#employee-grid").append('<tbody class="employee-grid-error"><tr><th colspan="6">No data found in the server</th></tr></tbody>');
                                                    $("#employee-grid_processing").css("display", "none");

                                                }
                                            }, "aoColumns": [
                                                {"sTitle": "", "sClass": "hidden"},
                                                {"sTitle": "ID"},
                                                {"sTitle": "Category Name"},
                                                {"sTitle": "Description"},
                                                {"sTitle": "Actions", "sClass": "actionWidthMembers"}
                                            ], "fnCreatedRow": function (nRow, aData, iDataIndex) {
                                                $(nRow).attr('id', '' + aData[0]);

                                            }
                                        });

                                    });
                                </script>
                                
                                <div id="add_new_expense_category" class="modal fade" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                <h4 class="modal-title">Add New Expense Category</h4>
                                            </div>
                                            <form id="add_expense_category" class="form-horizontal" method="post">
                                                <div class="modal-body">
                                                    <div id="response_msg_modal"></div>
                                                    <div class="scroller" style="height:300px" data-always-visible="1" data-rail-visible1="1">
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <div class="form-body">
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Category Name</label>
                                                                        <div class="col-md-6">
                                                                            <input type="text" name="category_name" id="category_name" placeholder="Type here.." class="form-control"/>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row form-group">
                                                                        <label class="col-md-3 control-label pull-left">Description</label>
                                                                        <div class="col-md-6">
                                                                            <textarea name="description" id="description" class="form-control"></textarea>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" data-dismiss="modal" class="btn default">Close</button>
                                                    <button type="submit" class="btn green">Save changes</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="modal fade" id="success_modal" tabindex="-1" role="basic" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                <h4 class="modal-title">Success!</h4>
                                            </div>
                                            <div class="modal-body">
                                                Expense Category Added Successfully
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn green" data-dismiss="modal" onclick="window.location.reload()">Ok</button>
                                            </div>
                                        </div>
                                        <!-- /.modal-content -->
                                    </div>
                                    <!-- /.modal-dialog -->
                                </div>
                                <!-- /.modal -->

                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet box grey-cascade">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="fa fa-money"></i>Expense Categories
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <div class="table-toolbar">
                                            <div class="btn-group">
                                                <a class="btn green" data-toggle="modal" href="#add_new_expense_category">
                                                    Add New <i class="fa fa-plus"></i>
                                                </a>
                                            </div>
                                        </div>
                                        <table id="expense_categories" class="table table-striped table-bordered table-hover"></table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> 
            </div>
            <!-- END DASHBOARD STATS -->
        </div>
    </div>
    <!-- END CONTENT -->
</div>
<!-- END CONTAINER -->